/*
 * Decompiled with CFR 0.152.
 */
package edu.fing.image;

import edu.fing.image.ImageCanvas;
import edu.fing.image.ImageMatrixCanvas;
import edu.fing.image.ImageMatrixEnumeration;
import edu.fing.image.PixelIterator;
import edu.fing.image.PxMImage;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;

public class ImageMatrix {
    public short planes;
    public int width;
    public int height;
    public short[][][] imageData;
    ImageMatrixCanvas canvas;
    public static final int ITERATE_RASTER = 1;
    public static final int ITERATE_HILBERT = 2;
    public static final int ITERATE_BLOCKS = 4;
    public static final int ITERATE_ARGS_MASK = -1024;
    public static final int ITERATE_BLOCKS_SIZE_8 = 1028;
    public static final int ITERATE_BLOCKS_SIZE_16 = 2052;
    public static final int ITERATE_BLOCKS_SIZE_32 = 4100;
    public static final int ITERATE_BLOCKS_SIZE_64 = 8196;
    private static final int HILBERT_UP = 0;
    private static final int HILBERT_DOWN = 1;
    private static final int HILBERT_LEFT = 2;
    private static final int HILBERT_RIGHT = 3;

    public ImageMatrix(int planes, int width, int height) {
        this.initialize(planes, width, height);
    }

    public ImageMatrix(String fileName) {
        this.loadBitmap(fileName);
    }

    public void initialize(int planes, int width, int height) {
        this.planes = (short)planes;
        this.width = width;
        this.height = height;
        this.imageData = new short[planes][height][width];
    }

    public BufferedImage getImage() {
        int[] buffer = new int[this.planes * this.height * this.width];
        int idx = 0;
        for (int j = 0; j < this.height; ++j) {
            for (int i = 0; i < this.width; ++i) {
                for (int k = 0; k < this.planes; ++k) {
                    buffer[idx++] = this.imageData[k][j][i];
                }
            }
        }
        BufferedImage tempImage = new BufferedImage(this.width, this.height, this.planes == 1 ? 10 : 1);
        WritableRaster raster = tempImage.getRaster();
        raster.setPixels(0, 0, this.width, this.height, buffer);
        return tempImage;
    }

    public ImageMatrixCanvas getCanvas() {
        if (this.canvas == null) {
            this.canvas = new ImageMatrixCanvas(this);
        }
        return this.canvas;
    }

    public void loadBitmap(String fileName) {
        Image image = null;
        try {
            image = fileName.toLowerCase().endsWith(".pgm") || fileName.toLowerCase().endsWith(".ppm") ? PxMImage.loadPxM(fileName) : Toolkit.getDefaultToolkit().getImage(fileName);
        }
        catch (IOException e) {
            System.err.println(e.toString());
        }
        if (image == null) {
            throw new Error("No se puede cargar la imagen: " + fileName);
        }
        this.initializeFromImage(image);
    }

    public void initializeFromImage(Image image) {
        if (image instanceof BufferedImage && ((BufferedImage)image).getType() == 10) {
            BufferedImage bufferedImage = (BufferedImage)image;
            this.initialize(1, bufferedImage.getWidth(), bufferedImage.getHeight());
            Raster raster = bufferedImage.getData();
            int[] vector = new int[this.height * this.width];
            raster.getPixels(0, 0, this.width, this.height, vector);
            int idx = 0;
            for (int j = 0; j < this.height; ++j) {
                for (int i = 0; i < this.width; ++i) {
                    this.imageData[0][j][i] = (short)(vector[idx++] & 0xFF);
                }
            }
        } else {
            Component observer = new Component(){};
            MediaTracker tracker = new MediaTracker(observer);
            tracker.addImage(image, 0);
            try {
                tracker.waitForID(0);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.initialize(3, image.getWidth(observer), image.getHeight(observer));
            int[] vector = new int[this.width * this.height];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.width, this.height, vector, 0, this.width);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            int k = 0;
            for (int j = 0; j < this.height; ++j) {
                for (int i = 0; i < this.width; ++i) {
                    int pixel = vector[k++];
                    this.imageData[0][j][i] = (short)(pixel >> 16 & 0xFF);
                    this.imageData[1][j][i] = (short)(pixel >> 8 & 0xFF);
                    this.imageData[2][j][i] = (short)(pixel & 0xFF);
                }
            }
        }
    }

    public int getCantPixels() {
        return this.planes * this.width * this.height;
    }

    public ImageMatrixEnumeration getPixelEnumerator(int iterateType) {
        return new ImageMatrixEnumeration(this, iterateType);
    }

    public static PixelIterator getApplyFilterIterator() {
        return new PixelIterator(){

            public void processPixel(ImageMatrix image, int k, int j, int i, short pixel) {
                image.imageData[k][j][i] = pixel;
            }
        };
    }

    public void iterate(int iterateType, PixelIterator iterator) {
        switch (iterateType & 0x3FF) {
            case 4: {
                this.iterateBlocks(iterator, iterateType & 0xFFFFFC00);
                break;
            }
            case 1: {
                this.iterateRaster(iterator);
                break;
            }
            case 2: {
                this.iterateHilbert(iterator);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized iterate type: " + iterateType);
            }
        }
    }

    public void iterateCompose(int iterateTypeF, final int iterateTypeG, final int widthG, final int heightG, final PixelIterator iterator) {
        final ImageMatrix tempImage = new ImageMatrix(1, widthG, heightG);
        ImageMatrix iterateImage = new ImageMatrix(this.planes, (this.width + widthG - 1) / widthG, (this.height + heightG - 1) / heightG);
        iterateImage.iterate(iterateTypeF, new PixelIterator(){

            public void processPixel(ImageMatrix image, int k, int j, int i, short pixelValue) {
                final int fromY = j * heightG;
                final int fromX = i * widthG;
                final int curK = k;
                tempImage.iterate(iterateTypeG, new PixelIterator(){

                    public void processPixel(ImageMatrix image, int k, int j, int i, short pixelValue) {
                        if (fromY + j >= ImageMatrix.this.height || fromX + i >= ImageMatrix.this.width) {
                            return;
                        }
                        iterator.processPixel(ImageMatrix.this, k, fromY + j, fromX + i, ImageMatrix.this.imageData[curK][fromY + j][fromX + i]);
                    }
                });
            }
        });
    }

    private void iterateBlocks(PixelIterator iterator, int arg) {
        if (arg == 0) {
            arg = 1028;
        }
        int ITERATE_BLOCKS_SIZE = arg >> 7;
        for (int k = 0; k < this.planes; ++k) {
            for (int j = 0; j < this.height / ITERATE_BLOCKS_SIZE; ++j) {
                for (int i = 0; i < this.width / ITERATE_BLOCKS_SIZE; ++i) {
                    for (int y = 0; y < ITERATE_BLOCKS_SIZE; ++y) {
                        for (int x = 0; x < ITERATE_BLOCKS_SIZE; ++x) {
                            iterator.processPixel(this, k, j * ITERATE_BLOCKS_SIZE + y, i * ITERATE_BLOCKS_SIZE + x, this.imageData[k][j * ITERATE_BLOCKS_SIZE + y][i * ITERATE_BLOCKS_SIZE + x]);
                        }
                    }
                }
            }
        }
    }

    private void iterateRaster(PixelIterator iterator) {
        for (int k = 0; k < this.planes; ++k) {
            for (int j = 0; j < this.height; ++j) {
                for (int i = 0; i < this.width; ++i) {
                    iterator.processPixel(this, k, j, i, this.imageData[k][j][i]);
                }
            }
        }
    }

    private void iterateHilbert(PixelIterator iterator) {
        int hilbertSize = (int)this.log2(Math.min(this.width, this.height));
        for (int curK = 0; curK < this.planes; ++curK) {
            int i;
            int curSize;
            int j;
            Point hilbertPos = new Point(0, 0);
            iterator.processPixel(this, curK, hilbertPos.y, hilbertPos.x, this.imageData[curK][hilbertPos.y][hilbertPos.x]);
            this.doHilbert(iterator, curK, hilbertPos, hilbertSize, 0);
            for (j = curSize = (int)Math.pow(2.0, hilbertSize); j < this.height; ++j) {
                for (i = 0; i < this.width; ++i) {
                    iterator.processPixel(this, curK, j, i, this.imageData[curK][j][i]);
                }
            }
            for (j = 0; j < curSize; ++j) {
                for (i = curSize; i < this.width; ++i) {
                    iterator.processPixel(this, curK, j, i, this.imageData[curK][j][i]);
                }
            }
        }
    }

    private void doHilbert(PixelIterator iterator, int curK, Point hilbertPos, int hilbertSize, int hilbertDir) {
        if (hilbertSize == 1) {
            switch (hilbertDir) {
                case 2: {
                    this.hilbertMove(iterator, curK, hilbertPos, 3);
                    this.hilbertMove(iterator, curK, hilbertPos, 1);
                    this.hilbertMove(iterator, curK, hilbertPos, 2);
                    break;
                }
                case 3: {
                    this.hilbertMove(iterator, curK, hilbertPos, 2);
                    this.hilbertMove(iterator, curK, hilbertPos, 0);
                    this.hilbertMove(iterator, curK, hilbertPos, 3);
                    break;
                }
                case 0: {
                    this.hilbertMove(iterator, curK, hilbertPos, 1);
                    this.hilbertMove(iterator, curK, hilbertPos, 3);
                    this.hilbertMove(iterator, curK, hilbertPos, 0);
                    break;
                }
                case 1: {
                    this.hilbertMove(iterator, curK, hilbertPos, 0);
                    this.hilbertMove(iterator, curK, hilbertPos, 2);
                    this.hilbertMove(iterator, curK, hilbertPos, 1);
                }
            }
        } else {
            switch (hilbertDir) {
                case 2: {
                    this.doHilbert(iterator, curK, hilbertPos, hilbertSize - 1, 0);
                    this.hilbertMove(iterator, curK, hilbertPos, 3);
                    this.doHilbert(iterator, curK, hilbertPos, hilbertSize - 1, 2);
                    this.hilbertMove(iterator, curK, hilbertPos, 1);
                    this.doHilbert(iterator, curK, hilbertPos, hilbertSize - 1, 2);
                    this.hilbertMove(iterator, curK, hilbertPos, 2);
                    this.doHilbert(iterator, curK, hilbertPos, hilbertSize - 1, 1);
                    break;
                }
                case 3: {
                    this.doHilbert(iterator, curK, hilbertPos, hilbertSize - 1, 1);
                    this.hilbertMove(iterator, curK, hilbertPos, 2);
                    this.doHilbert(iterator, curK, hilbertPos, hilbertSize - 1, 3);
                    this.hilbertMove(iterator, curK, hilbertPos, 0);
                    this.doHilbert(iterator, curK, hilbertPos, hilbertSize - 1, 3);
                    this.hilbertMove(iterator, curK, hilbertPos, 3);
                    this.doHilbert(iterator, curK, hilbertPos, hilbertSize - 1, 0);
                    break;
                }
                case 0: {
                    this.doHilbert(iterator, curK, hilbertPos, hilbertSize - 1, 2);
                    this.hilbertMove(iterator, curK, hilbertPos, 1);
                    this.doHilbert(iterator, curK, hilbertPos, hilbertSize - 1, 0);
                    this.hilbertMove(iterator, curK, hilbertPos, 3);
                    this.doHilbert(iterator, curK, hilbertPos, hilbertSize - 1, 0);
                    this.hilbertMove(iterator, curK, hilbertPos, 0);
                    this.doHilbert(iterator, curK, hilbertPos, hilbertSize - 1, 3);
                    break;
                }
                case 1: {
                    this.doHilbert(iterator, curK, hilbertPos, hilbertSize - 1, 3);
                    this.hilbertMove(iterator, curK, hilbertPos, 0);
                    this.doHilbert(iterator, curK, hilbertPos, hilbertSize - 1, 1);
                    this.hilbertMove(iterator, curK, hilbertPos, 2);
                    this.doHilbert(iterator, curK, hilbertPos, hilbertSize - 1, 1);
                    this.hilbertMove(iterator, curK, hilbertPos, 1);
                    this.doHilbert(iterator, curK, hilbertPos, hilbertSize - 1, 2);
                }
            }
        }
    }

    private void hilbertMove(PixelIterator iterator, int curK, Point hilbertPos, int hilbertDir) {
        switch (hilbertDir) {
            case 0: {
                hilbertPos.translate(0, -1);
                break;
            }
            case 1: {
                hilbertPos.translate(0, 1);
                break;
            }
            case 2: {
                hilbertPos.translate(-1, 0);
                break;
            }
            case 3: {
                hilbertPos.translate(1, 0);
            }
        }
        iterator.processPixel(this, curK, hilbertPos.y, hilbertPos.x, this.imageData[curK][hilbertPos.y][hilbertPos.x]);
    }

    private double log2(double value) {
        return Math.log(value) / Math.log(2.0);
    }

    public ImageMatrix newSameSize() {
        return new ImageMatrix(this.planes, this.width, this.height);
    }

    public void showImage(String title) {
        ImageCanvas.showImage(title, this.getImage());
    }
}

