/*
 * Decompiled with CFR 0.152.
 */
package edu.fing.image;

import edu.fing.image.ImageMatrix;
import edu.fing.image.PixelIterator;
import java.awt.Point;
import java.awt.Rectangle;

public class ImageOperations {
    public static ImageMatrix mixImages(ImageMatrix inImage1, ImageMatrix inImage2, int scaleFactor, final double ratio) {
        final ImageMatrix image1 = ImageOperations.assureSquaredSize(ImageOperations.scaleDown(inImage1, scaleFactor), false);
        final ImageMatrix image2 = ImageOperations.assureSquaredSize(ImageOperations.scaleDown(inImage2, scaleFactor), false);
        if (image1.width != image2.width || image1.height != image2.height) {
            throw new IllegalArgumentException("Las imagenes no son de size compatible");
        }
        ImageMatrix imageMixed = image1.newSameSize();
        imageMixed.iterate(1, new PixelIterator(){

            public void processPixel(ImageMatrix image, int k, int j, int i, short pixelValue) {
                image.imageData[k][j][i] = (double)i / (double)image.width >= ratio ? image1.imageData[k][j][i] : image2.imageData[k][j][i];
            }
        });
        ImageOperations.swapBlock(imageMixed, new Rectangle(0, imageMixed.height / 2, imageMixed.width / 2, imageMixed.height / 2), new Point(imageMixed.width / 2, imageMixed.height / 2));
        return imageMixed;
    }

    public static ImageMatrix assureSquaredSize(ImageMatrix image) {
        return ImageOperations.assureSquaredSize(image, true);
    }

    public static ImageMatrix assureSquaredSize(ImageMatrix image, boolean setGrayscale) {
        if (setGrayscale && image.planes != 1) {
            ImageMatrix temp = new ImageMatrix(1, image.width, image.height);
            for (int j = 0; j < image.height; ++j) {
                for (int i = 0; i < image.width; ++i) {
                    int sum = 0;
                    for (int k = 0; k < image.planes; ++k) {
                        sum += image.imageData[k][j][i];
                    }
                    temp.imageData[0][j][i] = (short)(sum / image.planes);
                }
            }
            image = temp;
        }
        int size = (int)Math.pow(2.0, (int)(Math.log(Math.min(image.width, image.height)) / Math.log(2.0)));
        if (image.width == image.height && image.width == size) {
            return image;
        }
        final ImageMatrix temp = new ImageMatrix(image.planes, size, size);
        final ImageMatrix im = image;
        temp.iterate(1, new PixelIterator(){

            public void processPixel(ImageMatrix image, int k, int j, int i, short pixelValue) {
                temp.imageData[k][j][i] = im.imageData[k][j][i];
            }
        });
        return temp;
    }

    public static void swapBlock(ImageMatrix image, Rectangle from, Point to) {
        from.width = Math.min(from.width, image.width - from.x);
        from.width = Math.min(from.width, image.width - to.x);
        from.height = Math.min(from.height, image.height - from.y);
        from.height = Math.min(from.height, image.height - to.y);
        for (int k = 0; k < image.planes; ++k) {
            for (int j = 0; j < from.height; ++j) {
                for (int i = 0; i < from.width; ++i) {
                    short tempValue = image.imageData[k][to.y + j][to.x + i];
                    image.imageData[k][to.y + j][to.x + i] = image.imageData[k][from.y + j][from.x + i];
                    image.imageData[k][from.y + j][from.x + i] = tempValue;
                }
            }
        }
    }

    public static void copyBlock(ImageMatrix source, ImageMatrix dest, Rectangle from, Point to) {
        from.width = Math.min(from.width, source.width - from.x);
        from.width = Math.min(from.width, dest.width - to.x);
        from.height = Math.min(from.height, source.height - from.y);
        from.height = Math.min(from.height, dest.height - to.y);
        for (int k = 0; k < source.planes; ++k) {
            for (int j = 0; j < from.height; ++j) {
                for (int i = 0; i < from.width; ++i) {
                    dest.imageData[k][to.y + j][to.x + i] = source.imageData[k][from.y + j][from.x + i];
                }
            }
        }
    }

    public static ImageMatrix copyImage(ImageMatrix image) {
        ImageMatrix outImage = new ImageMatrix(image.planes, image.width, image.height);
        for (int k = 0; k < image.planes; ++k) {
            for (int j = 0; j < image.height; ++j) {
                for (int i = 0; i < image.width; ++i) {
                    outImage.imageData[k][j][i] = image.imageData[k][j][i];
                }
            }
        }
        return outImage;
    }

    public static void copyImage(ImageMatrix source, ImageMatrix dest) {
        for (int k = 0; k < source.planes; ++k) {
            for (int j = 0; j < source.height; ++j) {
                for (int i = 0; i < source.width; ++i) {
                    dest.imageData[k][j][i] = source.imageData[k][j][i];
                }
            }
        }
    }

    public static void copyPlane(ImageMatrix source, int sourcePlane, ImageMatrix dest, int destPlane) {
        for (int j = 0; j < source.height; ++j) {
            for (int i = 0; i < source.width; ++i) {
                dest.imageData[destPlane][j][i] = source.imageData[sourcePlane][j][i];
            }
        }
    }

    public static ImageMatrix scaleUp(final ImageMatrix image, int scaleFactor) {
        if (scaleFactor > 1) {
            final int lev = scaleFactor - 1;
            ImageMatrix processImage = new ImageMatrix(image.planes, image.width << lev, image.height << lev);
            processImage.iterate(1, new PixelIterator(){

                public void processPixel(ImageMatrix img, int k, int j, int i, short pixelValue) {
                    img.imageData[k][j][i] = image.imageData[k][j >> lev][i >> lev];
                }
            });
            return processImage;
        }
        return image;
    }

    public static ImageMatrix scaleDown(final ImageMatrix image, int scaleFactor) {
        if (scaleFactor > 1) {
            final int lev = scaleFactor - 1;
            ImageMatrix processImage = new ImageMatrix(image.planes, image.width >> lev, image.height >> lev);
            processImage.iterate(1, new PixelIterator(){

                public void processPixel(ImageMatrix img, int k, int j, int i, short pixelValue) {
                    img.imageData[k][j][i] = image.imageData[k][j << lev][i << lev];
                }
            });
            return processImage;
        }
        return image;
    }
}

