/*
 * Decompiled with CFR 0.152.
 */
package edu.fing.image;

import edu.fing.image.EuclideanD;
import edu.fing.image.FunctionD;
import edu.fing.image.FunctionR;
import edu.fing.image.ImageMatrix;
import edu.fing.image.ImageMatrixFP;
import edu.fing.image.LinearR;
import edu.fing.image.ManhattanD;
import edu.fing.image.MaximumD;
import edu.fing.image.PixelIteratorFP;
import edu.fing.image.PxMImage;
import edu.fing.image.SignumR;
import edu.fing.image.SlopeR;
import java.io.File;
import java.math.BigDecimal;
import java.math.MathContext;

public class ACE {
    boolean USE_BIG_DECIMAL = false;
    boolean USE_ALL_IMAGE = true;
    int SIZE_X = this.USE_ALL_IMAGE ? 5000 : 200;
    int SIZE_Y = this.USE_ALL_IMAGE ? 5000 : 200;
    ImageMatrixFP image;
    ImageMatrixFP RC;
    ImageMatrix OC;
    FunctionR r;
    FunctionD d;

    public ACE(ImageMatrixFP image, FunctionR r, FunctionD d) {
        this.image = image;
        this.r = r;
        this.d = d;
    }

    public ACE(ImageMatrixFP image, FunctionR r, FunctionD d, int radio) {
        this.image = image;
        this.r = r;
        this.d = d;
        this.SIZE_X = radio;
        this.SIZE_Y = radio;
    }

    public void calcularRC() {
        System.out.println("Aplicando ajuste cromatico/espacial");
        this.RC = this.image.newSameSize();
        final MathContext context = MathContext.DECIMAL128;
        final BigDecimal rMax = new BigDecimal(this.r.rMax(), context);
        this.image.iterate(1, new PixelIteratorFP(){

            public void processPixel(ImageMatrixFP image, int pk, int pj, int pi, double ppixelValue) {
                double[] sumJ = new double[]{0.0};
                double[] divJ = new double[]{0.0};
                BigDecimal[] bsumJ = new BigDecimal[]{BigDecimal.ZERO};
                BigDecimal[] bdivJ = new BigDecimal[]{BigDecimal.ZERO};
                int fromY = pj - ACE.this.SIZE_Y;
                int toY = pj + ACE.this.SIZE_Y;
                int fromX = pi - ACE.this.SIZE_X;
                int toX = pi + ACE.this.SIZE_X;
                if (fromY < 0) {
                    fromY = 0;
                }
                if (toY > image.height) {
                    toY = image.height;
                }
                if (fromX < 0) {
                    fromX = 0;
                }
                if (toX > image.width) {
                    toX = image.width;
                }
                for (int jj = fromY; jj < toY; ++jj) {
                    for (int ji = fromX; ji < toX; ++ji) {
                        if (jj == pj && ji == pi) continue;
                        double jpixelValue = image.imageData[pk][jj][ji];
                        double dpj = ACE.this.d.d(pi, pj, ji, jj);
                        if (ACE.this.USE_BIG_DECIMAL) {
                            BigDecimal bdpj = new BigDecimal(dpj, context);
                            bsumJ[0] = bsumJ[0].add(new BigDecimal(ACE.this.r.r(ppixelValue - jpixelValue)).divide(bdpj, context));
                            bdivJ[0] = bdivJ[0].add(rMax.divide(bdpj, context));
                            continue;
                        }
                        sumJ[0] = sumJ[0] + ACE.this.r.r(ppixelValue - jpixelValue) / dpj;
                        divJ[0] = divJ[0] + ACE.this.r.rMax() / dpj;
                    }
                }
                ACE.this.RC.imageData[pk][pj][pi] = ACE.this.USE_BIG_DECIMAL ? bsumJ[0].divide(bdivJ[0], context).doubleValue() : sumJ[0] / divJ[0];
                System.out.print(pk + ": (" + pj + ")" + "    \r");
            }
        });
    }

    public void calcularOC() {
        int pixelValue;
        int i;
        int j;
        this.OC = new ImageMatrix(this.RC.planes, this.RC.width, this.RC.height);
        boolean INDEPENDENT = true;
        double max = -1.7976931348623157E308;
        double min = Double.MAX_VALUE;
        for (int k = 0; k < this.RC.planes; ++k) {
            for (int j2 = 0; j2 < this.RC.height; ++j2) {
                for (int i2 = 0; i2 < this.RC.width; ++i2) {
                    if (this.RC.imageData[k][j2][i2] > max) {
                        max = this.RC.imageData[k][j2][i2];
                    }
                    if (!(this.RC.imageData[k][j2][i2] < min)) continue;
                    min = this.RC.imageData[k][j2][i2];
                }
            }
            if (!INDEPENDENT) continue;
            double Mc = max;
            double mc = min;
            double sc = 255.0 / (Mc - mc);
            for (j = 0; j < this.RC.height; ++j) {
                for (i = 0; i < this.RC.width; ++i) {
                    pixelValue = (short)Math.round(127.5 + 127.5 * this.RC.imageData[k][j][i] / Mc);
                    if (pixelValue < 0) {
                        pixelValue = 0;
                    } else if (pixelValue > 255) {
                        pixelValue = 255;
                    }
                    this.OC.imageData[k][j][i] = pixelValue;
                }
            }
            max = -1.7976931348623157E308;
            min = Double.MAX_VALUE;
        }
        if (!INDEPENDENT) {
            double Mc = max;
            double mc = min;
            double sc = 255.0 / (Mc - mc);
            for (int k = 0; k < this.RC.planes; ++k) {
                for (j = 0; j < this.RC.height; ++j) {
                    for (i = 0; i < this.RC.width; ++i) {
                        pixelValue = (int)Math.round(127.5 + sc * this.RC.imageData[k][j][i]);
                        if (pixelValue < 0) {
                            pixelValue = 0;
                        } else if (pixelValue > 255) {
                            pixelValue = 255;
                        }
                        this.OC.imageData[k][j][i] = pixelValue;
                    }
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            int curArg;
            System.out.println("ACE v1.0, (u)2011 Gustavo Brown");
            System.out.println();
            FunctionR funcR = new SlopeR(5.0);
            FunctionD funcD = new EuclideanD();
            int radio = 5000;
            boolean isBatch = false;
            for (curArg = 0; curArg < args.length && args[curArg].startsWith("-"); ++curArg) {
                String arg = args[curArg].toLowerCase();
                if (arg.startsWith("-p")) {
                    radio = Integer.parseInt(arg.substring(2));
                    continue;
                }
                if (arg.equals("-rs")) {
                    funcR = new SignumR();
                    continue;
                }
                if (arg.equals("-rl")) {
                    funcR = new LinearR();
                    continue;
                }
                if (arg.equals("-rsl")) {
                    funcR = new SlopeR(Integer.parseInt(arg.substring(4)));
                    continue;
                }
                if (arg.equals("-de")) {
                    funcD = new EuclideanD();
                    continue;
                }
                if (arg.equals("-dm")) {
                    funcD = new ManhattanD();
                    continue;
                }
                if (arg.equals("-dmax")) {
                    funcD = new MaximumD();
                    continue;
                }
                if (arg.equals("-b")) {
                    isBatch = true;
                    continue;
                }
                System.out.println("ERROR procesando argumento:" + arg);
            }
            if (curArg > args.length - 2) {
                System.out.println("USO: edu.fing.image.ACE [argumentos] ImagenEntrada ImagenSalida");
                System.out.println("\nArgumentos:");
                System.out.println("\t-pNNN  utilizar NNN pixels de lado para el conjunto");
                System.out.println("\t-r{s|l|slNN}  indica la funcion R: s=signo, l=lineal, slNN=slope con pendiente NN");
                System.out.println("\t-d{e|m|max}  indica la funcion de distancia: e=euclidea, m=Manhattan, max=Maximum");
                System.out.println("\t-b   indica modo batch (no muestra las imagenes)");
                System.out.println("\nValores por defecto: r=slope(5) y d=euclidea\n\n");
                System.exit(1);
            }
            String nomIn = args[curArg];
            String nomOut = args[curArg + 1];
            System.out.println("Archivo de entrada: " + nomIn);
            System.out.println("Archivo de salida: " + nomOut);
            System.out.println();
            if (!new File(nomIn).exists()) {
                System.out.println("No existe el archivo de entrada: " + nomIn);
                System.exit(1);
            }
            ImageMatrixFP imageIn = new ImageMatrixFP(nomIn);
            if (!isBatch) {
                imageIn.showImage("Entrada");
            }
            System.out.println("Tama\u00f1o imagen entrada: " + imageIn.width + " x " + imageIn.height);
            ACE ace = new ACE(imageIn, funcR, funcD, radio);
            ace.calcularRC();
            if (!isBatch) {
                ace.RC.showImage("Rc");
            }
            ace.calcularOC();
            if (!isBatch) {
                ace.OC.showImage("Resultado ACE");
            }
            PxMImage.saveAs(ace.OC, nomOut);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

