/*
 * Decompiled with CFR 0.152.
 */
package edu.fing.image;

import edu.fing.image.ImageMatrix;
import edu.fing.image.PixelIterator;
import edu.fing.image.PxMImage;
import java.io.File;

public class ACS {
    boolean useVicinity;
    boolean greyWorld = true;
    int descarte;
    ImageMatrix image;
    ImageMatrix salida;
    public static double PIXEL_TOTAL_WEIGHT = 8.5;

    public ACS(ImageMatrix image, int descarte, boolean useVicinity, boolean greyWorld) {
        this.image = image;
        this.descarte = descarte;
        this.useVicinity = useVicinity;
        this.greyWorld = greyWorld;
    }

    public double computePixel(ImageMatrix image, int k, int j, int i, short pixelValue) {
        if (!this.useVicinity) {
            return pixelValue;
        }
        int newValue = pixelValue << 2;
        newValue = j > 0 ? (j < image.height - 1 ? (newValue += image.imageData[k][j - 1][i] + image.imageData[k][j + 1][i]) : (newValue += image.imageData[k][j - 1][i] << 1)) : (newValue += image.imageData[k][j + 1][i] << 1);
        newValue = i > 0 ? (i < image.width - 1 ? (newValue += image.imageData[k][j][i - 1] + image.imageData[k][j][i + 1]) : (newValue += image.imageData[k][j][i - 1] << 1)) : (newValue += image.imageData[k][j][i + 1] << 1);
        return (double)newValue / PIXEL_TOTAL_WEIGHT;
    }

    public void stretch() {
        this.salida = this.image.newSameSize();
        final int bucketSize = this.useVicinity ? (int)(256.0 * PIXEL_TOTAL_WEIGHT) : 256;
        final int[][] histograma = new int[this.image.planes][bucketSize];
        System.out.println("Calculando histograma");
        this.image.iterate(1, new PixelIterator(){

            public void processPixel(ImageMatrix image, int k, int j, int i, short pixelValue) {
                if (ACS.this.greyWorld && ACS.this.useVicinity) {
                    int[] nArray = histograma[k];
                    int n = (int)(PIXEL_TOTAL_WEIGHT * ACS.this.computePixel(image, k, j, i, pixelValue));
                    nArray[n] = nArray[n] + 1;
                } else {
                    int[] nArray = histograma[k];
                    short s = pixelValue;
                    nArray[s] = nArray[s] + 1;
                }
            }
        });
        int totalPixels = this.image.width * this.image.height;
        int pixelsFuera = (int)((double)totalPixels * ((double)this.descarte / 1000.0));
        System.out.println("Total " + totalPixels + " - descarte: " + pixelsFuera);
        final int[] left = new int[3];
        final int[] right = new int[3];
        final int[] rango = new int[3];
        final int[] greyWorldMedian = new int[3];
        for (int k = 0; k < this.image.planes; ++k) {
            int sum;
            System.out.println("Calculando rango plano " + k);
            left[k] = 0;
            right[k] = bucketSize - 1;
            for (sum = 0; sum < pixelsFuera; sum += histograma[k][left[k]]) {
                int n = k;
                left[n] = left[n] + 1;
            }
            if (left[k] > 0) {
                int n = k;
                left[n] = left[n] - 1;
            }
            for (sum = 0; sum < pixelsFuera; sum += histograma[k][right[k]]) {
                int n = k;
                right[n] = right[n] - 1;
            }
            if (right[k] < bucketSize - 1) {
                int n = k;
                right[n] = right[n] + 1;
            }
            rango[k] = right[k] - left[k];
            System.out.println("Rango: " + left[k] + " - " + right[k] + " => " + rango[k]);
            if (!this.greyWorld) continue;
            int greyWorldPixels = totalPixels >> 1;
            greyWorldMedian[k] = 0;
            for (int sum2 = 0; sum2 < greyWorldPixels; sum2 += histograma[k][greyWorldMedian[k]]) {
                int n = k;
                greyWorldMedian[n] = greyWorldMedian[n] + 1;
            }
            System.out.println("Median: " + greyWorldMedian[k]);
        }
        this.image.iterate(1, new PixelIterator(){

            public void processPixel(ImageMatrix image, int k, int j, int i, short pixelValue) {
                if (ACS.this.greyWorld) {
                    double kgreyWorldMedian = greyWorldMedian[k] / (bucketSize >> 8);
                    double kleft = left[k] / (bucketSize >> 8);
                    double kright = right[k] / (bucketSize >> 8);
                    double curPixel = ACS.this.computePixel(image, k, j, i, pixelValue);
                    curPixel = curPixel < kgreyWorldMedian ? (curPixel - kleft) / (kgreyWorldMedian - kleft) / 2.0 : 1.0 - 0.5 * ((kright - curPixel) / (kright - kgreyWorldMedian));
                    short newPixel = (short)(255.0 * curPixel);
                    ACS.this.salida.imageData[k][j][i] = newPixel < 0 ? 0 : (newPixel > 255 ? 255 : (int)newPixel);
                } else {
                    short newPixel = (short)(255.0 * (ACS.this.computePixel(image, k, j, i, pixelValue) - (double)left[k]) / (double)rango[k]);
                    ACS.this.salida.imageData[k][j][i] = newPixel < 0 ? 0 : (newPixel > 255 ? 255 : (int)newPixel);
                }
            }
        });
    }

    public static void main(String[] args) {
        try {
            int curArg;
            System.out.println("ACS v1.0, (u)2011 Gustavo Brown");
            System.out.println();
            int descarte = 10;
            boolean isBatch = false;
            boolean useVicinity = false;
            boolean greyWorld = true;
            for (curArg = 0; curArg < args.length && args[curArg].startsWith("-"); ++curArg) {
                String arg = args[curArg].toLowerCase();
                if (arg.startsWith("-p")) {
                    descarte = Integer.parseInt(arg.substring(2));
                    continue;
                }
                if (arg.equals("-r")) {
                    useVicinity = true;
                    continue;
                }
                if (arg.equals("-b")) {
                    isBatch = true;
                    continue;
                }
                if (arg.equals("-ng")) {
                    greyWorld = false;
                    continue;
                }
                System.out.println("ERROR procesando argumento:" + arg);
            }
            if (curArg > args.length - 2) {
                System.out.println("USO: edu.fing.image.ACS [argumentos] ImagenEntrada ImagenSalida");
                System.out.println("\nArgumentos:");
                System.out.println("\t-pNN  descartar NN por mil del histograma para encontrar rango");
                System.out.println("\t-r    utilizar vecindario para cada pixel");
                System.out.println("\t-ng   no usar modo 'grey world'");
                System.out.println("\t-b    indica modo batch (no muestra las imagenes)");
                System.out.println("\nValores por defecto: -p10 \n\n");
                System.exit(1);
            }
            String nomIn = args[curArg];
            String nomOut = args[curArg + 1];
            System.out.println("Archivo de entrada: " + nomIn);
            System.out.println("Archivo de salida: " + nomOut);
            System.out.println();
            if (!new File(nomIn).exists()) {
                System.out.println("No existe el archivo de entrada: " + nomIn);
                System.exit(1);
            }
            ImageMatrix imageIn = new ImageMatrix(nomIn);
            if (!isBatch) {
                imageIn.showImage("Entrada");
            }
            System.out.println("Tama\u00f1o imagen entrada: " + imageIn.width + " x " + imageIn.height);
            ACS acs = new ACS(imageIn, descarte, useVicinity, greyWorld);
            acs.stretch();
            if (!isBatch) {
                acs.salida.showImage("Resultado ACS");
            }
            PxMImage.saveAs(acs.salida, nomOut);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

