/*
 * Decompiled with CFR 0.152.
 */
package edu.fing.image;

import edu.fing.image.ImageMatrix;
import edu.fing.image.ImageMatrixEnumerationItem;
import edu.fing.image.PixelIterator;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class ImageMatrixEnumeration
extends Thread
implements Enumeration,
PixelIterator {
    public int iterateType;
    public ImageMatrix image;
    private ImageMatrixEnumerationItem nextElement;
    private Object lock = new Object();
    public static int uid = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageMatrixEnumeration(ImageMatrix image, int iterateType) {
        super("ImageMatrixEnumeration-" + uid++);
        this.image = image;
        this.iterateType = iterateType;
        Object object = this.lock;
        synchronized (object) {
            this.start();
            try {
                this.lock.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public boolean hasMoreElements() {
        return this.nextElement != null;
    }

    public ImageMatrixEnumerationItem nextItem() {
        return (ImageMatrixEnumerationItem)this.nextElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object nextElement() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("No hay mas elementos en el iterador de imagen (" + this.toString() + ")");
            }
            ImageMatrixEnumerationItem retItem = this.nextElement;
            this.nextElement = null;
            this.lock.notify();
            try {
                this.lock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return retItem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.lock;
        synchronized (object) {
            this.image.iterate(this.iterateType, this);
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPixel(ImageMatrix image, int k, int j, int i, short pixelValue) {
        Object object = this.lock;
        synchronized (object) {
            this.nextElement = new ImageMatrixEnumerationItem(image, k, j, i, pixelValue);
            this.lock.notify();
            try {
                this.lock.wait();
                this.lock.notify();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }
}

