/*
 * Decompiled with CFR 0.152.
 */
package edu.fing.image;

import java.awt.Canvas;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class ImageCanvas
extends Canvas {
    public static Point initialLocation = new Point(0, 0);
    Image img;
    Image imgToShow;

    public ImageCanvas(Image img) {
        this.img = img;
        this.setSize(img.getWidth(this), img.getHeight(this));
        this.imgToShow = img;
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                ImageCanvas.this.rescale();
            }
        });
    }

    public void paint(Graphics g) {
        g.drawImage(this.imgToShow, 0, 0, this);
    }

    public void rescale() {
        this.imgToShow = this.img.getScaledInstance(this.getWidth(), this.getHeight(), 0);
    }

    public static void showImage(Image image) {
        ImageCanvas.showImage("ImageShow", image);
    }

    public static void showImage(String title, Image image) {
        try {
            Frame frame = new Frame(title);
            frame.add(new ImageCanvas(image));
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    evt.getWindow().dispose();
                }
            });
            frame.setLocation(initialLocation);
            initialLocation.translate(40, 20);
            frame.pack();
            frame.show();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

