/*
 * Decompiled with CFR 0.152.
 */
package edu.fing.image;

import edu.fing.image.ImageMatrix;
import edu.fing.image.ImageOperations;
import edu.fing.image.PixelIterator;
import java.awt.Canvas;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;

public class ImageMatrixCanvas
extends Canvas {
    public ImageMatrix image;
    public ActionListener specificListener;
    private ImageMatrix changeDetector;
    private Image img;
    private Image imgToShow;
    public static Vector mouseListeners = new Vector();
    boolean imageChanged;
    public Frame frame;

    public static void addActionListener(ActionListener listener) {
        mouseListeners.addElement(listener);
    }

    public static void removeActionListener(ActionListener listener) {
        mouseListeners.remove(listener);
    }

    public static void removeAllActionListeners() {
        mouseListeners.removeAllElements();
    }

    public void setSpecificActionListener(ActionListener listener) {
        this.specificListener = listener;
    }

    public ImageMatrixCanvas(ImageMatrix image) {
        this.image = image;
        this.changeDetector = ImageOperations.copyImage(image);
        this.img = this.img = image.getImage();
        this.setSize(this.img.getWidth(this), this.img.getHeight(this));
        this.rescale();
        this.imgToShow = this.img;
        this.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            public void ancestorResized(HierarchyEvent evt) {
                ImageMatrixCanvas.this.rescale();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                ImageMatrixCanvas.this.rescale();
            }
        });
        super.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2) {
                    return;
                }
                ActionEvent actionEvent = new ActionEvent(ImageMatrixCanvas.this, e.getButton(), "MouseClicked");
                if (ImageMatrixCanvas.this.specificListener != null) {
                    ImageMatrixCanvas.this.specificListener.actionPerformed(actionEvent);
                    return;
                }
                Enumeration enumi = mouseListeners.elements();
                while (enumi.hasMoreElements()) {
                    ActionListener listener = (ActionListener)enumi.nextElement();
                    listener.actionPerformed(actionEvent);
                }
            }
        });
    }

    public boolean imageChanged() {
        this.imageChanged = false;
        if (this.image.width != this.changeDetector.width || this.image.height != this.changeDetector.height) {
            this.changeDetector = ImageOperations.copyImage(this.image);
            return true;
        }
        this.image.iterate(1, new PixelIterator(){

            public void processPixel(ImageMatrix image, int k, int j, int i, short pixelValue) {
                if (((ImageMatrixCanvas)ImageMatrixCanvas.this).changeDetector.imageData[k][j][i] != pixelValue) {
                    ImageMatrixCanvas.this.imageChanged = true;
                }
                ((ImageMatrixCanvas)ImageMatrixCanvas.this).changeDetector.imageData[k][j][i] = pixelValue;
            }
        });
        return this.imageChanged;
    }

    public boolean needsRepaint() {
        if (this.image.width != this.changeDetector.width || this.image.height != this.changeDetector.height) {
            this.changeDetector = ImageOperations.copyImage(this.image);
            return true;
        }
        for (int k = 0; k < this.image.planes; ++k) {
            for (int j = 0; j < this.image.height; ++j) {
                for (int i = 0; i < this.image.width; ++i) {
                    if (this.changeDetector.imageData[k][j][i] == this.image.imageData[k][j][i]) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void paint(Graphics g) {
        g.drawImage(this.imgToShow, 0, 0, this);
        if (this.imageChanged()) {
            this.img = this.image.getImage();
            this.rescale();
            g.drawImage(this.imgToShow, 0, 0, this);
        }
    }

    public void redraw() {
        this.img = this.image.getImage();
        this.rescale();
    }

    public void rescale() {
        this.imgToShow = this.img.getScaledInstance(this.getWidth(), this.getHeight(), 0);
    }

    public void setTitle(String title) {
        this.frame.setTitle(title);
    }

    public void showImage(String title) {
        if (this.frame == null) {
            this.frame = new Frame(title);
            this.frame.add(this);
            this.frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    evt.getWindow().dispose();
                    ImageMatrixCanvas.this.frame = null;
                }
            });
            this.frame.pack();
            this.frame.show();
        } else {
            this.repaint();
        }
    }

    public void close() {
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
        }
    }
}

