package edu.fing.image;

import java.io.*;

public class ACS
{
    boolean useVicinity;
    boolean greyWorld = true;
    int descarte;

    ImageMatrix image;
    ImageMatrix salida;
    public ACS(ImageMatrix image, int descarte, boolean useVicinity, boolean greyWorld)
    {
        this.image = image;
        this.descarte = descarte;
        this.useVicinity = useVicinity;
        this.greyWorld = greyWorld;
    }

    public static double PIXEL_TOTAL_WEIGHT = 8.5;
    public double computePixel(ImageMatrix image, int k, int j, int i, short pixelValue)
    {
        if(!useVicinity)
        {
            return pixelValue;
        }
        int newValue = pixelValue <<2;
        if(j > 0)
        {
            if(j < image.height - 1)
            {
                newValue += image.imageData[k][j-1][i] + image.imageData[k][j+1][i];
            }
            else
            {
                newValue += image.imageData[k][j-1][i] << 1;
            }
        }else
        {
            newValue += image.imageData[k][j+1][i] << 1;
        }
        if(i > 0)
        {
            if(i < image.width - 1)
            {
                newValue += image.imageData[k][j][i-1] + image.imageData[k][j][i+1];
            }
            else
            {
                newValue += image.imageData[k][j][i-1] << 1;
            }
        }else
        {
            newValue += image.imageData[k][j][i+1] << 1;
        }
        return ((double)newValue)/PIXEL_TOTAL_WEIGHT;
    }


    public void stretch()
    {
        salida = image.newSameSize();

        final int bucketSize = useVicinity ? (int)(256*PIXEL_TOTAL_WEIGHT) : 256;
        final int [][] histograma = new int[image.planes][bucketSize];

        // Primero computo el histograma
        System.out.println("Calculando histograma");
        image.iterate(ImageMatrix.ITERATE_RASTER, new PixelIterator()
        {
                    public void processPixel(ImageMatrix image, int k, int j, int i, short pixelValue)
                    {
                        if(greyWorld && useVicinity)
                        {
                            histograma[k][(int)(PIXEL_TOTAL_WEIGHT*computePixel(image, k, j, i, pixelValue))]++;
                        }else
                        {
                            histograma[k][pixelValue]++;
                        }
//                        histograma[k][(int)computePixel(image, k, j, i, pixelValue)]++;
                    }
        });

        int totalPixels = image.width*image.height; // por plano
        int pixelsFuera = (int)(totalPixels * ((double)descarte/1000));

        System.out.println("Total " + totalPixels + " - descarte: " + pixelsFuera);

        final int [] left = new int[3];
        final int [] right = new int[3];
        final int [] rango = new int[3];
        final int [] greyWorldMedian = new int[3];

        for(int k = 0; k < image.planes; k++)
        {
            // Ahora veo el rango
            System.out.println("Calculando rango plano " + k);

            left[k] = 0;
            right[k] = bucketSize-1;
            for(int sum = 0; sum < pixelsFuera; left[k]++)
            {
                sum += histograma[k][left[k]];
            }
            if(left[k] > 0)left[k]--;
            for(int sum = 0; sum < pixelsFuera; right[k]--)
            {
                sum += histograma[k][right[k]];
            }
            if(right[k]<bucketSize-1)right[k]++;

            rango[k] = right[k] - left[k];

            System.out.println("Rango: " + left[k] + " - " + right[k] + " => " + rango[k]);

            if(greyWorld)
            {
                int greyWorldPixels = totalPixels>>1;
                greyWorldMedian[k] = 0;
                for(int sum = 0; sum < greyWorldPixels; greyWorldMedian[k]++)
                {
                    sum += histograma[k][greyWorldMedian[k]];
                }

                System.out.println("Median: " + greyWorldMedian[k]);
            }
        }

        // Ahora simplemente armo la nueva imagen
        image.iterate(ImageMatrix.ITERATE_RASTER, new PixelIterator()
        {
              public void processPixel(ImageMatrix image, int k, int j, int i, short pixelValue)
              {
                  if(greyWorld)
                  {
                      final double kgreyWorldMedian = greyWorldMedian[k]/(bucketSize>>8);
//                      final double krango = rango[k]/(bucketSize>>8);
                      final double kleft = left[k]/(bucketSize>>8);
                      final double kright = right[k]/(bucketSize>>8);
//                      double curPixel = ((((computePixel(image, k, j, i, pixelValue) - greyWorldMedian[k] + left[k]))/rango[k]));
//                      double curPixel = ((((computePixel(image, k, j, i, pixelValue) - kgreyWorldMedian + kleft))/krango));
                      double curPixel = computePixel(image, k, j, i, pixelValue);
                      if(curPixel < kgreyWorldMedian)
                      {
                          curPixel = ((curPixel - kleft)/(kgreyWorldMedian-kleft))/2.0;
                      }else
                      {
                          curPixel = 1.0 - 0.5 * ( (kright-curPixel)/(kright-kgreyWorldMedian) );
                      }
                      short newPixel = (short)(255.0 * curPixel);

//                      short newPixel = (short)((255.0 * (computePixel(image, k, j, i, pixelValue) - (left[k]/(bucketSize>>8))))/(rango[k]/(bucketSize>>8)));
                      salida.imageData[k][j][i] = newPixel < 0 ? 0 : newPixel>255 ? 255 : newPixel;
                  }else
                  {
                      short newPixel = (short)((255.0 * (computePixel(image, k, j, i, pixelValue) - left[k]))/rango[k]);
                      salida.imageData[k][j][i] = newPixel < 0 ? 0 : newPixel>255 ? 255 : newPixel;
                  }
              }
        });

    }

    public static void main(String [] args)
    {
        try
        {
            System.out.println("ACS v1.0, (u)2011 Gustavo Brown");
            System.out.println();

            int descarte = 10;

            // Proceso los argumentos:
            int curArg = 0;
            boolean isBatch = false;
            boolean useVicinity = false;
            boolean greyWorld = true;
            for(;curArg<args.length;curArg++)
            {
                if(!args[curArg].startsWith("-"))
                    break;
                String arg = args[curArg].toLowerCase();
                if(arg.startsWith("-p"))
                {
                    descarte = Integer.parseInt(arg.substring(2));
                }else if(arg.equals("-r"))
                {
                    useVicinity = true;
                }else if(arg.equals("-b"))
                {
                    isBatch=true;
                }else if(arg.equals("-ng"))
                {
                    greyWorld=false;
                }else
                {
                    System.out.println("ERROR procesando argumento:" + arg);
                }
            }
                        
            if(curArg > args.length - 2)
            {
                System.out.println("USO: edu.fing.image.ACS [argumentos] ImagenEntrada ImagenSalida");
                System.out.println("\nArgumentos:");
                System.out.println("\t-pNN  descartar NN por mil del histograma para encontrar rango");
                System.out.println("\t-r    utilizar vecindario para cada pixel");
                System.out.println("\t-ng   no usar modo 'grey world'");
                System.out.println("\t-b    indica modo batch (no muestra las imagenes)");
                System.out.println("\nValores por defecto: -p10 \n\n");
                System.exit(1);
            }


            String nomIn = args[curArg];
            String nomOut = args[curArg+1];
            System.out.println("Archivo de entrada: " + nomIn);
            System.out.println("Archivo de salida: " + nomOut);

            System.out.println();

            if(!new File(nomIn).exists())
            {
                System.out.println("No existe el archivo de entrada: " + nomIn);
                System.exit(1);
            }

            ImageMatrix imageIn = new ImageMatrix(nomIn);
//            imageIn.planes = 1;
            if(!isBatch)
                imageIn.showImage("Entrada");

            System.out.println("Tamaño imagen entrada: " + imageIn.width + " x " + imageIn.height);
            ACS acs = new ACS(imageIn, descarte, useVicinity, greyWorld);

            acs.stretch();
            if(!isBatch)
                acs.salida.showImage("Resultado ACS");

            PxMImage.saveAs(acs.salida, nomOut);

        }catch(Exception e)
        {
            e.printStackTrace();
        }
    }
}


