package edu.fing.image;
import java.util.*;

public class ImageMatrixEnumeration extends Thread implements Enumeration, PixelIterator
{
  public int iterateType;
  public ImageMatrix image;
  private ImageMatrixEnumerationItem nextElement;
  private Object lock = new Object();
  public static int uid = 0;

  public ImageMatrixEnumeration(ImageMatrix image, int iterateType)
  {
    super("ImageMatrixEnumeration-" + (uid++));
    this.image = image;
    this.iterateType = iterateType;
    synchronized(lock)
    {
      start();
      try
      {
        lock.wait(); // Espero a que se obtenga el primer item
      }catch(InterruptedException e){;}
    }
  }
  public boolean hasMoreElements()
  {
    return nextElement != null;
  }

  public ImageMatrixEnumerationItem nextItem()
  {
    return (ImageMatrixEnumerationItem) nextElement();
  }

  public Object nextElement()
  {
    synchronized(lock)
    {
      if(!hasMoreElements())
      {
        throw new NoSuchElementException("No hay mas elementos en el iterador de imagen (" + toString() + ")");
      }
      ImageMatrixEnumerationItem retItem = nextElement;
      nextElement = null;
      lock.notify();
      try
      {
        lock.wait(); // Espero el ack
      }catch(InterruptedException e){ ; }
      return retItem;
    }
  }

  public void run()
  {
    synchronized(lock)
    {
      image.iterate(iterateType, this);
      lock.notify();
    }
  }

  public void processPixel(ImageMatrix image, int k, int j, int i, short pixelValue)
  {
    synchronized(lock)
    {
      nextElement = new ImageMatrixEnumerationItem(image, k, j, i, pixelValue);
      lock.notify();
      try
      {
        lock.wait();
        lock.notify();
      } catch(InterruptedException e){ ; }
    }
  }
}
