package edu.fing.image;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class ImageMatrixCanvas extends Canvas
{
  public ImageMatrix image;
  public ActionListener specificListener;
  private ImageMatrix changeDetector;
  private Image img;
  private Image imgToShow;
  public static Vector mouseListeners = new Vector();

  public static void addActionListener(ActionListener listener)
  {
    mouseListeners.addElement(listener);
  }

  public static void removeActionListener(ActionListener listener)
  {
    mouseListeners.remove(listener);
  }

  public static void removeAllActionListeners()
  {
    mouseListeners.removeAllElements();
  }

  public void setSpecificActionListener(ActionListener listener)
  {
    specificListener = listener;
  }

  public ImageMatrixCanvas(ImageMatrix image)
  {
    this.image = image;
    changeDetector = ImageOperations.copyImage(image);
    img = image.getImage();
    this.img = img;
    setSize(img.getWidth(this), img.getHeight(this));
    rescale();
    imgToShow = img;
    this.addHierarchyBoundsListener(new HierarchyBoundsAdapter()
    {
      public void ancestorResized(HierarchyEvent evt)
      {
        rescale();
      }
    });
    this.addComponentListener(new ComponentAdapter()
    {
      public void componentResized(ComponentEvent evt)
      {
        rescale();
      }
    });
    super.addMouseListener(new MouseAdapter()
    {
      public void mouseClicked(MouseEvent e)
      {
        if(e.getClickCount() < 2)
        {
          return;
        }
        ActionEvent actionEvent = new ActionEvent(ImageMatrixCanvas.this, e.getButton(), "MouseClicked");
        if(specificListener != null)
        {
          specificListener.actionPerformed(actionEvent);
          return;
        }
        for(Enumeration enumi = mouseListeners.elements(); enumi.hasMoreElements();)
        {
          ActionListener listener = (ActionListener)enumi.nextElement();
          listener.actionPerformed(actionEvent);
        }
      }
    });
  }

  boolean imageChanged;
  public boolean imageChanged()
  {
    imageChanged = false;
    if(image.width != changeDetector.width || image.height != changeDetector.height)
    {
      changeDetector = ImageOperations.copyImage(image);
      return true;
    }
    image.iterate(ImageMatrix.ITERATE_RASTER, new PixelIterator()
    {
      public void processPixel(ImageMatrix image, int k, int j, int i, short pixelValue)
      {
        if(changeDetector.imageData[k][j][i] != pixelValue)
        {
          imageChanged = true;
        }
        changeDetector.imageData[k][j][i] = pixelValue;
      }
    });
    return imageChanged;
  }

  public boolean needsRepaint()
  {
    if(image.width != changeDetector.width || image.height != changeDetector.height)
    {
      changeDetector = ImageOperations.copyImage(image);
      return true;
    }
    for(int k = 0; k < image.planes; k++)
    {
      for(int j = 0; j < image.height; j++)
      {
        for(int i = 0; i < image.width; i++)
        {
          if(changeDetector.imageData[k][j][i] != image.imageData[k][j][i])
          {
            return true;
          }
        }
      }
    }
    return false;
  }

  public void paint(Graphics g)
  {
    g.drawImage(imgToShow, 0, 0, this);
    if(imageChanged())
    {
      img = image.getImage();
      rescale();
      g.drawImage(imgToShow, 0, 0, this);
    }
  }

  public void redraw()
  {
      img = image.getImage();
      rescale();
//      repaint();
  }

  public void rescale()
  {
    imgToShow = img.getScaledInstance(getWidth(), getHeight(), 0);
  }


  public void setTitle(String title)
  {
	frame.setTitle(title);
  }

  public Frame frame;
  public void showImage(String title)
  {
    if(frame == null)
    {
      frame = new Frame(title);
      frame.add(this);
      frame.addWindowListener(new WindowAdapter()
      {
        public void windowClosing(WindowEvent evt)
        {
          evt.getWindow().dispose();
          frame = null;
        }
      });
      frame.pack();
      frame.show();
    }
    else
    {
      repaint();
    }
  }

  public void close()
  {
      if(frame!=null)
      {
        frame.dispose();
        frame = null;
      }
  }
}
