package edu.fing.image;

import java.math.BigDecimal;
import java.math.MathContext;
import java.io.*;

public class ACE
{
    boolean USE_BIG_DECIMAL = false;
    boolean USE_ALL_IMAGE = true;
    int SIZE_X = USE_ALL_IMAGE ? 5000 : 200;
    int SIZE_Y = USE_ALL_IMAGE ? 5000 : 200;
    
    ImageMatrixFP image;
    ImageMatrixFP RC;
    ImageMatrix OC;
    FunctionR r;
    FunctionD d;
    public ACE(ImageMatrixFP image, FunctionR r, FunctionD d)
    {
        this.image = image;
        this.r = r;
        this.d = d;
    }

    public ACE(ImageMatrixFP image, FunctionR r, FunctionD d, int radio)
    {
        this.image = image;
        this.r = r;
        this.d = d;
        SIZE_X = radio;
        SIZE_Y = radio;
    }

//    double Rmax = -Double.MAX_VALUE;;
    public void calcularRC()
    {
        System.out.println("Aplicando ajuste cromatico/espacial");
        RC = image.newSameSize();

/*
        // Calculo Rmax
        Rmax = -Double.MAX_VALUE;
        image.iterate(ImageMatrixFP.ITERATE_RASTER, new PixelIteratorFP()
        {
            public void processPixel(ImageMatrixFP image, int pk, int pj, int pi, final double ppixelValue)
            {
                image.iterate(ImageMatrixFP.ITERATE_RASTER, new PixelIteratorFP()
                {
                    public void processPixel(ImageMatrixFP image, int jk, int jj, int ji, double jpixelValue)
                    {
                        double curR = r.r(ppixelValue, jpixelValue);
                        if(curR > Rmax)
                            Rmax = curR;
                    }
                });                
            }
        });

 */

        final MathContext context = MathContext.DECIMAL128;
        final BigDecimal rMax = new BigDecimal(r.rMax(), context);
        // Ahora computo Rc

        image.iterate(ImageMatrixFP.ITERATE_RASTER, new PixelIteratorFP()
        {
            public void processPixel(ImageMatrixFP image, final int pk, final int pj, final int pi, final double ppixelValue)
            {
                final double [] sumJ = new double[]{0};
                final double [] divJ = new double[]{0};
                final BigDecimal [] bsumJ = new BigDecimal[]{BigDecimal.ZERO};
                final BigDecimal [] bdivJ = new BigDecimal[]{BigDecimal.ZERO};

                int fromY = pj - SIZE_Y;
                int toY = pj + SIZE_Y;
                int fromX = pi - SIZE_X;
                int toX = pi + SIZE_X;

                if(fromY < 0)fromY=0;
                if(toY>image.height)toY=image.height;
                if(fromX < 0)fromX=0;
                if(toX > image.width) toX=image.width;

                for(int jj = fromY; jj < toY; jj++)
                {
                    for(int ji = fromX; ji < toX; ji++)
                    {
                        if(jj != pj || ji != pi)
                        {
                            double jpixelValue = image.imageData[pk][jj][ji];
                            double dpj = d.d(pi, pj, ji, jj);
                            if(USE_BIG_DECIMAL)
                            {
                                BigDecimal bdpj = new BigDecimal(dpj, context);
                                bsumJ[0] = bsumJ[0].add(new BigDecimal(r.r(ppixelValue - jpixelValue)).divide(bdpj, context));
                                bdivJ[0] = bdivJ[0].add(rMax.divide(bdpj,context));
                            }
                            else
                            {
                                sumJ[0] += (r.r(ppixelValue - jpixelValue) / dpj);
                                divJ[0] += (r.rMax() / dpj);
                            }
                        }
                    }
                }

                if(USE_BIG_DECIMAL)RC.imageData[pk][pj][pi] = bsumJ[0].divide(bdivJ[0], context).doubleValue();
                else RC.imageData[pk][pj][pi] = sumJ[0]/divJ[0];
                
//                RC.imageData[pk][pj][pi] = sumJ[0];
                System.out.print(pk + ": (" + pj /*+ "," + pi*/ + ")" /*+ " => " + image.imageData[pk][pj][pi]*/ + "    \r");
            }
        });
    }

    public void calcularOC()
    {
      OC = new ImageMatrix(RC.planes, RC.width, RC.height);
      boolean INDEPENDENT = true;

// Busco limites
      double max = -Double.MAX_VALUE;
      double min = Double.MAX_VALUE;
      for (int k = 0; k < RC.planes; k++)
      {
          for (int j = 0; j < RC.height; j++)
          {
              for (int i = 0; i < RC.width; i++)
              {
                  if (RC.imageData[k][j][i] > max)
                  {
                      max = RC.imageData[k][j][i];
                  }
                  if (RC.imageData[k][j][i] < min)
                  {
                      min = RC.imageData[k][j][i];
                  }
              }
          }

          // calculo slope (mc,0)-(Mc,255)

          if(INDEPENDENT)
          {
              double Mc = max;
              double mc = min;
              double sc = 255.0/(Mc-mc);

              for (int j = 0; j < RC.height; j++)
              {
                  for (int i = 0; i < RC.width; i++)
                  {
                      short pixelValue = (short) (Math.round(127.5 + (127.5*RC.imageData[k][j][i])/Mc));
//                      short pixelValue = (short) (Math.round(127.5 + sc*RC.imageData[k][j][i]));
                      if(pixelValue < 0) pixelValue = 0;
                      else if(pixelValue > 255) pixelValue = 255;
                      OC.imageData[k][j][i] = pixelValue;
                  }
              }
              max = -Double.MAX_VALUE;
              min = Double.MAX_VALUE;
          }
      }

      if(!INDEPENDENT)
      {
          double Mc = max;
          double mc = min;
          double sc = 255.0/(Mc-mc);

          for (int k = 0; k < RC.planes; k++)
          {
              for (int j = 0; j < RC.height; j++)
              {
                  for (int i = 0; i < RC.width; i++)
                  {
                      short pixelValue = (short) (Math.round(127.5 + sc*RC.imageData[k][j][i]));
                      if(pixelValue < 0) pixelValue = 0;
                      else if(pixelValue > 255) pixelValue = 255;
                      OC.imageData[k][j][i] = pixelValue;
                  }
              }
          }
      }
    }

    public static void main(String [] args)
    {
        try
        {
            System.out.println("ACE v1.0, (u)2011 Gustavo Brown");
            System.out.println();

            FunctionR funcR = new SlopeR(5);
            FunctionD funcD = new EuclideanD();
            int radio = 5000;

            // Proceso los argumentos:
            int curArg = 0;
            boolean isBatch=false;
            for(;curArg<args.length;curArg++)
            {
                if(!args[curArg].startsWith("-"))
                    break;
                String arg = args[curArg].toLowerCase();
                if(arg.startsWith("-p"))
                {
                    radio = Integer.parseInt(arg.substring(2));
                }else if(arg.equals("-rs"))
                {
                    funcR = new SignumR();
                }else if(arg.equals("-rl"))
                {
                    funcR = new LinearR();
                }else if(arg.equals("-rsl"))
                {
                    funcR = new SlopeR(Integer.parseInt(arg.substring(4)));
                }else if(arg.equals("-de"))
                {
                    funcD = new EuclideanD();
                }else if(arg.equals("-dm"))
                {
                    funcD = new ManhattanD();
                }else if(arg.equals("-dmax"))
                {
                    funcD = new MaximumD();
                }else if(arg.equals("-b"))
                {
                    isBatch=true;;
                }else
                {
                    System.out.println("ERROR procesando argumento:" + arg);
                }
            }
                        
            if(curArg > args.length - 2)
            {
                System.out.println("USO: edu.fing.image.ACE [argumentos] ImagenEntrada ImagenSalida");
                System.out.println("\nArgumentos:");
                System.out.println("\t-pNNN  utilizar NNN pixels de lado para el conjunto");
                System.out.println("\t-r{s|l|slNN}  indica la funcion R: s=signo, l=lineal, slNN=slope con pendiente NN");
                System.out.println("\t-d{e|m|max}  indica la funcion de distancia: e=euclidea, m=Manhattan, max=Maximum");
                System.out.println("\t-b   indica modo batch (no muestra las imagenes)");
                System.out.println("\nValores por defecto: r=slope(5) y d=euclidea\n\n");
                System.exit(1);
            }


            String nomIn = args[curArg];
            String nomOut = args[curArg+1];
            System.out.println("Archivo de entrada: " + nomIn);
            System.out.println("Archivo de salida: " + nomOut);

            System.out.println();

            if(!new File(nomIn).exists())
            {
                System.out.println("No existe el archivo de entrada: " + nomIn);
                System.exit(1);
            }

            ImageMatrixFP imageIn = new ImageMatrixFP(nomIn);
            if(!isBatch)
                imageIn.showImage("Entrada");

            System.out.println("Tamaño imagen entrada: " + imageIn.width + " x " + imageIn.height);
            ACE ace = new ACE(imageIn, funcR, funcD, radio);

            ace.calcularRC();
            if(!isBatch)
                ace.RC.showImage("Rc");

            ace.calcularOC();
            if(!isBatch)
                ace.OC.showImage("Resultado ACE");

            PxMImage.saveAs(ace.OC, nomOut);

        }catch(Exception e)
        {
            e.printStackTrace();
        }
    }
}


interface FunctionR
{
    public double r(double arg);
    public double rMax();
}

interface FunctionD
{

    public double d(int pX, int pY, int jX, int jY);
}

class LinearR implements FunctionR
{
    public double r(double arg)
    {
        return arg/255;
    }

    public double rMax()
    {
        return 1;
    }
}

class SlopeR implements FunctionR
{
    public double slope;
    public double invSlope;
    public SlopeR(double slope)
    {
        this.slope = slope;
        invSlope = 1/((double)slope);
    }

    public double r(double arg)
    {
        arg /= 255;
        if(arg <= -invSlope)return -1;
        else if(arg >= invSlope) return 1;
        else return arg*slope;
    }

    public double rMax()
    {
        return 1;
    }
}

class SignumR implements FunctionR
{
    public double r(double arg)
    {
        return Math.signum(arg);
    }

    public double rMax()
    {
        return 1;
    }
}

class EuclideanD implements FunctionD
{
    public double d(int pX, int pY, int jX, int jY)
    {
        return Math.sqrt((jX - pX) * (jX - pX) + (jY - pY) * (jY - pY));
    }
}

class ManhattanD implements FunctionD
{
    public double d(int pX, int pY, int jX, int jY)
    {
        return Math.abs(jX - pX) + Math.abs(jY - pY);
    }
}

class MaximumD implements FunctionD
{
    public double d(int pX, int pY, int jX, int jY)
    {
        return Math.max(Math.abs(jX - pX), Math.abs(jY - pY));
    }
}
