package edu.fing.image;

import java.awt.*;
import java.awt.event.*;

public class ImageCanvas extends Canvas
{
  public static Point initialLocation = new Point(0,0);

   Image img;
   Image imgToShow;
   public ImageCanvas(Image img)
   {
      this.img = img;
      setSize(img.getWidth(this), img.getHeight(this));
      imgToShow = img;
      this.addComponentListener(new ComponentAdapter()
      {
         public void componentResized(ComponentEvent evt)
         {
            rescale();
         }
      });
   }

   public void paint(Graphics g)
   {
      g.drawImage(imgToShow, 0, 0, this);
   }

   public void rescale()
   {
   	imgToShow = img.getScaledInstance(getWidth(), getHeight(), 0);
   }

   public static void showImage(Image image)
   {
      showImage("ImageShow", image);
   }

   public static void showImage(String title, Image image)
   {
      try
      {
         Frame frame = new Frame(title);
         frame.add(new ImageCanvas(image));
         frame.addWindowListener(new WindowAdapter()
         {
            public void windowClosing(WindowEvent evt)
            {
               evt.getWindow().dispose();
            }
         });
         frame.setLocation(initialLocation);
         initialLocation.translate(40,20);
         frame.pack();
         frame.show();
      } catch (Throwable e)
      {
         e.printStackTrace();
      }
   }
}
