package edu.fing.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.io.*;
import java.awt.image.*;
import javax.imageio.ImageIO;

public class PxMImage
{
  public static BufferedImage loadPxM(String fileName) throws IOException
  {
    BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(fileName));
    DataInputStream reader = new DataInputStream(inputStream);
    String line = readLine(reader);
    int planes, width, height;
    if(line.endsWith("P6"))
    {
      planes = 3;
    }
    else
    {
      planes = 1;
    }
    String imageSize = readLine(reader);
    int index = imageSize.indexOf(" ");
    if(index == -1)
    {
      throw new IOException("Header inv�lido: No se puede determinar el tama�o de la imagen");
    }
    width = Integer.parseInt(imageSize.substring(0, index));
    height = Integer.parseInt(imageSize.substring(index + 1));

    String pixelRange = readLine(reader);
    if(Integer.parseInt(pixelRange) != 255)
    {
      throw new IOException("Solo se puede decodificar imagenes de 8 bpp");
    }

    byte[] bytes = new byte[width * height * planes];
    new DataInputStream(inputStream).readFully(bytes);
    int[] buffer = new int[bytes.length];
    for(int i = 0; i < bytes.length; i++)
    {
      buffer[i] = (bytes[i] > 0 ? bytes[i] : ( (int) (bytes[i] + 128)) + 128);
    }
    inputStream.close();
    BufferedImage image = new BufferedImage(width, height, planes == 1 ? BufferedImage.TYPE_BYTE_GRAY : BufferedImage.TYPE_INT_RGB);
    WritableRaster raster = image.getRaster();
    raster.setPixels(0, 0, width, height, buffer);
    return image;
  }

  private static String readLine(DataInputStream reader)throws IOException
  {
    String line = reader.readLine();
    while(line.startsWith("#"))
    {
      line = reader.readLine();
    }
    return line;
  }

  public static void saveAsPGM(ImageMatrix imageData, String fileName, int plane)throws IOException
  {
    if(!fileName.toLowerCase().endsWith(".pgm") && !fileName.toLowerCase().endsWith(".ppm"))
    {
      fileName += ".pgm";
    }
    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fileName));
    out.write(("P5\n" + imageData.width + " " + imageData.height + "\n255\n").getBytes());
    for(int j = 0; j < imageData.height; j++)
    {
            for(int i = 0; i < imageData.width; i++)
            {
                    out.write(imageData.imageData[plane][j][i]);
            }
    }
    out.close();
  }
  public static void saveAsPGM(ImageMatrix imageData, String fileName) throws IOException
  {
    saveAsPGM(imageData, fileName, 0);
  }
  public static void saveAsPPM(ImageMatrix imageData, String fileName) throws IOException
  {
    if(imageData.planes < 3)
    {
            System.err.println("* Warning: Guardando imagen como PGM");
            saveAsPGM(imageData, fileName);
            return;
    }
    if(!fileName.toLowerCase().endsWith(".pgm") && !fileName.toLowerCase().endsWith(".ppm"))
    {
      fileName += ".ppm";
    }

    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fileName));
    out.write(("P6\n" + imageData.width + " " + imageData.height + "\n255\n").getBytes());
    for(int j = 0; j < imageData.height; j++)
    {
            for(int i = 0; i < imageData.width; i++)
            {
                    out.write(imageData.imageData[0][j][i]);
                    out.write(imageData.imageData[1][j][i]);
                    out.write(imageData.imageData[2][j][i]);
            }
    }
    out.close();
  }

  public static void saveAs(ImageMatrix image, String fileName) throws IOException
  {
      int extI = fileName.lastIndexOf('.');
      String ext;
      if(extI < 0)
      {
          System.err.println("No se definio extension, se asume .png");
          fileName += ".png";
          ext = "png";
      }
      else ext = fileName.substring(extI+1).toLowerCase();
      ImageIO.write(convertToRenderedImage(image), ext, new File(fileName));
  }

    public static RenderedImage convertToRenderedImage(ImageMatrix image)
    {
        int width = image.width;
        int height = image.height;

        // Create a buffered image in which to draw
        final BufferedImage bufferedImage = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);

        for (int j = 0; j < image.height; j++)
        {
            for (int i = 0; i < image.width; i++)
            {
                int rgb;
                if (image.planes == 3)
                {
                    rgb = image.imageData[0][j][i] << 16 | image.imageData[1][j][i] << 8 | image.imageData[2][j][i];
                }
                else
                {
                    rgb = image.imageData[0][j][i] << 16 | image.imageData[0][j][i] << 8 | image.imageData[0][j][i];
                }
                bufferedImage.setRGB(i, j, rgb);
            }
        }

        return bufferedImage;
    }

  public static void main(String [] args)throws Exception
  {
      ImageMatrix image = new ImageMatrix(args[0]);
      image.showImage(args[0]);
  }
}
