/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.ag;

import com.brownsoft.ag.ICruzamiento;
import com.brownsoft.ag.IIndividuo;
import com.brownsoft.ag.IMutacion;
import com.brownsoft.ag.InvalidCrossException;
import com.brownsoft.ag.InvalidMutationException;
import com.brownsoft.ag.MotorAG;
import com.brownsoft.ag.MotorError;
import com.brownsoft.ag.individuo.IndividuoMultiple;

public class OperadorMultiple
implements ICruzamiento,
IMutacion {
    protected ICruzamiento[] cruzamientos;
    protected IMutacion[] mutaciones;
    protected MotorAG motor;

    public OperadorMultiple(ICruzamiento[] cruzamientos) {
        this(cruzamientos, null);
    }

    public OperadorMultiple(IMutacion[] mutaciones) {
        this(null, mutaciones);
    }

    public OperadorMultiple(ICruzamiento[] cruzamientos, IMutacion[] mutaciones) {
        this.cruzamientos = cruzamientos;
        this.mutaciones = mutaciones;
        if (cruzamientos != null && mutaciones != null && cruzamientos.length != mutaciones.length) {
            throw new MotorError("La cantidad de elementos del array de cruzamientos difiera de la del array de mutaciones");
        }
    }

    public void inicializar(MotorAG motor) {
        this.motor = motor;
        if (this.cruzamientos != null) {
            int i = 0;
            while (i < this.cruzamientos.length) {
                this.cruzamientos[i].inicializar(motor);
                ++i;
            }
        }
    }

    public void inicioIteracion() {
        int i;
        if (this.cruzamientos != null) {
            i = 0;
            while (i < this.cruzamientos.length) {
                this.cruzamientos[i].inicioIteracion();
                ++i;
            }
        }
        if (this.mutaciones != null) {
            i = 0;
            while (i < this.mutaciones.length) {
                this.mutaciones[i].inicioIteracion();
                ++i;
            }
        }
    }

    public void finIteracion() {
        int i;
        if (this.cruzamientos != null) {
            i = 0;
            while (i < this.cruzamientos.length) {
                this.cruzamientos[i].finIteracion();
                ++i;
            }
        }
        if (this.mutaciones != null) {
            i = 0;
            while (i < this.mutaciones.length) {
                this.mutaciones[i].finIteracion();
                ++i;
            }
        }
    }

    public void finAlgoritmo() {
        int i;
        if (this.cruzamientos != null) {
            i = 0;
            while (i < this.cruzamientos.length) {
                this.cruzamientos[i].finAlgoritmo();
                ++i;
            }
        }
        if (this.mutaciones != null) {
            i = 0;
            while (i < this.mutaciones.length) {
                this.mutaciones[i].finAlgoritmo();
                ++i;
            }
        }
    }

    public IIndividuo[] cruzar(IIndividuo[] seleccionados) throws InvalidCrossException {
        if (this.cruzamientos == null) {
            throw new InvalidCrossException("No se definio el operador de cruzamiento para este OperadorMultiple");
        }
        IndividuoMultiple[] seleccionadosMultiple = new IndividuoMultiple[seleccionados.length];
        try {
            int i = 0;
            while (i < seleccionados.length) {
                seleccionadosMultiple[i] = (IndividuoMultiple)seleccionados[i];
                ++i;
            }
        }
        catch (ClassCastException e) {
            throw new MotorError("Solo se puede aplicar el OperadorMultiple a instancias de IndividuoMultiple", e);
        }
        IIndividuo[] cruzadosMultiple = new IndividuoMultiple[seleccionados.length];
        int i = 0;
        while (i < seleccionados.length) {
            cruzadosMultiple[i] = (IndividuoMultiple)seleccionadosMultiple[i].getCopy();
            this.motor.getFitnessMapping().remove(seleccionadosMultiple[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.cruzamientos.length) {
            IIndividuo[] seleccionadosParametro = new IIndividuo[seleccionados.length];
            int j = 0;
            while (j < seleccionados.length) {
                seleccionadosParametro[j] = seleccionadosMultiple[j].getParameter(i2);
                ++j;
            }
            seleccionadosParametro = this.cruzamientos[i2].cruzar(seleccionadosParametro);
            int j2 = 0;
            while (j2 < seleccionados.length) {
                ((IndividuoMultiple)cruzadosMultiple[j2]).setParameter(i2, seleccionadosParametro[j2]);
                ++j2;
            }
            ++i2;
        }
        return cruzadosMultiple;
    }

    public void inicializar(MotorAG motor, double pMutacion) {
        if (this.mutaciones != null) {
            int i = 0;
            while (i < this.mutaciones.length) {
                this.mutaciones[i].inicializar(motor, pMutacion);
                ++i;
            }
        }
    }

    public IIndividuo mutar(IIndividuo individuo) throws InvalidMutationException {
        if (this.mutaciones == null) {
            throw new InvalidMutationException("No se definio el operador de mutacion para este OperadorMultiple");
        }
        if (!(individuo instanceof IndividuoMultiple)) {
            throw new MotorError("Solo se puede aplicar el OperadorMultiple a instancias de IndividuoMultiple");
        }
        IndividuoMultiple individuoMultiple = (IndividuoMultiple)individuo;
        IndividuoMultiple mutadoMultiple = (IndividuoMultiple)individuoMultiple.getCopy();
        this.motor.getFitnessMapping().remove(individuoMultiple);
        int i = 0;
        while (i < this.mutaciones.length) {
            mutadoMultiple.setParameter(i, this.mutaciones[i].mutar(individuoMultiple.getParameter(i)));
            ++i;
        }
        return mutadoMultiple;
    }
}

