/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.ag.individuo;

import com.brownsoft.ag.IIndividuo;
import com.brownsoft.ag.MotorError;
import com.brownsoft.ag.PRNG;

public abstract class IndividuoBitStreamSimple
implements IIndividuo {
    protected int bitWidth;
    protected long maxValue;
    protected long value;
    protected IIndividuo[] parents;

    public IndividuoBitStreamSimple(int largoBitStream) {
        if (largoBitStream > 63 || largoBitStream < 1) {
            throw new MotorError("La cantidad de bits para representaci\u00f3n de los individuos de tipo IndividuoBitStreamSimple debe ser entre 1 y 63 [usado: " + largoBitStream + "]");
        }
        this.bitWidth = largoBitStream;
        this.maxValue = 1L << largoBitStream;
        this.parents = new IIndividuo[0];
        this.setRandom();
    }

    public IIndividuo getCopy() {
        try {
            IndividuoBitStreamSimple individuo = (IndividuoBitStreamSimple)this.clone();
            individuo.setValue(this.getValue());
            individuo.parents = new IIndividuo[this.parents.length];
            System.arraycopy(this.parents, 0, individuo.parents, 0, this.parents.length);
            return individuo;
        }
        catch (CloneNotSupportedException e) {
            throw new MotorError("No se pudo clonar el individuo: " + this.toString(), e);
        }
    }

    public Object getValue() {
        return new Long(this.value);
    }

    public void setValue(Object value) {
        this.value = (Long)value;
    }

    public void setRandom() {
        this.value = PRNG.nextLong(this.maxValue);
    }

    public int getBitWidth() {
        return this.bitWidth;
    }

    public void setParents(IIndividuo[] parents) {
        this.parents = parents;
    }

    public IIndividuo[] getParents() {
        return this.parents;
    }

    public int hashCode() {
        return (int)this.value;
    }

    public boolean equals(Object o) {
        try {
            return this.getValue().equals(((IndividuoBitStreamSimple)o).getValue());
        }
        catch (Exception e) {
            return false;
        }
    }

    public abstract Object getFenotipo();

    public abstract double getFitness();
}

