/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.ag.mutacion;

import com.brownsoft.ag.IIndividuo;
import com.brownsoft.ag.IMutacion;
import com.brownsoft.ag.InvalidMutationException;
import com.brownsoft.ag.MotorAG;
import com.brownsoft.ag.PRNG;
import com.brownsoft.ag.individuo.IndividuoBitStreamSimple;

public class MutacionHillClimber
implements IMutacion {
    private double pMutacion;
    private MotorAG motor;
    protected int N;

    public MutacionHillClimber(int N) throws InvalidMutationException {
        if (N < 0) {
            throw new InvalidMutationException("El operador MutacionHillClimber debe recibir un cantidad no negativa de iteraciones por mutaci\u00f3n (N=" + N + ")");
        }
        this.N = N;
    }

    public void inicializar(MotorAG motor, double pMutacion) {
        this.motor = motor;
        this.pMutacion = pMutacion;
    }

    public IIndividuo mutar(IIndividuo individuo) throws InvalidMutationException {
        if (this.pMutacion < PRNG.nextProbability()) {
            return individuo;
        }
        if (individuo instanceof IndividuoBitStreamSimple) {
            long currentChromosoma = (Long)individuo.getValue();
            double currentFitness = this.motor.getFitness(individuo);
            int bitWidth = ((IndividuoBitStreamSimple)individuo).getBitWidth();
            IIndividuo newIndividuo = individuo.getCopy();
            int i = 0;
            while (i < this.N) {
                long newChromosoma = currentChromosoma ^ 1L << PRNG.nextInt(bitWidth);
                newIndividuo.setValue(new Long(newChromosoma));
                double newFitness = this.motor.getFitness(newIndividuo);
                if (newFitness > currentFitness) {
                    currentFitness = newFitness;
                    currentChromosoma = newChromosoma;
                }
                ++i;
            }
            newIndividuo.setValue(new Long(currentChromosoma));
            return newIndividuo;
        }
        throw new InvalidMutationException("El Individuo no es del tipo IndividuoBitStream [tipo=" + individuo.getClass() + "]");
    }

    public void inicioIteracion() {
    }

    public void finIteracion() {
    }

    public void finAlgoritmo() {
    }
}

