/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.ag.seleccion;

import com.brownsoft.ag.IIndividuo;
import com.brownsoft.ag.ISeleccion;
import com.brownsoft.ag.MotorAG;
import com.brownsoft.ag.MotorException;
import java.util.Vector;

public class SeleccionElitista
implements ISeleccion {
    protected ISeleccion seleccion;
    protected IIndividuo bestIndividual = null;
    protected MotorAG motor;

    public SeleccionElitista(ISeleccion seleccion) throws MotorException {
        this.seleccion = seleccion;
    }

    public void inicializar(MotorAG motor) {
        this.seleccion.inicializar(motor);
        this.motor = motor;
    }

    public void inicioIteracion() {
        this.bestIndividual = this.motor.getBestIndividuo();
        this.seleccion.inicioIteracion();
    }

    public void finIteracion() {
        this.seleccion.finIteracion();
    }

    public void finAlgoritmo() {
        this.seleccion.finAlgoritmo();
    }

    public IIndividuo[] seleccionar() {
        return this.seleccion.seleccionar();
    }

    public void ponerEnPoolIntermedio(IIndividuo[] individuos) {
        this.seleccion.ponerEnPoolIntermedio(individuos);
    }

    public Vector generarNuevaPoblacion() {
        Vector nuevaPoblacion = this.seleccion.generarNuevaPoblacion();
        if (this.bestIndividual != null && !nuevaPoblacion.contains(this.bestIndividual)) {
            nuevaPoblacion.addElement(this.bestIndividual);
        }
        return nuevaPoblacion;
    }
}

