/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.ag.seleccion;

import com.brownsoft.ag.IIndividuo;
import com.brownsoft.ag.ISeleccion;
import com.brownsoft.ag.MotorAG;
import com.brownsoft.ag.MotorError;
import com.brownsoft.ag.PRNG;
import java.util.Enumeration;
import java.util.Vector;

public class SeleccionRuleta
implements ISeleccion {
    private MotorAG motor;
    protected Vector poblacionIteracion;
    private Vector poolIntermedio;
    protected double[] roulettePoints;

    public void inicializar(MotorAG motor) {
        this.motor = motor;
        this.poolIntermedio = new Vector();
    }

    public void inicioIteracion() {
        this.poolIntermedio.removeAllElements();
        double sumFitness = 0.0;
        this.poblacionIteracion = (Vector)this.motor.getPoblacion().clone();
        int popSize = this.getPopSize();
        this.roulettePoints = new double[popSize];
        int i = 0;
        Enumeration enumeration = this.poblacionIteracion.elements();
        while (enumeration.hasMoreElements()) {
            IIndividuo individuo = (IIndividuo)enumeration.nextElement();
            double fitness = this.motor.getFitness(individuo);
            if (fitness < 0.0) {
                throw new MotorError("El fitness no puede ser negativo en operador de seleccion SeleccionRuleta (individuo: " + individuo.toString() + ")");
            }
            sumFitness += fitness;
            this.roulettePoints[i++] = fitness;
        }
        double lastFitness = 0.0;
        i = 0;
        while (i < popSize) {
            this.roulettePoints[i] = this.roulettePoints[i] / sumFitness + lastFitness;
            lastFitness = this.roulettePoints[i];
            ++i;
        }
        this.roulettePoints[popSize - 1] = 1.0;
    }

    public IIndividuo[] seleccionar() {
        IIndividuo[] seleccionados = new IIndividuo[]{this.rouletteSelect(), this.rouletteSelect()};
        return seleccionados;
    }

    private IIndividuo rouletteSelect() {
        double value = PRNG.nextProbability();
        int i = 0;
        while (i < this.roulettePoints.length) {
            if (this.roulettePoints[i] >= value) {
                return (IIndividuo)this.poblacionIteracion.elementAt(i);
            }
            ++i;
        }
        throw new MotorError("SeleccionRuleta.rouleteSelect fallo: value= " + value);
    }

    public void ponerEnPoolIntermedio(IIndividuo[] individuos) {
        int i = 0;
        while (i < individuos.length) {
            this.poolIntermedio.addElement(individuos[i]);
            ++i;
        }
    }

    protected int getPopSize() {
        return this.poblacionIteracion.size();
    }

    public Vector generarNuevaPoblacion() {
        return (Vector)this.poolIntermedio.clone();
    }

    public void finIteracion() {
    }

    public void finAlgoritmo() {
    }
}

