/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.ag.cruzamiento;

import com.brownsoft.ag.ICruzamiento;
import com.brownsoft.ag.IIndividuo;
import com.brownsoft.ag.InvalidCrossException;
import com.brownsoft.ag.MotorAG;
import com.brownsoft.ag.PRNG;
import com.brownsoft.ag.individuo.IndividuoBitStreamSimple;

public class CruzamientoMPX
implements ICruzamiento {
    private int cantCrosses;

    public CruzamientoMPX(int cantCrosses) throws InvalidCrossException {
        this.cantCrosses = cantCrosses;
    }

    public void inicializar(MotorAG motor) {
    }

    public void inicioIteracion() {
    }

    public void finIteracion() {
    }

    public void finAlgoritmo() {
    }

    public IIndividuo[] cruzar(IIndividuo[] seleccionados) throws InvalidCrossException {
        IndividuoBitStreamSimple padreY;
        IndividuoBitStreamSimple padreX;
        if (seleccionados.length != 2) {
            throw new InvalidCrossException("CruzamientoMPX: La cantidad de individuos a cruzar debe ser 2");
        }
        try {
            padreX = (IndividuoBitStreamSimple)seleccionados[0];
            padreY = (IndividuoBitStreamSimple)seleccionados[1];
        }
        catch (ClassCastException invalidCast) {
            throw new InvalidCrossException("CruzamientoMPX: Los individuos no son del tipo 'IndividuoBitStreamSimple'", invalidCast);
        }
        int bitWidth = padreX.getBitWidth();
        if (this.cantCrosses >= bitWidth) {
            throw new InvalidCrossException("CruzamientoMPX: Cantidad de puntos de corte(" + this.cantCrosses + ") mayor que el largo del bitstream de los indiviudos(" + bitWidth + ")");
        }
        int[] crossPoints = new int[this.cantCrosses];
        int i = 0;
        while (i < this.cantCrosses) {
            crossPoints[i] = PRNG.nextInt(bitWidth);
            int j = 0;
            while (j < i) {
                if (crossPoints[j] == crossPoints[i]) {
                    --i;
                    break;
                }
                ++j;
            }
            ++i;
        }
        long mask1 = 0L;
        long mask2 = 0L;
        long curValue = 0L;
        int i2 = 0;
        while (i2 < this.cantCrosses) {
            int minPoint = Integer.MAX_VALUE;
            int minPos = -1;
            int j = 0;
            while (j < this.cantCrosses) {
                if (crossPoints[j] < minPoint) {
                    minPos = j;
                    minPoint = crossPoints[j];
                }
                ++j;
            }
            crossPoints[minPos] = Integer.MAX_VALUE;
            long thisValue = (long)Math.pow(2.0, minPoint + 1) - 1L;
            long tempValue = mask2;
            mask2 = mask1 + thisValue - curValue;
            mask1 = tempValue;
            curValue = thisValue;
            ++i2;
        }
        long valueX = (Long)padreX.getValue();
        long valueY = (Long)padreY.getValue();
        long hijoX = valueX & (mask1 += (long)Math.pow(2.0, bitWidth) - 1L - curValue) | valueY & mask2;
        long hijoY = valueX & mask2 | valueY & mask1;
        IIndividuo[] hijos = new IIndividuo[]{padreX.getCopy(), padreY.getCopy()};
        hijos[0].setValue(new Long(hijoX));
        hijos[1].setValue(new Long(hijoY));
        hijos[0].setParents(new IIndividuo[]{padreX, padreY});
        hijos[1].setParents(new IIndividuo[]{padreX, padreY});
        return hijos;
    }
}

