/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.ag.fitnessScaler;

import com.brownsoft.ag.IFitnessScaler;
import com.brownsoft.ag.MotorError;
import com.brownsoft.ag.fitnessScaler.FitnessScaler;
import com.brownsoft.ag.individuo.IndividuoBitStreamSimple;
import java.util.Enumeration;
import java.util.Hashtable;

public class FitnessScalerEspeciacion
extends FitnessScaler {
    Hashtable sumSigmaShare = new Hashtable();
    double sigmaShare;

    public FitnessScalerEspeciacion(IFitnessScaler parent, double sigmaShare) {
        super(parent);
        this.sigmaShare = sigmaShare;
    }

    protected double scaleFitness(double fitness) {
        if (this.getProcessingIndividual() == null) {
            return fitness;
        }
        if (!this.sumSigmaShare.contains(this.getProcessingIndividual())) {
            this.setupSigmaShare((IndividuoBitStreamSimple)this.getProcessingIndividual());
        }
        return fitness / (Double)this.sumSigmaShare.get(this.getProcessingIndividual());
    }

    protected int getDistance(IndividuoBitStreamSimple individuo1, IndividuoBitStreamSimple individuo2) {
        long value1 = (Long)individuo1.getValue();
        long value2 = (Long)individuo2.getValue();
        int distance = 0;
        double dist = 1.0 / (double)individuo1.getBitWidth();
        int i = individuo1.getBitWidth();
        while (i > 0) {
            if ((value1 & 1L) != (value2 & 1L)) {
                distance = (int)((double)distance + dist);
            }
            dist *= 2.0;
            value1 >>= 1;
            value2 >>= 1;
            --i;
        }
        return distance;
    }

    protected double getSharing(int distance) {
        if ((double)distance > this.sigmaShare) {
            return 0.0;
        }
        return (this.sigmaShare - (double)distance) / this.sigmaShare;
    }

    protected void setupSigmaShare(IndividuoBitStreamSimple individuo) {
        double sharing = 0.0;
        Enumeration enumeration = super.getMotor().getPoblacion().elements();
        while (enumeration.hasMoreElements()) {
            IndividuoBitStreamSimple individuo2 = (IndividuoBitStreamSimple)enumeration.nextElement();
            int distance = this.getDistance(individuo, individuo2);
            sharing += this.getSharing(distance);
        }
        this.sumSigmaShare.put(individuo.getCopy(), new Double(sharing));
    }

    public void inicioIteracion() {
        this.sumSigmaShare.clear();
        try {
            Enumeration enumeration = super.getMotor().getPoblacion().elements();
            while (enumeration.hasMoreElements()) {
                IndividuoBitStreamSimple individuo = (IndividuoBitStreamSimple)enumeration.nextElement();
                this.setupSigmaShare(individuo);
            }
        }
        catch (ClassCastException e) {
            throw new MotorError("El Scaler de especiacion solo puede trabajar con individuos del tipo IndividuoBitStreamSimple", e);
        }
    }
}

