/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.ag.individuo;

import com.brownsoft.ag.IIndividuo;
import com.brownsoft.ag.individuo.EvaluaExpresion;
import com.brownsoft.ag.individuo.FuncionPuntoFijo;
import com.brownsoft.ag.individuo.IndividuoMultipleFuncionExpresion;

public class FuncionExpresion
extends FuncionPuntoFijo {
    private boolean isPartOfComplexIndividual = false;
    private int parentIndex = -1;
    private IndividuoMultipleFuncionExpresion complexParent;
    private EvaluaExpresion eval;

    public FuncionExpresion(String expresion, double from, double to, int bitWidth) {
        this(expresion, from, to, bitWidth, "x");
    }

    public FuncionExpresion(String expresion, double from, double to, int bitWidth, String varName) {
        super(from, to, bitWidth, varName);
        this.eval = new EvaluaExpresion(expresion);
    }

    public double getFitness() {
        if (this.isPartOfComplexIndividual) {
            return this.complexParent.getFitness();
        }
        return this.eval.getFitness(this);
    }

    public EvaluaExpresion getEvaluator() {
        return this.eval;
    }

    protected void setIsPartOfComplexIndividual(int parentIndex, IndividuoMultipleFuncionExpresion complexParent) {
        this.isPartOfComplexIndividual = true;
        this.complexParent = complexParent;
        this.parentIndex = parentIndex;
    }

    public IIndividuo getCopy() {
        FuncionExpresion individuo = (FuncionExpresion)super.getCopy();
        if (this.isPartOfComplexIndividual) {
            individuo.complexParent = this.complexParent.doClone();
            individuo.complexParent.setParameter(this.parentIndex, individuo);
        }
        return individuo;
    }
}

