/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.ag.individuo;

import com.brownsoft.ag.individuo.IFuncion;
import com.brownsoft.ag.individuo.IndividuoBitStreamSimple;

public abstract class FuncionPuntoFijo
extends IndividuoBitStreamSimple
implements IFuncion {
    protected double from;
    protected double to;
    protected double width;
    protected String varName;
    protected boolean isDiscrete;

    public FuncionPuntoFijo(double from, double to, int bitWidth) {
        this(from, to, bitWidth, "x");
    }

    public FuncionPuntoFijo(double from, double to, int bitWidth, String varName) {
        super(bitWidth != 0 ? bitWidth : (int)(Math.log(to - from - 1.0) / Math.log(2.0)) + 1);
        this.from = from;
        this.to = to;
        this.width = to - from;
        this.varName = varName;
        this.isDiscrete = bitWidth == 0;
    }

    public String toString() {
        return this.varName + " = " + this.value();
    }

    public double value() {
        if (this.isDiscrete) {
            return Math.floor((double)this.value / (double)(this.maxValue - 1L) * this.width + this.from);
        }
        return (double)this.value / (double)(this.maxValue - 1L) * this.width + this.from;
    }

    public Object getFenotipo() {
        return new Double(this.value());
    }

    public abstract double getFitness();
}

