/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.ag.individuo;

import com.brownsoft.ag.IIndividuo;
import com.brownsoft.ag.MotorError;

public abstract class IndividuoMultiple
implements IIndividuo {
    protected IIndividuo[] parametros;
    protected IIndividuo[] parents;

    public IndividuoMultiple(IIndividuo[] parametros) {
        this.parametros = parametros;
    }

    public IIndividuo getCopy() {
        try {
            IndividuoMultiple individuo = (IndividuoMultiple)this.clone();
            individuo.parents = new IIndividuo[0];
            individuo.parametros = new IIndividuo[this.parametros.length];
            int i = 0;
            while (i < this.parametros.length) {
                individuo.setParameter(i, this.parametros[i].getCopy());
                ++i;
            }
            return individuo;
        }
        catch (CloneNotSupportedException e) {
            throw new MotorError("No se pudo clonar el individuo: " + this.toString(), e);
        }
    }

    public void setRandom() {
        int i = 0;
        while (i < this.parametros.length) {
            this.parametros[i].setRandom();
            ++i;
        }
    }

    public Object getValue() {
        throw new MotorError("Las instancias de IndividuoMultiple NO tienen definido el metodo getValue");
    }

    public void setValue(Object value) {
        throw new MotorError("Las instancias de IndividuoMultiple NO tienen definido el metodo setValue");
    }

    public abstract double getFitness();

    public abstract Object getFenotipo();

    public void setParents(IIndividuo[] parents) {
        this.parents = parents;
    }

    public IIndividuo[] getParents() {
        return this.parents;
    }

    public IIndividuo getParameter(int index) throws MotorError {
        try {
            return this.parametros[index];
        }
        catch (IndexOutOfBoundsException e) {
            throw new MotorError("Error en getParameter. El numero de parametro no debe exceder " + (this.parametros.length - 1) + "(index=" + index + ")", e);
        }
    }

    public int getParameterIndex(IIndividuo parameter) throws MotorError {
        int i = 0;
        while (i < this.parametros.length) {
            if (this.parametros[i].equals(parameter)) {
                return i;
            }
            ++i;
        }
        throw new MotorError("Error en getParameterIndex. El individuo '" + parameter + "' no es parte de este individuo.");
    }

    public void setParameter(int index, IIndividuo parameter) {
        this.parametros[index] = parameter;
    }

    public String toString() {
        String toString = this.parametros[0].toString();
        int i = 1;
        while (i < this.parametros.length) {
            toString = toString + "; " + this.parametros[i].toString();
            ++i;
        }
        return toString;
    }

    public int hashCode() {
        int hashCode = 0;
        int i = 0;
        while (i < this.parametros.length) {
            hashCode ^= this.parametros[i].hashCode();
            ++i;
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        try {
            IndividuoMultiple obj = (IndividuoMultiple)o;
            int i = 0;
            while (i < this.parametros.length) {
                if (!this.getParameter(i).equals(obj.getParameter(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

