/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.ag.mutacion;

import com.brownsoft.ag.IIndividuo;
import com.brownsoft.ag.IMutacion;
import com.brownsoft.ag.InvalidMutationException;
import com.brownsoft.ag.MotorAG;
import com.brownsoft.ag.PRNG;
import com.brownsoft.ag.individuo.IndividuoBitStreamSimple;

public class MutacionBitFlip
implements IMutacion {
    private double pMutacion;
    private MotorAG motor;

    public void inicializar(MotorAG motor, double pMutacion) {
        this.motor = motor;
        this.pMutacion = pMutacion;
    }

    public IIndividuo mutar(IIndividuo individuo) throws InvalidMutationException {
        if (individuo instanceof IndividuoBitStreamSimple) {
            long chromosoma = (Long)individuo.getValue();
            int bitWidth = ((IndividuoBitStreamSimple)individuo).getBitWidth();
            long bitValue = 1L;
            int i = 0;
            while (i < bitWidth) {
                if (PRNG.nextProbability() < this.pMutacion) {
                    chromosoma ^= bitValue;
                }
                bitValue <<= 1;
                ++i;
            }
            individuo.setValue(new Long(chromosoma));
            return individuo;
        }
        throw new InvalidMutationException("El Individuo no es del tipo IndividuoBitStream [tipo=" + individuo.getClass() + "]");
    }

    public void inicioIteracion() {
    }

    public void finIteracion() {
    }

    public void finAlgoritmo() {
    }
}

