/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.ag.seleccion;

import com.brownsoft.ag.IIndividuo;
import com.brownsoft.ag.MotorError;
import com.brownsoft.ag.PRNG;
import com.brownsoft.ag.seleccion.SeleccionRuleta;

public class SeleccionEstocasticaUniversal
extends SeleccionRuleta {
    private IIndividuo[] seleccionados;
    private int index;

    public void inicioIteracion() {
        super.inicioIteracion();
        int popSize = super.getPopSize();
        double distancia = 1.0 / (double)popSize;
        double curPointer = PRNG.nextProbability();
        IIndividuo[] temporal = new IIndividuo[popSize];
        this.seleccionados = new IIndividuo[popSize];
        int i = 0;
        while (i < popSize) {
            temporal[i] = this.rouletteSelect(curPointer);
            curPointer += distancia;
            curPointer %= 1.0;
            ++i;
        }
        int i2 = 0;
        while (i2 < popSize) {
            int shuffled = PRNG.nextInt(popSize);
            while (temporal[shuffled] == null) {
                ++shuffled;
                shuffled %= popSize;
            }
            this.seleccionados[i2] = temporal[shuffled];
            temporal[shuffled] = null;
            ++i2;
        }
        this.index = 0;
    }

    public IIndividuo[] seleccionar() {
        IIndividuo[] seleccionados = new IIndividuo[]{this.seleccionados[this.index++], this.seleccionados[this.index++]};
        return seleccionados;
    }

    private IIndividuo rouletteSelect(double value) {
        int i = 0;
        while (i < this.roulettePoints.length) {
            if (this.roulettePoints[i] >= value) {
                return (IIndividuo)this.poblacionIteracion.elementAt(i);
            }
            ++i;
        }
        throw new MotorError("SeleccionEstocasticaUniversal.rouleteSelect fallo: value= " + value);
    }
}

