/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.gui;

import com.brownsoft.ag.GeneracionSimple;
import com.brownsoft.ag.GeneracionSimpleDeJong;
import com.brownsoft.ag.ICruzamiento;
import com.brownsoft.ag.IIndividuo;
import com.brownsoft.ag.IMutacion;
import com.brownsoft.ag.ISeleccion;
import com.brownsoft.ag.MotorAG;
import com.brownsoft.ag.MotorException;
import com.brownsoft.ag.OperadorMultiple;
import com.brownsoft.ag.cruzamiento.CruzamientoMPX;
import com.brownsoft.ag.cruzamiento.CruzamientoSPX;
import com.brownsoft.ag.fitnessScaler.FitnessScaler;
import com.brownsoft.ag.fitnessScaler.FitnessScalerAxB;
import com.brownsoft.ag.fitnessScaler.FitnessScalerEspeciacion;
import com.brownsoft.ag.fitnessScaler.FitnessScalerInversa;
import com.brownsoft.ag.fitnessScaler.FitnessScalerPositive;
import com.brownsoft.ag.fitnessScaler.FitnessScalerSink;
import com.brownsoft.ag.individuo.FuncionExpresion;
import com.brownsoft.ag.individuo.IndividuoMultipleFuncionExpresion;
import com.brownsoft.ag.mutacion.MutacionBitFlip;
import com.brownsoft.ag.mutacion.MutacionHillClimber;
import com.brownsoft.ag.seleccion.SeleccionElitista;
import com.brownsoft.ag.seleccion.SeleccionEstocasticaUniversal;
import com.brownsoft.ag.seleccion.SeleccionRuleta;
import com.brownsoft.ag.seleccion.SeleccionTorneoQK;
import com.brownsoft.gui.Graph;
import com.brownsoft.gui.IMsgSink;
import com.brownsoft.util.ParseINI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FunctionSolverApplet
extends JApplet
implements IMsgSink,
ComponentListener {
    MotorRunnerThread motorRunnerThread = new MotorRunnerThread();
    MotorAG motor = null;
    int lastListParms = -1;
    int lastListArgs = -1;
    ParseINI props = new ParseINI();
    BorderLayout borderLayout1 = new BorderLayout();
    JLabel statusBar = new JLabel();
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    boolean isStandalone = false;
    JScrollPane scrollPanel = new JScrollPane();
    JPanel panelOpciones = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel panelButtons = new JPanel();
    Graph graph = new Graph(this);
    GridLayout gridLayout1 = new GridLayout();
    JButton btnAyuda = new JButton();
    JButton btnPaso = new JButton();
    JButton btnReset = new JButton();
    JButton btnCorrer = new JButton();
    JList listFunciones = new JList();
    JTextArea textAreaAyuda;
    JScrollPane scrollTextArea;
    JLabel lblProbMut = new JLabel();
    JTextField editArg3 = new JTextField();
    JComboBox jcomboSel = new JComboBox();
    DefaultComboBoxModel comboSel = new DefaultComboBoxModel();
    JComboBox graphVarSelector = new JComboBox();
    JTextField editArg1 = new JTextField();
    JTextField editArg2 = new JTextField();
    JTextField editProbMut = new JTextField();
    JList jlistParms = new JList();
    JScrollPane slistParms = new JScrollPane(this.jlistParms, 20, 31);
    DefaultListModel listParms = new DefaultListModel();
    GridBagLayout gridBagLayout = new GridBagLayout();
    JLabel lblFuncion = new JLabel();
    JTextArea editFuncion = new JTextArea();
    JScrollPane seditFuncion = new JScrollPane(this.editFuncion, 22, 31);
    JTextField editPobInicial = new JTextField();
    JTextField editProbCruz = new JTextField();
    JPanel panelParams = new JPanel();
    JLabel lblArg3 = new JLabel();
    JLabel lblArg2 = new JLabel();
    JLabel lblArg1 = new JLabel();
    JList jlistArgs = new JList();
    JScrollPane slistArgs = new JScrollPane(this.jlistArgs, 20, 31);
    DefaultListModel listArgs = new DefaultListModel();
    JLabel lblProbCruz = new JLabel();
    JLabel lblPobInicial = new JLabel();
    boolean onItemSelection = false;
    protected String funcName = "";
    private static final int PARM_NONE = -1;
    private static final int PARM_GENERACION = 0;
    private static final int PARM_SELECCION = 1;
    private static final int PARM_FITNESS_SCALER = 2;
    private static final int PARM_INDIVIDUO_ARGS = 3;
    private static final int PARM_CRUZAMIENTO = 0;
    private static final int PARM_MUTACION = 1;
    private static final int PARM_RANGO = 2;
    protected int lastComboSel = 0;
    private boolean running = false;
    private static int IterarNVeces = 50;

    public String getParameter(String key, String def) {
        return this.isStandalone ? System.getProperty(key, def) : (this.getParameter(key) != null ? this.getParameter(key) : def);
    }

    public void init() {
        try {
            this.jbInit();
            this.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.statusBar.setFont(new Font("Dialog", 1, 12));
        this.statusBar.setForeground(Color.blue);
        this.statusBar.setText("Resuelve Funciones");
        this.getContentPane().setLayout(this.borderLayout1);
        this.panel1.setLayout(this.borderLayout2);
        this.panelOpciones.setLayout(this.borderLayout3);
        this.panelButtons.setLayout(this.gridLayout1);
        this.gridLayout1.setRows(5);
        this.gridLayout1.setColumns(1);
        this.btnAyuda.setText("Ayuda");
        this.btnAyuda.setActionCommand("Ayuda");
        this.btnPaso.setText("Paso");
        this.textAreaAyuda = new JTextArea("Ayuda NO disponible. Verifique la existencia del archivo ayuda.txt", 7, 60);
        this.textAreaAyuda.setBackground(Color.lightGray);
        this.textAreaAyuda.setWrapStyleWord(true);
        this.textAreaAyuda.setFont(new Font("Monospaced", 0, 12));
        this.scrollTextArea = new JScrollPane(this.textAreaAyuda, 22, 31);
        this.editArg1.setMinimumSize(new Dimension(30, 21));
        this.editArg2.setMinimumSize(new Dimension(30, 21));
        this.editArg3.setMinimumSize(new Dimension(30, 21));
        this.slistArgs.setMinimumSize(new Dimension(24, 100));
        this.slistParms.setMinimumSize(new Dimension(24, 100));
        this.lblArg1.setMaximumSize(new Dimension(40, 15));
        this.lblArg1.setMinimumSize(new Dimension(60, 15));
        this.lblArg2.setMaximumSize(new Dimension(0, 0));
        this.lblArg2.setMinimumSize(new Dimension(100, 15));
        this.lblArg2.setPreferredSize(new Dimension(100, 15));
        this.getContentPane().add((Component)this.scrollTextArea, "North");
        this.textAreaAyuda.setEditable(false);
        this.scrollTextArea.setVisible(false);
        this.btnPaso.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FunctionSolverApplet.this.button_actionPerformed(e);
            }
        });
        this.btnReset.setActionCommand("Reset");
        this.btnReset.setText("Reset");
        this.btnReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FunctionSolverApplet.this.button_actionPerformed(e);
            }
        });
        this.btnCorrer.setActionCommand("Correr");
        this.btnCorrer.setText("Correr");
        this.btnCorrer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FunctionSolverApplet.this.button_actionPerformed(e);
            }
        });
        this.btnAyuda.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FunctionSolverApplet.this.btnAyuda_actionPerformed(e);
            }
        });
        this.listFunciones.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (FunctionSolverApplet.this.onItemSelection) {
                    return;
                }
                FunctionSolverApplet.this.onItemSelection = true;
                FunctionSolverApplet.this.listFunciones_itemStateChanged();
                FunctionSolverApplet.this.onItemSelection = false;
            }
        });
        this.lblProbMut.setText("Prob. Mut:");
        this.lblProbMut.setVisible(false);
        this.editArg3.setText("12");
        this.jcomboSel.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (FunctionSolverApplet.this.onItemSelection) {
                    return;
                }
                FunctionSolverApplet.this.onItemSelection = true;
                FunctionSolverApplet.this.comboSel_itemStateChanged(e);
                FunctionSolverApplet.this.onItemSelection = false;
            }
        });
        this.editArg1.setText("12");
        this.editArg2.setText("12");
        this.editProbMut.setText("0.05");
        this.editProbMut.setVisible(false);
        this.jlistParms.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (FunctionSolverApplet.this.onItemSelection) {
                    return;
                }
                if (e.getValueIsAdjusting() || FunctionSolverApplet.this.jlistParms.getSelectedValue() == null) {
                    return;
                }
                FunctionSolverApplet.this.onItemSelection = true;
                FunctionSolverApplet.this.listParms_itemStateChanged();
                FunctionSolverApplet.this.onItemSelection = false;
            }
        });
        this.lblFuncion.setFont(new Font("Dialog", 1, 12));
        this.lblFuncion.setForeground(Color.blue);
        this.lblFuncion.setText("Funcion:                      ");
        this.lblFuncion.setVisible(false);
        this.seditFuncion.setPreferredSize(new Dimension(150, 60));
        this.seditFuncion.setMinimumSize(new Dimension(150, 60));
        this.editFuncion.setLineWrap(true);
        this.editFuncion.setBackground(Color.cyan);
        this.editFuncion.setAutoscrolls(true);
        this.editFuncion.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyChar() == '\n') {
                    evt.consume();
                    FunctionSolverApplet.this.setFuncion();
                }
            }
        });
        this.editFuncion.setFont(new Font("Monospaced", 1, 12));
        this.editFuncion.setForeground(Color.darkGray);
        this.editFuncion.setText("****Funcion****");
        this.seditFuncion.setVisible(false);
        this.editPobInicial.setText("100");
        this.editPobInicial.setVisible(false);
        this.editProbCruz.setText("0.8");
        this.editProbCruz.setVisible(false);
        this.panelParams.setLayout(this.gridBagLayout);
        this.lblArg3.setText("**********");
        this.lblArg2.setText("**********");
        this.lblArg1.setText("**********");
        this.jlistArgs.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (FunctionSolverApplet.this.onItemSelection) {
                    return;
                }
                if (e.getValueIsAdjusting() || FunctionSolverApplet.this.jlistArgs.getSelectedValue() == null) {
                    return;
                }
                FunctionSolverApplet.this.onItemSelection = true;
                FunctionSolverApplet.this.listArgs_itemStateChanged();
                FunctionSolverApplet.this.onItemSelection = false;
            }
        });
        this.lblProbCruz.setText("Prob. Cruz:");
        this.lblProbCruz.setVisible(false);
        this.lblPobInicial.setText("Pob. Inicial:");
        this.lblPobInicial.setVisible(false);
        this.getContentPane().add((Component)this.statusBar, "South");
        this.getContentPane().add((Component)this.panel1, "Center");
        this.panel1.add((Component)this.panelOpciones, "South");
        this.panelOpciones.add((Component)this.panelButtons, "East");
        this.graphVarSelector.setVisible(false);
        this.graphVarSelector.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (FunctionSolverApplet.this.onItemSelection) {
                    return;
                }
                FunctionSolverApplet.this.onItemSelection = true;
                FunctionSolverApplet.this.setGraphVarSelector();
                FunctionSolverApplet.this.onItemSelection = false;
            }
        });
        this.panelButtons.add((Component)this.graphVarSelector, null);
        this.panelButtons.add((Component)this.btnAyuda, null);
        this.panelButtons.add((Component)this.btnCorrer, null);
        this.panelButtons.add((Component)this.btnPaso, null);
        this.panelButtons.add((Component)this.btnReset, null);
        this.panelOpciones.add((Component)new JScrollPane(this.listFunciones, 20, 30), "West");
        this.panelOpciones.add((Component)this.panelParams, "Center");
        this.slistParms.setPreferredSize(new Dimension(120, 100));
        this.slistArgs.setPreferredSize(new Dimension(120, 100));
        this.panelParams.add((Component)this.slistParms, new GridBagConstraints(0, 0, 2, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.jcomboSel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.lblArg1, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.lblArg2, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.editArg1, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.editArg2, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.lblArg3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.slistArgs, new GridBagConstraints(2, 0, 2, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.editArg3, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.lblFuncion, new GridBagConstraints(3, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.seditFuncion, new GridBagConstraints(3, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.lblPobInicial, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.editPobInicial, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.lblProbCruz, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.editProbCruz, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.lblProbMut, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.editProbMut, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panel1.add((Component)this.graph, "Center");
    }

    private GridBagConstraints getGridBagConstraints(int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, Insets insets, int ipadx, int ipady) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = gridx;
        constraints.gridy = gridy;
        constraints.gridwidth = gridwidth;
        constraints.gridheight = gridheight;
        constraints.weightx = weightx;
        constraints.weighty = weighty;
        constraints.anchor = anchor;
        constraints.fill = fill;
        constraints.insets = insets;
        constraints.ipadx = ipadx;
        constraints.ipady = ipady;
        return constraints;
    }

    public int getWidth() {
        return this.getSize().width;
    }

    public int getHeight() {
        return this.getSize().height;
    }

    private void initialize() {
        InputStream inputStream;
        this.btnAyuda.setSize(this.btnAyuda.getSize().width, 10);
        this.graphVarSelector.setSize(25, 12);
        this.statusBar.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    FunctionSolverApplet.this.statusBar.setText("Motor de Algoritmos Gen\u00e9ticos - (u)2003, Gustavo Brown Rodriguez");
                } else if (evt.getClickCount() > 2) {
                    FunctionSolverApplet.this.statusBar.setText("Comments: alegus@adinet.com.uy");
                }
            }
        });
        try {
            inputStream = this.getClass().getResourceAsStream("ayuda.txt");
            if (inputStream == null) {
                this.showMsg("No se puede cargar el archivo 'ayuda.txt'...");
                System.err.println("No se puede cargar el archivo 'ayuda.txt'...");
                this.textAreaAyuda.setText("No se pudo cargar el archivo 'ayuda.txt'");
            } else {
                BufferedInputStream is = new BufferedInputStream(inputStream);
                byte[] CHUNK = new byte[1024];
                byte[] ayuda = new byte[]{};
                int bytes = -1;
                while ((bytes = is.read(CHUNK)) != -1) {
                    byte[] temp = new byte[ayuda.length + bytes];
                    System.arraycopy(ayuda, 0, temp, 0, ayuda.length);
                    System.arraycopy(CHUNK, 0, temp, ayuda.length, bytes);
                    ayuda = temp;
                }
                this.textAreaAyuda.setText(new String(ayuda));
                inputStream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showMsg(e.toString());
        }
        try {
            inputStream = this.getClass().getResourceAsStream("funciones.ini");
            if (inputStream == null) {
                this.showMsg("No se puede cargar el archivo 'funciones.ini'...");
                System.err.println("No se puede cargar el archivo 'funciones.ini'...");
            } else {
                this.props.load(inputStream);
                inputStream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showMsg(e.toString());
        }
        DefaultListModel<String> functionListModel = new DefaultListModel<String>();
        this.listFunciones.setSelectionMode(0);
        this.jcomboSel.setModel(this.comboSel);
        this.listFunciones.setModel(functionListModel);
        this.jlistParms.setModel(this.listParms);
        this.jlistParms.setSelectionMode(0);
        this.jlistArgs.setModel(this.listArgs);
        this.jlistArgs.setSelectionMode(0);
        Enumeration enumeration = this.props.sectionNames();
        while (enumeration.hasMoreElements()) {
            String funcName = (String)enumeration.nextElement();
            this.showMsg("Parseando funcion " + funcName);
            functionListModel.addElement(funcName);
        }
        this.addComponentListener(this);
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        return null;
    }

    public static void main(String[] args) {
        FunctionSolverApplet applet = new FunctionSolverApplet();
        applet.isStandalone = true;
        Frame frame = new Frame(){

            protected void processWindowEvent(WindowEvent e) {
                super.processWindowEvent(e);
                if (e.getID() == 201) {
                    System.exit(0);
                }
            }

            public synchronized void setTitle(String title) {
                super.setTitle(title);
                this.enableEvents(64L);
            }
        };
        frame.setTitle("MotorAG");
        ((Component)frame).setBackground(Color.lightGray);
        frame.add((Component)applet, "Center");
        applet.init();
        applet.start();
        ((Component)frame).setSize(480, 380);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)frame).setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
        ((Component)frame).setVisible(true);
    }

    public void showMsg(String msg) {
        this.statusBar.setText(msg);
    }

    void btnAyuda_actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("Ayuda")) {
            this.btnAyuda.setActionCommand("finAyuda");
            this.scrollTextArea.setVisible(true);
            this.btnAyuda.setText("Ayuda-");
        } else {
            this.btnAyuda.setActionCommand("Ayuda");
            this.scrollTextArea.setVisible(false);
            this.btnAyuda.setText("Ayuda");
        }
        this.doLayout();
        this.panel1.doLayout();
        this.panelButtons.doLayout();
        this.refreshLayout();
    }

    void listFunciones_itemStateChanged() {
        this.showMsg(this.listFunciones.getSelectedValue() + " seleccionado");
        this.procesoSeleccion();
    }

    void setGraphVarSelector() {
        this.showMsg(this.graphVarSelector.getSelectedItem() + " seleccionado");
        this.graph.setCurVarIndependiente(this.graphVarSelector.getSelectedIndex());
    }

    private void procesoSeleccion() {
        this.saveParms();
        this.lastListParms = -1;
        this.funcName = (String)this.listFunciones.getSelectedValue();
        this.listParms.removeAllElements();
        this.listParms.addElement("Generacion");
        this.listParms.addElement("Seleccion");
        this.listParms.addElement("FitnessScaler");
        this.setCantParms();
        this.jlistParms.setSelectedIndex(0);
        this.listParms_itemStateChanged();
    }

    void listParms_itemStateChanged() {
        this.saveParms();
        this.saveArgs();
        this.lastListParms = this.jlistParms.getSelectedIndex();
        this.loadParms();
        this.refreshLayout();
    }

    private void setCantParms() {
        while (this.listParms.getSize() > 3) {
            this.listParms.remove(3);
        }
        int cantParams = Integer.parseInt(this.props.getProperty(this.funcName, "IndividuoParametros", "1"));
        if (cantParams == 1) {
            this.listParms.addElement("Variable x");
        } else {
            int i = 2;
            while (i <= cantParams + 1) {
                this.listParms.addElement("Variable f(" + (i - 1) + ")");
                ++i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void setFuncion() {
        block6: {
            block7: {
                if (this.getParm("Funcion", "none").toLowerCase().trim().equalsIgnoreCase(this.editFuncion.getText().toLowerCase().trim())) break block6;
                expr = this.editFuncion.getText().trim();
                cantVars = 0;
                if (expr.indexOf("f(") != -1) ** GOTO lbl23
                cantVars = 1;
                break block7;
lbl-1000:
                // 1 sources

                {
                    block5: {
                        index2 = expr.indexOf(")", (int)var3_3);
                        if (index2 == -1) {
                            this.showMsg("Warning: expresi\u00f3n mal formada (parentesis no balanceados)");
                            cantVars = -1;
                            break;
                        }
                        try {
                            varId = Integer.parseInt(expr.substring((int)(var3_3 + 2), index2));
                            if (varId <= cantVars) break block5;
                            cantVars = varId;
                        }
                        catch (NumberFormatException e) {
                            this.showMsg("Warning: expresion mal formada: " + expr.substring((int)var3_3, index2 + 1));
                            cantVars = -1;
                            break;
                        }
                    }
                    expr = expr.substring(index2);
lbl23:
                    // 2 sources

                    ** while ((index = expr.indexOf((String)"f(")) != -1)
                }
            }
            if (cantVars != -1) {
                this.props.setProperty(this.funcName, "IndividuoParametros", "" + cantVars);
                this.showMsg("La funcion contiene " + cantVars + " variables");
                this.setCantParms();
                this.refreshLayout();
            }
        }
        this.setParm("Funcion", this.editFuncion.getText().trim());
    }

    protected void saveParms() {
        switch (this.lastListParms) {
            case -1: {
                break;
            }
            case 0: {
                this.setParm("Generacion", this.comboSel.getSelectedItem());
                this.setFuncion();
                this.setParm("PoblacionInicial", this.editPobInicial.getText());
                this.setParm("ProbabilidadCruzamiento", this.editProbCruz.getText());
                this.setParm("ProbabilidadMutacion", this.editProbMut.getText());
                break;
            }
            case 1: {
                this.setParm("Seleccion", this.comboSel.getElementAt(this.lastComboSel));
                switch (this.lastComboSel) {
                    case 2: {
                        this.setParm("SeleccionParmQ", this.editArg1.getText());
                        this.setParm("SeleccionParmK", this.editArg2.getText());
                        break;
                    }
                    case 4: {
                        this.setParm("SeleccionParmQ", this.editArg1.getText());
                        this.setParm("SeleccionParmK", this.editArg2.getText());
                    }
                }
                break;
            }
            case 2: {
                this.setParm("FitnessScaler", this.comboSel.getElementAt(this.lastComboSel));
                switch (this.lastComboSel) {
                    case 1: 
                    case 5: {
                        this.setParm("FitnessScalerParmA", this.editArg1.getText());
                        this.setParm("FitnessScalerParmB", this.editArg2.getText());
                        break;
                    }
                    case 4: {
                        this.setParm("FitnessScalerParmSigma", this.editArg2.getText());
                    }
                }
                break;
            }
            case 3: {
                this.saveArgs();
            }
        }
    }

    protected void loadParms() {
        this.listArgs.removeAllElements();
        this.comboSel.removeAllElements();
        this.lastComboSel = 0;
        block0 : switch (this.lastListParms) {
            case -1: {
                break;
            }
            case 0: {
                this.comboSel.addElement("Simple");
                this.comboSel.addElement("DeJong");
                this.jcomboSel.setSelectedItem(this.getParm("Generacion", "DeJong"));
                this.editFuncion.setText(this.getParm("Funcion", "Introduzca la funcion"));
                this.editPobInicial.setText(this.getParm("PoblacionInicial", "100"));
                this.editProbCruz.setText(this.getParm("ProbabilidadCruzamiento", "0.85"));
                this.editProbMut.setText(this.getParm("ProbabilidadMutacion", "0.05"));
                this.lastComboSel = this.jcomboSel.getSelectedIndex();
                this.resetArgs();
                this.slistArgs.setVisible(false);
                this.setGenParmsVisible(true, true);
                this.lastListArgs = -1;
                break;
            }
            case 1: {
                this.slistArgs.setVisible(false);
                this.setGenParmsVisible(false, true);
                this.lastListArgs = -1;
                this.resetArgs();
                this.comboSel.addElement("Ruleta");
                this.comboSel.addElement("Estocastico Univ");
                this.comboSel.addElement("TorneoQK");
                this.comboSel.addElement("Elitista+Ruleta");
                this.comboSel.addElement("Elitista+TorneoQK");
                this.comboSel.addElement("Elitista+Estocas");
                this.jcomboSel.setSelectedItem(this.getParm("Seleccion", "Ruleta"));
                this.lastComboSel = this.jcomboSel.getSelectedIndex();
                switch (this.jcomboSel.getSelectedIndex()) {
                    case 2: {
                        this.setArgs1("Q", "SeleccionParmQ", "2");
                        this.setArgs2("K", "SeleccionParmK", "5");
                        break block0;
                    }
                    case 4: {
                        this.setArgs1("Q", "SeleccionParmQ", "2");
                        this.setArgs2("K", "SeleccionParmK", "3");
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                this.slistArgs.setVisible(false);
                this.setGenParmsVisible(false, true);
                this.lastListArgs = -1;
                this.resetArgs();
                this.comboSel.addElement("Ninguno");
                this.comboSel.addElement("ScalerAxB");
                this.comboSel.addElement("Inversa");
                this.comboSel.addElement("Positivo");
                this.comboSel.addElement("Especiacion");
                this.comboSel.addElement("Positivo+AxB");
                this.comboSel.addElement("Positivo+Inversa");
                this.comboSel.addElement("Inversa+Positivo");
                this.jcomboSel.setSelectedItem(this.getParm("FitnessScaler", "Ninguno"));
                this.lastComboSel = this.jcomboSel.getSelectedIndex();
                switch (this.jcomboSel.getSelectedIndex()) {
                    case 1: 
                    case 5: {
                        this.setArgs1("A", "FitnessScalerParmA", "-1");
                        this.setArgs2("B", "FitnessScalerParmB", "0");
                        break;
                    }
                    case 4: {
                        this.setArgs2("Sigma", "FitnessScalerParmSigma", "20");
                        if (Integer.parseInt(this.props.getProperty(this.funcName, "IndividuoParametros", "1")) == 1) break block0;
                        this.showMsg("Warning: el scaler de especiacion solo funciona con funciones de 1 sola variable");
                        break;
                    }
                }
                break;
            }
            default: {
                this.lastListArgs = 0;
                this.listArgs.addElement("Cruzamiento");
                this.listArgs.addElement("Mutacion");
                this.listArgs.addElement("Rango");
                this.jlistArgs.setSelectedIndex(0);
                this.slistArgs.setVisible(true);
                this.setGenParmsVisible(false, false);
                this.refreshLayout();
                this.loadArgs();
            }
        }
        this.refreshLayout();
    }

    private void setGenParmsVisible(boolean visible, boolean funcVisible) {
        this.lblFuncion.setVisible(funcVisible);
        this.seditFuncion.setVisible(funcVisible);
        this.lblPobInicial.setVisible(visible);
        this.editPobInicial.setVisible(visible);
        this.lblProbCruz.setVisible(visible);
        this.editProbCruz.setVisible(visible);
        this.lblProbMut.setVisible(visible);
        this.editProbMut.setVisible(visible);
    }

    protected void saveArgs() {
        if (this.lastListArgs == -1) {
            block0 : switch (this.lastListParms) {
                case 1: {
                    this.setParm("Seleccion", this.comboSel.getElementAt(this.lastComboSel));
                    switch (this.lastComboSel) {
                        case 2: {
                            this.setParm("SeleccionParmQ", this.editArg1.getText());
                            this.setParm("SeleccionParmK", this.editArg2.getText());
                            break;
                        }
                        case 4: {
                            this.setParm("SeleccionParmQ", this.editArg1.getText());
                            this.setParm("SeleccionParmK", this.editArg2.getText());
                        }
                    }
                    break;
                }
                case 2: {
                    this.setParm("FitnessScaler", this.comboSel.getElementAt(this.lastComboSel));
                    switch (this.lastComboSel) {
                        case 1: 
                        case 5: {
                            this.setParm("FitnessScalerParmA", this.editArg1.getText());
                            this.setParm("FitnessScalerParmB", this.editArg2.getText());
                            break block0;
                        }
                        case 4: {
                            this.setParm("FitnessScalerParmSigma", this.editArg2.getText());
                        }
                    }
                }
            }
            return;
        }
        switch (this.lastListArgs) {
            case 1: {
                this.setParm("Mutacion", this.comboSel.getElementAt(this.lastComboSel));
                switch (this.lastComboSel) {
                    case 1: {
                        this.setParm("MutacionParmHillClimberN", this.editArg1.getText());
                    }
                }
                break;
            }
            case 0: {
                this.setParm("Cruzamiento", this.comboSel.getElementAt(this.lastComboSel));
                switch (this.lastComboSel) {
                    case 1: {
                        this.setParm("CruzamientoParmCrossPoints", this.editArg1.getText());
                    }
                }
                break;
            }
            case 2: {
                this.jcomboSel.setVisible(true);
                this.setParm("RangoIzq", this.editArg1.getText());
                this.setParm("RangoDer", this.editArg2.getText());
                this.setParm("RangoBits", this.editArg3.getText());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void getArgs() {
        if (this.lastListArgs == -1) {
            block0 : switch (this.lastListParms) {
                case 1: {
                    this.resetArgs();
                    this.jcomboSel.setSelectedIndex(this.lastComboSel);
                    switch (this.jcomboSel.getSelectedIndex()) {
                        default: {
                            return;
                        }
                        case 1: {
                            return;
                        }
                        case 2: {
                            this.setArgs1("Q", "SeleccionParmQ", "2");
                            this.setArgs2("K", "SeleccionParmK", "5");
                            return;
                        }
                        case 3: {
                            return;
                        }
                        case 4: {
                            this.setArgs1("Q", "SeleccionParmQ", "2");
                            this.setArgs2("K", "SeleccionParmK", "3");
                            return;
                        }
                        case 5: 
                    }
                    return;
                }
                case 2: {
                    this.resetArgs();
                    this.jcomboSel.setSelectedIndex(this.lastComboSel);
                    switch (this.jcomboSel.getSelectedIndex()) {
                        case 1: 
                        case 5: {
                            this.setArgs1("A", "FitnessScalerParmA", "-1");
                            this.setArgs2("B", "FitnessScalerParmB", "0");
                            break block0;
                        }
                        case 4: {
                            this.setArgs2("Sigma", "FitnessScalerParmSigma", "20");
                            if (Integer.parseInt(this.props.getProperty(this.funcName, "IndividuoParametros", "1")) == 1) return;
                            this.showMsg("Warning: el scaler de especiacion solo funciona con funciones de 1 sola variable");
                        }
                    }
                }
            }
            return;
        }
        this.resetArgs();
        block15 : switch (this.lastListArgs) {
            case 1: {
                this.jcomboSel.setSelectedIndex(this.lastComboSel);
                switch (this.jcomboSel.getSelectedIndex()) {
                    default: {
                        break block15;
                    }
                    case 1: 
                }
                this.setArgs1("N", "MutacionParmHillClimberN", "3");
                break;
            }
            case 0: {
                this.jcomboSel.setSelectedIndex(this.lastComboSel);
                switch (this.jcomboSel.getSelectedIndex()) {
                    case 1: {
                        this.setArgs1("CrossPoints", "CruzamientoParmCrossPoints", "3");
                    }
                }
                break;
            }
            case 2: {
                this.setArgs1("Desde", "RangoIzq", "-15");
                this.setArgs2("Hasta", "RangoDer", "+15");
                this.setArgs3("Bits", "RangoBits", "30");
            }
        }
        this.refreshLayout();
    }

    protected void loadArgs() {
        if (this.lastListArgs == -1) {
            return;
        }
        this.comboSel.removeAllElements();
        this.resetArgs();
        block0 : switch (this.lastListArgs) {
            case 1: {
                this.comboSel.addElement("BitFlip");
                this.comboSel.addElement("HillClimber");
                this.jcomboSel.setSelectedItem(this.getParm("Mutacion", "BitFlip"));
                switch (this.jcomboSel.getSelectedIndex()) {
                    default: {
                        break block0;
                    }
                    case 1: 
                }
                this.setArgs1("N", "MutacionParmHillClimberN", "3");
                break;
            }
            case 0: {
                this.comboSel.addElement("SPX");
                this.comboSel.addElement("MPX");
                this.jcomboSel.setSelectedItem(this.getParm("Cruzamiento", "SPX"));
                switch (this.jcomboSel.getSelectedIndex()) {
                    case 1: {
                        this.setArgs1("CrossPoints", "CruzamientoParmCrossPoints", "3");
                    }
                }
                break;
            }
            case 2: {
                this.jcomboSel.setVisible(false);
                this.setArgs1("Desde", "RangoIzq", "-15");
                this.setArgs2("Hasta", "RangoDer", "+15");
                this.setArgs3("Bits", "RangoBits", "30");
            }
        }
        this.lastComboSel = this.jcomboSel.getSelectedIndex();
    }

    private void resetArgs() {
        this.lblArg1.setVisible(false);
        this.editArg1.setVisible(false);
        this.lblArg2.setVisible(false);
        this.editArg2.setVisible(false);
        this.lblArg3.setVisible(false);
        this.editArg3.setVisible(false);
    }

    private void setArgs1(String lbl, String prop, String def) {
        this.lblArg1.setText(lbl);
        this.editArg1.setText(this.getParm(prop, def));
        this.lblArg1.setVisible(true);
        this.editArg1.setVisible(true);
    }

    private void setArgs2(String lbl, String prop, String def) {
        this.lblArg2.setText(lbl);
        this.editArg2.setText(this.getParm(prop, def));
        this.lblArg2.setVisible(true);
        this.editArg2.setVisible(true);
    }

    private void setArgs3(String lbl, String prop, String def) {
        this.lblArg3.setText(lbl);
        this.editArg3.setText(this.getParm(prop, def));
        this.lblArg3.setVisible(true);
        this.editArg3.setVisible(true);
    }

    void listArgs_itemStateChanged() {
        this.showMsg(this.jlistArgs.getSelectedValue().toString() + " seleccionado");
        this.saveArgs();
        this.lastListArgs = this.jlistArgs.getSelectedIndex();
        this.lastComboSel = 0;
        this.loadArgs();
        this.refreshLayout();
    }

    private String getParm(String parm, String def) {
        if (this.lastListParms >= 3) {
            return this.props.getProperty(this.funcName, parm + "_" + (this.lastListParms - 3 + 1), def);
        }
        return this.props.getProperty(this.funcName, parm, def);
    }

    private void setParm(String parm, Object value) {
        if (this.lastListParms >= 3) {
            this.props.setProperty(this.funcName, parm + "_" + (this.lastListParms - 3 + 1), value.toString());
        } else {
            this.props.setProperty(this.funcName, parm, value.toString());
        }
    }

    void comboSel_itemStateChanged(ItemEvent e) {
        this.saveArgs();
        this.lastComboSel = this.jcomboSel.getSelectedIndex();
        this.getArgs();
    }

    private void setEditable(boolean editable) {
        this.editArg1.setEnabled(editable);
        this.editArg2.setEnabled(editable);
        this.editArg3.setEnabled(editable);
        this.jcomboSel.setEnabled(editable);
        this.seditFuncion.setEnabled(editable);
        this.editPobInicial.setEnabled(editable);
        this.editProbCruz.setEnabled(editable);
        this.editProbMut.setEnabled(editable);
    }

    private void refreshLayout() {
        this.panelOpciones.doLayout();
        this.panelParams.doLayout();
    }

    void button_actionPerformed(ActionEvent e) {
        block10: {
            String command = e.getActionCommand();
            try {
                if (command.equalsIgnoreCase("Reset") && this.running) {
                    this.running = false;
                    this.refreshLayout();
                    this.motorRunnerThread.stop();
                    this.setEditable(true);
                    this.graph.reset();
                    this.motorRunnerThread = new MotorRunnerThread();
                    return;
                }
                if (command.equalsIgnoreCase("Correr")) {
                    if (!this.running) {
                        if (this.initMotor()) {
                            this.motorRunnerThread.iterar();
                        }
                        return;
                    }
                    if (this.running) {
                        this.motorRunnerThread.iterarN(IterarNVeces);
                        return;
                    }
                }
                if (!command.equalsIgnoreCase("Paso")) break block10;
                if (!this.running) {
                    if (this.initMotor()) {
                        this.motorRunnerThread.paso();
                    }
                    return;
                }
                if (this.running) {
                    this.motorRunnerThread.paso();
                    return;
                }
            }
            catch (Throwable ex) {
                this.showMsg("Error en Motor: " + ex.toString());
                ex.printStackTrace();
            }
        }
    }

    private double getDoubleProp(String prop, int parmNum) throws Exception {
        try {
            return new Double(this.props.getProperty(this.funcName, prop + (parmNum > 0 ? "_" + parmNum : ""), "No definido"));
        }
        catch (Exception e) {
            throw new MotorException("Error parseando property: " + prop + " -> " + e.toString());
        }
    }

    private int getIntProp(String prop, int parmNum) throws Exception {
        try {
            return new Integer(this.props.getProperty(this.funcName, prop + (parmNum > 0 ? "_" + parmNum : ""), "No definido"));
        }
        catch (Exception e) {
            throw new MotorException("Error parseando property: " + prop + " -> " + e.toString());
        }
    }

    private String getStringProp(String prop, int parmNum) {
        return this.props.getProperty(this.funcName, prop + (parmNum > 0 ? "_" + parmNum : ""), "No definido");
    }

    public boolean initMotor() {
        this.saveParms();
        this.saveArgs();
        try {
            GeneracionSimple generacion;
            IMutacion mutacion;
            ICruzamiento cruzamiento;
            IIndividuo individuo;
            ISeleccion seleccion;
            this.showMsg("Parseando datos...");
            int cantParms = new Integer(this.getIntProp("IndividuoParametros", 0));
            this.graphVarSelector.removeAllItems();
            if (cantParms != 1) {
                int i = 0;
                while (i < cantParms) {
                    this.graphVarSelector.addItem("f(" + (i + 1) + ")");
                    ++i;
                }
                this.graphVarSelector.setSelectedIndex(0);
                this.graphVarSelector.setEnabled(true);
                this.graphVarSelector.setVisible(true);
                this.setGraphVarSelector();
                this.refreshLayout();
            } else {
                this.graphVarSelector.addItem("x");
                this.graphVarSelector.setSelectedIndex(0);
                this.graphVarSelector.setEnabled(false);
                this.graphVarSelector.setVisible(true);
                this.refreshLayout();
            }
            FitnessScaler fitnessScaler = null;
            IIndividuo[] parmIndividuo = new IIndividuo[cantParms];
            ICruzamiento[] parmCruzamiento = new ICruzamiento[cantParms];
            IMutacion[] parmMutacion = new IMutacion[cantParms];
            String tipoSeleccion = this.getStringProp("Seleccion", 0);
            if (tipoSeleccion.equalsIgnoreCase("Ruleta")) {
                seleccion = new SeleccionRuleta();
            } else if (tipoSeleccion.equalsIgnoreCase("Estocastico Univ")) {
                seleccion = new SeleccionEstocasticaUniversal();
            } else if (tipoSeleccion.equalsIgnoreCase("TorneoQK")) {
                seleccion = new SeleccionTorneoQK(this.getIntProp("SeleccionParmQ", 0), this.getIntProp("SeleccionParmK", 0));
            } else if (tipoSeleccion.equalsIgnoreCase("Elitista+Ruleta")) {
                seleccion = new SeleccionElitista(new SeleccionRuleta());
            } else if (tipoSeleccion.equalsIgnoreCase("Elitista+TorneoQK")) {
                seleccion = new SeleccionElitista(new SeleccionTorneoQK(this.getIntProp("SeleccionParmQ", 0), this.getIntProp("SeleccionParmK", 0)));
            } else if (tipoSeleccion.equalsIgnoreCase("Elitista+Estocas")) {
                seleccion = new SeleccionElitista(new SeleccionEstocasticaUniversal());
            } else {
                throw new IllegalArgumentException("El operador de seleccion es invalido");
            }
            String tipoFitnessScaler = this.getStringProp("FitnessScaler", 0);
            if (tipoFitnessScaler.equalsIgnoreCase("ScalerAxB")) {
                fitnessScaler = new FitnessScalerAxB(new FitnessScalerSink(), this.getDoubleProp("FitnessScalerParmA", 0), this.getDoubleProp("FitnessScalerParmB", 0));
            } else if (tipoFitnessScaler.equalsIgnoreCase("Inversa")) {
                fitnessScaler = new FitnessScalerInversa(new FitnessScalerSink());
            } else if (tipoFitnessScaler.equalsIgnoreCase("Positivo")) {
                fitnessScaler = new FitnessScalerPositive(new FitnessScalerSink());
            } else if (tipoFitnessScaler.equalsIgnoreCase("Especiacion")) {
                fitnessScaler = new FitnessScalerEspeciacion(new FitnessScalerSink(), this.getIntProp("FitnessScalerParmSigma", 0));
                if (Integer.parseInt(this.props.getProperty(this.funcName, "IndividuoParametros", "1")) != 1) {
                    throw new MotorException("El scaler de especiacion solo funciona con funciones de 1 sola variable");
                }
            } else if (tipoFitnessScaler.equalsIgnoreCase("Positivo+AxB")) {
                fitnessScaler = new FitnessScalerPositive(new FitnessScalerAxB(new FitnessScalerSink(), this.getDoubleProp("FitnessScalerParmA", 0), this.getDoubleProp("FitnessScalerParmB", 0)));
            } else if (tipoFitnessScaler.equalsIgnoreCase("Positivo+Inversa")) {
                fitnessScaler = new FitnessScalerPositive(new FitnessScalerInversa(new FitnessScalerSink()));
            } else if (tipoFitnessScaler.equalsIgnoreCase("Inversa+Positivo")) {
                fitnessScaler = new FitnessScalerInversa(new FitnessScalerPositive(new FitnessScalerSink()));
            }
            int i = 0;
            while (i < cantParms) {
                int curParm = i + 1;
                parmIndividuo[i] = new FuncionExpresion(this.getStringProp("Funcion", 0), this.getDoubleProp("RangoIzq", curParm), this.getDoubleProp("RangoDer", curParm), this.getIntProp("RangoBits", curParm), cantParms == 1 ? "x" : "f(" + curParm + ")");
                String tipoCruzamiento = this.getStringProp("Cruzamiento", curParm);
                if (tipoCruzamiento.equalsIgnoreCase("SPX")) {
                    parmCruzamiento[i] = new CruzamientoSPX();
                } else if (tipoCruzamiento.equalsIgnoreCase("MPX")) {
                    parmCruzamiento[i] = new CruzamientoMPX(this.getIntProp("CruzamientoParmCrossPoints", curParm));
                } else {
                    throw new IllegalArgumentException("El operador de cruzamiento para la variable " + curParm + " es invalido");
                }
                String tipoMutacion = this.getStringProp("Mutacion", curParm);
                if (tipoMutacion.equalsIgnoreCase("BitFlip")) {
                    parmMutacion[i] = new MutacionBitFlip();
                } else if (tipoMutacion.equalsIgnoreCase("HillClimber")) {
                    parmMutacion[i] = new MutacionHillClimber(this.getIntProp("MutacionParmHillClimberN", curParm));
                } else {
                    throw new IllegalArgumentException("El operador de mutacion para la variable " + curParm + " es invalido");
                }
                ++i;
            }
            if (cantParms == 1) {
                individuo = parmIndividuo[0];
                cruzamiento = parmCruzamiento[0];
                mutacion = parmMutacion[0];
            } else {
                individuo = new IndividuoMultipleFuncionExpresion(this.getStringProp("Funcion", 0), parmIndividuo);
                OperadorMultiple operadorMultiple = new OperadorMultiple(parmCruzamiento, parmMutacion);
                cruzamiento = operadorMultiple;
                mutacion = operadorMultiple;
            }
            String tipoGeneracion = this.getStringProp("Generacion", 0);
            if (tipoGeneracion.equalsIgnoreCase("Simple")) {
                generacion = new GeneracionSimple(individuo, this.getIntProp("PoblacionInicial", 0), this.getDoubleProp("ProbabilidadCruzamiento", 0), this.getDoubleProp("ProbabilidadMutacion", 0));
            } else if (tipoGeneracion.equalsIgnoreCase("DeJong")) {
                generacion = new GeneracionSimpleDeJong(individuo, this.getIntProp("PoblacionInicial", 0), this.getDoubleProp("ProbabilidadCruzamiento", 0), this.getDoubleProp("ProbabilidadMutacion", 0));
            } else {
                throw new IllegalArgumentException("La tipo de Generacion seleccionado es invalido");
            }
            this.motor = new MotorAG(generacion, seleccion, cruzamiento, mutacion);
            this.motor.setFitnessScaler(fitnessScaler);
            this.graph.initialize(this.motor);
            this.running = true;
            this.setEditable(false);
            return true;
        }
        catch (Throwable e) {
            this.showMsg("No se pudo incializar el motor: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public void componentHidden(ComponentEvent evt) {
    }

    public void componentShown(ComponentEvent evt) {
    }

    public void componentMoved(ComponentEvent evt) {
    }

    public void componentResized(ComponentEvent evt) {
        int rows = super.getSize().height / 45;
        this.textAreaAyuda.setRows(rows < 5 ? 5 : rows);
        this.doLayout();
        this.panel1.doLayout();
        this.panelButtons.doLayout();
        this.refreshLayout();
    }

    class MotorRunnerThread
    extends Thread {
        public final int NONE = 0;
        public final int ITERAR = 1;
        public final int ITERARN = 2;
        public final int PASO = 3;
        private int whatToDo = 0;
        private int NVeces = 50;

        public MotorRunnerThread() {
            super("MotorRunnerThread");
            super.setDaemon(true);
            super.start();
        }

        public synchronized void iterar() {
            this.whatToDo = 1;
            this.notifyAll();
        }

        public synchronized void iterarN(int NVeces) {
            this.NVeces = NVeces;
            this.whatToDo = 2;
            this.notifyAll();
        }

        public synchronized void paso() {
            this.whatToDo = 3;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    MotorRunnerThread motorRunnerThread = this;
                    synchronized (motorRunnerThread) {
                        this.wait();
                    }
                    switch (this.whatToDo) {
                        case 1: {
                            FunctionSolverApplet.this.motor.iterar();
                            break;
                        }
                        case 2: {
                            FunctionSolverApplet.this.motor.iterar(this.NVeces);
                            break;
                        }
                        case 3: {
                            FunctionSolverApplet.this.motor.iterarOnce();
                        }
                    }
                    this.whatToDo = 0;
                    continue;
                }
                catch (Throwable e) {
                    if (!(e instanceof ThreadDeath) && !(e instanceof InterruptedException)) {
                        e.printStackTrace();
                        FunctionSolverApplet.this.showMsg(e.getMessage());
                        continue;
                    }
                    switch (this.whatToDo) {
                        case 1: {
                            FunctionSolverApplet.this.showMsg("Se ha interrumpido la operacion de correr");
                            break;
                        }
                        case 2: {
                            FunctionSolverApplet.this.showMsg("Se ha interrumpido la operacion de iterar " + this.NVeces + " veces");
                            break;
                        }
                        case 3: {
                            FunctionSolverApplet.this.showMsg("Se ha interrumpido la operacion de iterar un paso");
                        }
                    }
                    continue;
                }
                break;
            }
        }
    }
}

