/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.gui;

import com.brownsoft.ag.GeneracionSimple;
import com.brownsoft.ag.GeneracionSimpleDeJong;
import com.brownsoft.ag.ICruzamiento;
import com.brownsoft.ag.IIndividuo;
import com.brownsoft.ag.IMutacion;
import com.brownsoft.ag.ISeleccion;
import com.brownsoft.ag.MotorAG;
import com.brownsoft.ag.MotorException;
import com.brownsoft.ag.OperadorMultiple;
import com.brownsoft.ag.cruzamiento.CruzamientoMPX;
import com.brownsoft.ag.cruzamiento.CruzamientoSPX;
import com.brownsoft.ag.fitnessScaler.FitnessScaler;
import com.brownsoft.ag.fitnessScaler.FitnessScalerAxB;
import com.brownsoft.ag.fitnessScaler.FitnessScalerEspeciacion;
import com.brownsoft.ag.fitnessScaler.FitnessScalerInversa;
import com.brownsoft.ag.fitnessScaler.FitnessScalerPositive;
import com.brownsoft.ag.fitnessScaler.FitnessScalerSink;
import com.brownsoft.ag.individuo.FuncionExpresion;
import com.brownsoft.ag.individuo.IndividuoMultipleFuncionExpresion;
import com.brownsoft.ag.mutacion.MutacionBitFlip;
import com.brownsoft.ag.mutacion.MutacionHillClimber;
import com.brownsoft.ag.seleccion.SeleccionElitista;
import com.brownsoft.ag.seleccion.SeleccionEstocasticaUniversal;
import com.brownsoft.ag.seleccion.SeleccionRuleta;
import com.brownsoft.ag.seleccion.SeleccionTorneoQK;
import com.brownsoft.gui.Graph;
import com.brownsoft.gui.IMsgSink;
import com.brownsoft.util.ParseINI;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Enumeration;

public class FunctionSolverAppletAWT
extends Applet
implements IMsgSink,
ComponentListener {
    MotorRunnerThread motorRunnerThread = new MotorRunnerThread();
    MotorAG motor = null;
    int lastListParms = -1;
    int lastListArgs = -1;
    ParseINI props = new ParseINI();
    BorderLayout borderLayout1 = new BorderLayout();
    Label statusBar = new Label();
    Panel panel1 = new Panel();
    BorderLayout borderLayout2 = new BorderLayout();
    boolean isStandalone = false;
    ScrollPane scrollPanel = new ScrollPane();
    Panel panelOpciones = new Panel();
    BorderLayout borderLayout3 = new BorderLayout();
    Panel panelButtons = new Panel();
    Graph graph = new Graph(this);
    GridLayout gridLayout1 = new GridLayout();
    Button btnAyuda = new Button();
    Button btnPaso = new Button();
    Button btnReset = new Button();
    Button btnCorrer = new Button();
    List listFunciones = new List();
    TextArea textAreaAyuda;
    protected String funcName = "";
    private static final int PARM_NONE = -1;
    private static final int PARM_GENERACION = 0;
    private static final int PARM_SELECCION = 1;
    private static final int PARM_FITNESS_SCALER = 2;
    private static final int PARM_INDIVIDUO_ARGS = 3;
    private static final int PARM_CRUZAMIENTO = 0;
    private static final int PARM_MUTACION = 1;
    private static final int PARM_RANGO = 2;
    protected int lastComboSel = 0;
    private boolean running = false;
    Label lblProbMut = new Label();
    TextField editArg3 = new TextField();
    Choice comboSel = new Choice();
    Choice graphVarSelector = new Choice();
    TextField editArg2 = new TextField();
    TextField editProbMut = new TextField();
    TextField editArg1 = new TextField();
    List listParms = new List();
    GridBagLayout gridBagLayout = new GridBagLayout();
    Label lblFuncion = new Label();
    TextField editFuncion = new TextField(15);
    TextField editPobInicial = new TextField();
    TextField editProbCruz = new TextField();
    Panel panelParams = new Panel();
    Label lblArg3 = new Label();
    Label lblArg2 = new Label();
    Label lblArg1 = new Label();
    List listArgs = new List();
    Label lblProbCruz = new Label();
    Label lblPobInicial = new Label();
    private static int IterarNVeces = 50;

    public String getParameter(String key, String def) {
        return this.isStandalone ? System.getProperty(key, def) : (this.getParameter(key) != null ? this.getParameter(key) : def);
    }

    public void init() {
        try {
            this.jbInit();
            this.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.statusBar.setFont(new Font("Dialog", 1, 12));
        this.statusBar.setForeground(Color.blue);
        this.statusBar.setText("Resuelve Funciones");
        this.setLayout(this.borderLayout1);
        this.panel1.setLayout(this.borderLayout2);
        this.panelOpciones.setLayout(this.borderLayout3);
        this.panelButtons.setLayout(this.gridLayout1);
        this.gridLayout1.setRows(5);
        this.gridLayout1.setColumns(1);
        this.btnAyuda.setLabel("Ayuda");
        this.btnAyuda.setActionCommand("Ayuda");
        this.btnPaso.setLabel("Paso");
        this.textAreaAyuda = new TextArea("Ayuda NO disponible. Verifique la existencia del archivo ayuda.txt", 7, 60, 1);
        this.textAreaAyuda.setFont(new Font("Monospaced", 0, 12));
        this.add((Component)this.textAreaAyuda, "North");
        this.textAreaAyuda.setEditable(false);
        this.textAreaAyuda.setVisible(false);
        this.btnPaso.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FunctionSolverAppletAWT.this.button_actionPerformed(e);
            }
        });
        this.btnReset.setActionCommand("Reset");
        this.btnReset.setLabel("Reset");
        this.btnReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FunctionSolverAppletAWT.this.button_actionPerformed(e);
            }
        });
        this.btnCorrer.setActionCommand("Correr");
        this.btnCorrer.setLabel("Correr");
        this.btnCorrer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FunctionSolverAppletAWT.this.button_actionPerformed(e);
            }
        });
        this.btnAyuda.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FunctionSolverAppletAWT.this.btnAyuda_actionPerformed(e);
            }
        });
        this.listFunciones.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                FunctionSolverAppletAWT.this.listFunciones_itemStateChanged(e);
            }
        });
        this.lblProbMut.setText("Prob. Mut:");
        this.lblProbMut.setVisible(false);
        this.editArg3.setText("12");
        this.comboSel.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                FunctionSolverAppletAWT.this.comboSel_itemStateChanged(e);
            }
        });
        this.editArg2.setText("12");
        this.editProbMut.setText("0.05");
        this.editProbMut.setVisible(false);
        this.editArg1.setText("12");
        this.listParms.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                FunctionSolverAppletAWT.this.listParms_itemStateChanged(e);
            }
        });
        this.lblFuncion.setFont(new Font("Dialog", 1, 12));
        this.lblFuncion.setForeground(Color.blue);
        this.lblFuncion.setText("Funcion:                      ");
        this.lblFuncion.setVisible(false);
        this.editFuncion.setBackground(Color.cyan);
        this.editFuncion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FunctionSolverAppletAWT.this.setFuncion();
            }
        });
        this.editFuncion.setFont(new Font("Monospaced", 1, 12));
        this.editFuncion.setForeground(Color.darkGray);
        this.editFuncion.setText("****Funcion****");
        this.editFuncion.setVisible(false);
        this.editPobInicial.setText("100");
        this.editPobInicial.setVisible(false);
        this.editProbCruz.setText("0.8");
        this.editProbCruz.setVisible(false);
        this.panelParams.setLayout(this.gridBagLayout);
        this.lblArg3.setText("**********");
        this.lblArg2.setText("**********");
        this.lblArg1.setText("**********");
        this.listArgs.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                FunctionSolverAppletAWT.this.listArgs_itemStateChanged(e);
            }
        });
        this.lblProbCruz.setText("Prob. Cruz:");
        this.lblProbCruz.setVisible(false);
        this.lblPobInicial.setText("Pob. Inicial:");
        this.lblPobInicial.setVisible(false);
        this.add((Component)this.statusBar, "South");
        this.add((Component)this.panel1, "Center");
        this.panel1.add((Component)this.panelOpciones, "South");
        this.panelOpciones.add((Component)this.panelButtons, "East");
        this.graphVarSelector.setVisible(false);
        this.graphVarSelector.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                FunctionSolverAppletAWT.this.setGraphVarSelector();
            }
        });
        this.panelButtons.add((Component)this.graphVarSelector, null);
        this.panelButtons.add((Component)this.btnAyuda, null);
        this.panelButtons.add((Component)this.btnCorrer, null);
        this.panelButtons.add((Component)this.btnPaso, null);
        this.panelButtons.add((Component)this.btnReset, null);
        this.panelOpciones.add((Component)this.listFunciones, "West");
        this.panelOpciones.add((Component)this.panelParams, "Center");
        this.panelParams.add((Component)this.listParms, this.getGridBagConstraints(0, 0, 2, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.comboSel, this.getGridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.lblArg1, this.getGridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.lblArg2, this.getGridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.editArg1, this.getGridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.editArg2, this.getGridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.lblArg3, this.getGridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.listArgs, this.getGridBagConstraints(2, 0, 2, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.editArg3, this.getGridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.lblFuncion, this.getGridBagConstraints(3, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.editFuncion, this.getGridBagConstraints(3, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.lblPobInicial, this.getGridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.editPobInicial, this.getGridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.lblProbCruz, this.getGridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.editProbCruz, this.getGridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.lblProbMut, this.getGridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panelParams.add((Component)this.editProbMut, this.getGridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panel1.add((Component)this.graph, "Center");
    }

    private GridBagConstraints getGridBagConstraints(int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, Insets insets, int ipadx, int ipady) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = gridx;
        constraints.gridy = gridy;
        constraints.gridwidth = gridwidth;
        constraints.gridheight = gridheight;
        constraints.weightx = weightx;
        constraints.weighty = weighty;
        constraints.anchor = anchor;
        constraints.fill = fill;
        constraints.insets = insets;
        constraints.ipadx = ipadx;
        constraints.ipady = ipady;
        return constraints;
    }

    public int getWidth() {
        return this.getSize().width;
    }

    public int getHeight() {
        return this.getSize().height;
    }

    private void initialize() {
        InputStream inputStream;
        this.btnAyuda.setSize(this.btnAyuda.getSize().width, 10);
        this.graphVarSelector.setSize(25, 12);
        this.statusBar.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    FunctionSolverAppletAWT.this.statusBar.setText("Motor de Algoritmos Gen\u00e9ticos - (u)2003, Gustavo Brown Rodriguez");
                } else if (evt.getClickCount() > 2) {
                    FunctionSolverAppletAWT.this.statusBar.setText("Comments: alegus@adinet.com.uy");
                }
            }
        });
        try {
            inputStream = this.getClass().getResourceAsStream("ayuda.txt");
            if (inputStream == null) {
                this.showMsg("No se puede cargar el archivo 'ayuda.txt'...");
                System.err.println("No se puede cargar el archivo 'ayuda.txt'...");
                this.textAreaAyuda.setText("No se pudo cargar el archivo 'ayuda.txt'");
            } else {
                BufferedInputStream is = new BufferedInputStream(inputStream);
                byte[] CHUNK = new byte[1024];
                byte[] ayuda = new byte[]{};
                int bytes = -1;
                while ((bytes = is.read(CHUNK)) != -1) {
                    byte[] temp = new byte[ayuda.length + bytes];
                    System.arraycopy(ayuda, 0, temp, 0, ayuda.length);
                    System.arraycopy(CHUNK, 0, temp, ayuda.length, bytes);
                    ayuda = temp;
                }
                this.textAreaAyuda.setText(new String(ayuda));
                inputStream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showMsg(e.toString());
        }
        try {
            inputStream = this.getClass().getResourceAsStream("funciones.ini");
            if (inputStream == null) {
                this.showMsg("No se puede cargar el archivo 'funciones.ini'...");
                System.err.println("No se puede cargar el archivo 'funciones.ini'...");
            } else {
                this.props.load(inputStream);
                inputStream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showMsg(e.toString());
        }
        Enumeration enumeration = this.props.sectionNames();
        while (enumeration.hasMoreElements()) {
            String funcName = (String)enumeration.nextElement();
            this.showMsg("Parseando funcion " + funcName);
            this.listFunciones.add(funcName);
        }
        this.addComponentListener(this);
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        return null;
    }

    public static void main(String[] args) {
        FunctionSolverAppletAWT applet = new FunctionSolverAppletAWT();
        applet.isStandalone = true;
        Frame frame = new Frame(){

            protected void processWindowEvent(WindowEvent e) {
                super.processWindowEvent(e);
                if (e.getID() == 201) {
                    System.exit(0);
                }
            }

            public synchronized void setTitle(String title) {
                super.setTitle(title);
                this.enableEvents(64L);
            }
        };
        frame.setTitle("MotorAG");
        ((Component)frame).setBackground(Color.lightGray);
        frame.add((Component)applet, "Center");
        applet.init();
        applet.start();
        ((Component)frame).setSize(480, 380);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)frame).setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
        ((Component)frame).setVisible(true);
    }

    public void showMsg(String msg) {
        this.statusBar.setText(msg);
    }

    void btnAyuda_actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("Ayuda")) {
            this.btnAyuda.setActionCommand("finAyuda");
            this.textAreaAyuda.setVisible(true);
            this.btnAyuda.setLabel("Ayuda-");
        } else {
            this.btnAyuda.setActionCommand("Ayuda");
            this.textAreaAyuda.setVisible(false);
            this.btnAyuda.setLabel("Ayuda");
        }
        this.doLayout();
        this.panel1.doLayout();
        this.panelButtons.doLayout();
        this.refreshLayout();
    }

    void listFunciones_itemStateChanged(ItemEvent e) {
        this.showMsg(this.listFunciones.getSelectedItem() + " seleccionado");
        this.procesoSeleccion();
    }

    void setGraphVarSelector() {
        this.showMsg(this.graphVarSelector.getSelectedItem() + " seleccionado");
        this.graph.setCurVarIndependiente(this.graphVarSelector.getSelectedIndex());
    }

    private void procesoSeleccion() {
        this.saveParms();
        this.lastListParms = -1;
        this.funcName = this.listFunciones.getSelectedItem();
        this.listParms.removeAll();
        this.listParms.add("Generacion", 0);
        this.listParms.add("Seleccion", 1);
        this.listParms.add("FitnessScaler", 2);
        this.setCantParms();
        this.listParms.select(0);
        this.listParms_itemStateChanged(null);
    }

    void listParms_itemStateChanged(ItemEvent e) {
        this.saveParms();
        this.saveArgs();
        this.lastListParms = this.listParms.getSelectedIndex();
        this.loadParms();
        this.refreshLayout();
    }

    private void setCantParms() {
        while (this.listParms.getItemCount() > 3) {
            this.listParms.remove(3);
        }
        int cantParams = Integer.parseInt(this.props.getProperty(this.funcName, "IndividuoParametros", "1"));
        if (cantParams == 1) {
            this.listParms.add("Variable x", 3);
        } else {
            int i = 2;
            while (i <= cantParams + 1) {
                this.listParms.add("Variable f(" + (i - 1) + ")", i + 2);
                ++i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void setFuncion() {
        block6: {
            block7: {
                if (this.getParm("Funcion", "none").toLowerCase().trim().equalsIgnoreCase(this.editFuncion.getText().toLowerCase().trim())) break block6;
                expr = this.editFuncion.getText().trim();
                cantVars = 0;
                if (expr.indexOf("f(") != -1) ** GOTO lbl23
                cantVars = 1;
                break block7;
lbl-1000:
                // 1 sources

                {
                    block5: {
                        index2 = expr.indexOf(")", (int)var3_3);
                        if (index2 == -1) {
                            this.showMsg("Warning: expresi\u00f3n mal formada (parentesis no balanceados)");
                            cantVars = -1;
                            break;
                        }
                        try {
                            varId = Integer.parseInt(expr.substring((int)(var3_3 + 2), index2));
                            if (varId <= cantVars) break block5;
                            cantVars = varId;
                        }
                        catch (NumberFormatException e) {
                            this.showMsg("Warning: expresion mal formada: " + expr.substring((int)var3_3, index2 + 1));
                            cantVars = -1;
                            break;
                        }
                    }
                    expr = expr.substring(index2);
lbl23:
                    // 2 sources

                    ** while ((index = expr.indexOf((String)"f(")) != -1)
                }
            }
            if (cantVars != -1) {
                this.props.setProperty(this.funcName, "IndividuoParametros", "" + cantVars);
                this.showMsg("La funcion contiene " + cantVars + " variables");
                this.setCantParms();
                this.refreshLayout();
            }
        }
        this.setParm("Funcion", this.editFuncion.getText().trim());
    }

    protected void saveParms() {
        switch (this.lastListParms) {
            case -1: {
                break;
            }
            case 0: {
                this.setParm("Generacion", this.comboSel.getSelectedItem());
                this.setFuncion();
                this.setParm("PoblacionInicial", this.editPobInicial.getText());
                this.setParm("ProbabilidadCruzamiento", this.editProbCruz.getText());
                this.setParm("ProbabilidadMutacion", this.editProbMut.getText());
                break;
            }
            case 1: {
                this.setParm("Seleccion", this.comboSel.getItem(this.lastComboSel));
                switch (this.lastComboSel) {
                    case 2: {
                        this.setParm("SeleccionParmQ", this.editArg1.getText());
                        this.setParm("SeleccionParmK", this.editArg2.getText());
                        break;
                    }
                    case 4: {
                        this.setParm("SeleccionParmQ", this.editArg1.getText());
                        this.setParm("SeleccionParmK", this.editArg2.getText());
                    }
                }
                break;
            }
            case 2: {
                this.setParm("FitnessScaler", this.comboSel.getItem(this.lastComboSel));
                switch (this.lastComboSel) {
                    case 1: 
                    case 5: {
                        this.setParm("FitnessScalerParmA", this.editArg1.getText());
                        this.setParm("FitnessScalerParmB", this.editArg2.getText());
                        break;
                    }
                    case 4: {
                        this.setParm("FitnessScalerParmSigma", this.editArg1.getText());
                    }
                }
                break;
            }
            case 3: {
                this.saveArgs();
            }
        }
    }

    protected void loadParms() {
        this.listArgs.removeAll();
        this.comboSel.removeAll();
        this.lastComboSel = 0;
        block0 : switch (this.lastListParms) {
            case -1: {
                break;
            }
            case 0: {
                this.comboSel.addItem("Simple");
                this.comboSel.addItem("DeJong");
                this.comboSel.select(this.getParm("Generacion", "DeJong"));
                this.editFuncion.setText(this.getParm("Funcion", "Introduzca la funcion"));
                this.editPobInicial.setText(this.getParm("PoblacionInicial", "100"));
                this.editProbCruz.setText(this.getParm("ProbabilidadCruzamiento", "0.85"));
                this.editProbMut.setText(this.getParm("ProbabilidadMutacion", "0.05"));
                this.lastComboSel = this.comboSel.getSelectedIndex();
                this.resetArgs();
                this.listArgs.setVisible(false);
                this.setGenParmsVisible(true, true);
                this.lastListArgs = -1;
                break;
            }
            case 1: {
                this.listArgs.setVisible(false);
                this.setGenParmsVisible(false, true);
                this.lastListArgs = -1;
                this.resetArgs();
                this.comboSel.addItem("Ruleta");
                this.comboSel.addItem("Estocastico Univ");
                this.comboSel.addItem("TorneoQK");
                this.comboSel.addItem("Elitista+Ruleta");
                this.comboSel.addItem("Elitista+TorneoQK");
                this.comboSel.addItem("Elitista+Estocas");
                this.comboSel.select(this.getParm("Seleccion", "Ruleta"));
                this.lastComboSel = this.comboSel.getSelectedIndex();
                switch (this.comboSel.getSelectedIndex()) {
                    case 2: {
                        this.setArgs1("Q", "SeleccionParmQ", "2");
                        this.setArgs2("K", "SeleccionParmK", "5");
                        break block0;
                    }
                    case 4: {
                        this.setArgs1("Q", "SeleccionParmQ", "2");
                        this.setArgs2("K", "SeleccionParmK", "3");
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                this.listArgs.setVisible(false);
                this.setGenParmsVisible(false, true);
                this.lastListArgs = -1;
                this.resetArgs();
                this.comboSel.addItem("Ninguno");
                this.comboSel.addItem("ScalerAxB");
                this.comboSel.addItem("Inversa");
                this.comboSel.addItem("Positivo");
                this.comboSel.addItem("Especiacion");
                this.comboSel.addItem("Positivo+AxB");
                this.comboSel.addItem("Positivo+Inversa");
                this.comboSel.addItem("Inversa+Positivo");
                this.comboSel.select(this.getParm("FitnessScaler", "Ninguno"));
                this.lastComboSel = this.comboSel.getSelectedIndex();
                switch (this.comboSel.getSelectedIndex()) {
                    case 1: 
                    case 5: {
                        this.setArgs1("A", "FitnessScalerParmA", "-1");
                        this.setArgs2("B", "FitnessScalerParmB", "0");
                        break;
                    }
                    case 4: {
                        this.setArgs1("Sigma", "FitnessScalerParmSigma", "20");
                        if (Integer.parseInt(this.props.getProperty(this.funcName, "IndividuoParametros", "1")) == 1) break block0;
                        this.showMsg("Warning: el scaler de especiacion solo funciona con funciones de 1 sola variable");
                        break;
                    }
                }
                break;
            }
            default: {
                this.lastListArgs = 0;
                this.listArgs.add("Cruzamiento", 1);
                this.listArgs.add("Mutacion", 2);
                this.listArgs.add("Rango", 3);
                this.listArgs.select(0);
                this.listArgs.setVisible(true);
                this.setGenParmsVisible(false, false);
                this.refreshLayout();
                this.loadArgs();
            }
        }
        this.refreshLayout();
    }

    private void setGenParmsVisible(boolean visible, boolean funcVisible) {
        this.lblFuncion.setVisible(funcVisible);
        this.editFuncion.setVisible(funcVisible);
        this.lblPobInicial.setVisible(visible);
        this.editPobInicial.setVisible(visible);
        this.lblProbCruz.setVisible(visible);
        this.editProbCruz.setVisible(visible);
        this.lblProbMut.setVisible(visible);
        this.editProbMut.setVisible(visible);
    }

    protected void saveArgs() {
        if (this.lastListArgs == -1) {
            block0 : switch (this.lastListParms) {
                case 1: {
                    this.setParm("Seleccion", this.comboSel.getItem(this.lastComboSel));
                    switch (this.lastComboSel) {
                        case 2: {
                            this.setParm("SeleccionParmQ", this.editArg1.getText());
                            this.setParm("SeleccionParmK", this.editArg2.getText());
                            break;
                        }
                        case 4: {
                            this.setParm("SeleccionParmQ", this.editArg1.getText());
                            this.setParm("SeleccionParmK", this.editArg2.getText());
                        }
                    }
                    break;
                }
                case 2: {
                    this.setParm("FitnessScaler", this.comboSel.getItem(this.lastComboSel));
                    switch (this.lastComboSel) {
                        case 1: 
                        case 5: {
                            this.setParm("FitnessScalerParmA", this.editArg1.getText());
                            this.setParm("FitnessScalerParmB", this.editArg2.getText());
                            break block0;
                        }
                        case 4: {
                            this.setParm("FitnessScalerParmSigma", this.editArg1.getText());
                        }
                    }
                }
            }
            return;
        }
        switch (this.lastListArgs) {
            case 1: {
                this.setParm("Mutacion", this.comboSel.getItem(this.lastComboSel));
                switch (this.lastComboSel) {
                    case 1: {
                        this.setParm("MutacionParmHillClimberN", this.editArg1.getText());
                    }
                }
                break;
            }
            case 0: {
                this.setParm("Cruzamiento", this.comboSel.getItem(this.lastComboSel));
                switch (this.lastComboSel) {
                    case 1: {
                        this.setParm("CruzamientoParmCrossPoints", this.editArg1.getText());
                    }
                }
                break;
            }
            case 2: {
                this.comboSel.setVisible(true);
                this.setParm("RangoIzq", this.editArg1.getText());
                this.setParm("RangoDer", this.editArg2.getText());
                this.setParm("RangoBits", this.editArg3.getText());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void getArgs() {
        if (this.lastListArgs == -1) {
            block0 : switch (this.lastListParms) {
                case 1: {
                    this.resetArgs();
                    this.comboSel.select(this.lastComboSel);
                    switch (this.comboSel.getSelectedIndex()) {
                        default: {
                            return;
                        }
                        case 1: {
                            return;
                        }
                        case 2: {
                            this.setArgs1("Q", "SeleccionParmQ", "2");
                            this.setArgs2("K", "SeleccionParmK", "5");
                            return;
                        }
                        case 3: {
                            return;
                        }
                        case 4: {
                            this.setArgs1("Q", "SeleccionParmQ", "2");
                            this.setArgs2("K", "SeleccionParmK", "3");
                            return;
                        }
                        case 5: 
                    }
                    return;
                }
                case 2: {
                    this.resetArgs();
                    this.comboSel.select(this.lastComboSel);
                    switch (this.comboSel.getSelectedIndex()) {
                        case 1: 
                        case 5: {
                            this.setArgs1("A", "FitnessScalerParmA", "-1");
                            this.setArgs2("B", "FitnessScalerParmB", "0");
                            break block0;
                        }
                        case 4: {
                            this.setArgs1("Sigma", "FitnessScalerParmSigma", "20");
                            if (Integer.parseInt(this.props.getProperty(this.funcName, "IndividuoParametros", "1")) == 1) return;
                            this.showMsg("Warning: el scaler de especiacion solo funciona con funciones de 1 sola variable");
                        }
                    }
                }
            }
            return;
        }
        this.resetArgs();
        block15 : switch (this.lastListArgs) {
            case 1: {
                this.comboSel.select(this.lastComboSel);
                switch (this.comboSel.getSelectedIndex()) {
                    default: {
                        break block15;
                    }
                    case 1: 
                }
                this.setArgs1("N", "MutacionParmHillClimberN", "3");
                break;
            }
            case 0: {
                this.comboSel.select(this.lastComboSel);
                switch (this.comboSel.getSelectedIndex()) {
                    case 1: {
                        this.setArgs1("CrossPoints", "CruzamientoParmCrossPoints", "3");
                    }
                }
                break;
            }
            case 2: {
                this.setArgs1("Desde", "RangoIzq", "-15");
                this.setArgs2("Hasta", "RangoDer", "+15");
                this.setArgs3("Bits", "RangoBits", "30");
            }
        }
        this.refreshLayout();
    }

    protected void loadArgs() {
        if (this.lastListArgs == -1) {
            return;
        }
        this.comboSel.removeAll();
        this.resetArgs();
        block0 : switch (this.lastListArgs) {
            case 1: {
                this.comboSel.add("BitFlip");
                this.comboSel.add("HillClimber");
                this.comboSel.select(this.getParm("Mutacion", "BitFlip"));
                switch (this.comboSel.getSelectedIndex()) {
                    default: {
                        break block0;
                    }
                    case 1: 
                }
                this.setArgs1("N", "MutacionParmHillClimberN", "3");
                break;
            }
            case 0: {
                this.comboSel.add("SPX");
                this.comboSel.add("MPX");
                this.comboSel.select(this.getParm("Cruzamiento", "SPX"));
                switch (this.comboSel.getSelectedIndex()) {
                    case 1: {
                        this.setArgs1("CrossPoints", "CruzamientoParmCrossPoints", "3");
                    }
                }
                break;
            }
            case 2: {
                this.comboSel.setVisible(false);
                this.setArgs1("Desde", "RangoIzq", "-15");
                this.setArgs2("Hasta", "RangoDer", "+15");
                this.setArgs3("Bits", "RangoBits", "30");
            }
        }
        this.lastComboSel = this.comboSel.getSelectedIndex();
    }

    private void resetArgs() {
        this.lblArg1.setVisible(false);
        this.editArg1.setVisible(false);
        this.lblArg2.setVisible(false);
        this.editArg2.setVisible(false);
        this.lblArg3.setVisible(false);
        this.editArg3.setVisible(false);
    }

    private void setArgs1(String lbl, String prop, String def) {
        this.lblArg1.setText(lbl);
        this.editArg1.setText(this.getParm(prop, def));
        this.lblArg1.setVisible(true);
        this.editArg1.setVisible(true);
    }

    private void setArgs2(String lbl, String prop, String def) {
        this.lblArg2.setText(lbl);
        this.editArg2.setText(this.getParm(prop, def));
        this.lblArg2.setVisible(true);
        this.editArg2.setVisible(true);
    }

    private void setArgs3(String lbl, String prop, String def) {
        this.lblArg3.setText(lbl);
        this.editArg3.setText(this.getParm(prop, def));
        this.lblArg3.setVisible(true);
        this.editArg3.setVisible(true);
    }

    void listArgs_itemStateChanged(ItemEvent e) {
        this.showMsg(this.listArgs.getSelectedItem() + " seleccionado");
        this.saveArgs();
        this.lastListArgs = this.listArgs.getSelectedIndex();
        this.lastComboSel = 0;
        this.loadArgs();
        this.refreshLayout();
    }

    private String getParm(String parm, String def) {
        if (this.lastListParms >= 3) {
            return this.props.getProperty(this.funcName, parm + "_" + (this.lastListParms - 3 + 1), def);
        }
        return this.props.getProperty(this.funcName, parm, def);
    }

    private void setParm(String parm, String value) {
        if (this.lastListParms >= 3) {
            this.props.setProperty(this.funcName, parm + "_" + (this.lastListParms - 3 + 1), value);
        } else {
            this.props.setProperty(this.funcName, parm, value);
        }
    }

    void comboSel_itemStateChanged(ItemEvent e) {
        this.saveArgs();
        this.lastComboSel = this.comboSel.getSelectedIndex();
        this.getArgs();
    }

    private void setEditable(boolean editable) {
        this.editArg1.setEnabled(editable);
        this.editArg2.setEnabled(editable);
        this.editArg3.setEnabled(editable);
        this.comboSel.setEnabled(editable);
        this.editFuncion.setEnabled(editable);
        this.editPobInicial.setEnabled(editable);
        this.editProbCruz.setEnabled(editable);
        this.editProbMut.setEnabled(editable);
    }

    private void refreshLayout() {
        this.panelOpciones.doLayout();
        this.panelParams.doLayout();
    }

    void button_actionPerformed(ActionEvent e) {
        block10: {
            String command = e.getActionCommand();
            try {
                if (command.equalsIgnoreCase("Reset") && this.running) {
                    this.running = false;
                    this.refreshLayout();
                    this.motorRunnerThread.stop();
                    this.setEditable(true);
                    this.graph.reset();
                    this.motorRunnerThread = new MotorRunnerThread();
                    return;
                }
                if (command.equalsIgnoreCase("Correr")) {
                    if (!this.running) {
                        if (this.initMotor()) {
                            this.motorRunnerThread.iterar();
                        }
                        return;
                    }
                    if (this.running) {
                        this.motorRunnerThread.iterarN(IterarNVeces);
                        return;
                    }
                }
                if (!command.equalsIgnoreCase("Paso")) break block10;
                if (!this.running) {
                    if (this.initMotor()) {
                        this.motorRunnerThread.paso();
                    }
                    return;
                }
                if (this.running) {
                    this.motorRunnerThread.paso();
                    return;
                }
            }
            catch (Throwable ex) {
                this.showMsg("Error en Motor: " + ex.toString());
                ex.printStackTrace();
            }
        }
    }

    private double getDoubleProp(String prop, int parmNum) throws Exception {
        try {
            return new Double(this.props.getProperty(this.funcName, prop + (parmNum > 0 ? "_" + parmNum : ""), "No definido"));
        }
        catch (Exception e) {
            throw new MotorException("Error parseando property: " + prop + " -> " + e.toString());
        }
    }

    private int getIntProp(String prop, int parmNum) throws Exception {
        try {
            return new Integer(this.props.getProperty(this.funcName, prop + (parmNum > 0 ? "_" + parmNum : ""), "No definido"));
        }
        catch (Exception e) {
            throw new MotorException("Error parseando property: " + prop + " -> " + e.toString());
        }
    }

    private String getStringProp(String prop, int parmNum) {
        return this.props.getProperty(this.funcName, prop + (parmNum > 0 ? "_" + parmNum : ""), "No definido");
    }

    public boolean initMotor() {
        this.saveParms();
        this.saveArgs();
        try {
            GeneracionSimple generacion;
            IMutacion mutacion;
            ICruzamiento cruzamiento;
            IIndividuo individuo;
            ISeleccion seleccion;
            this.showMsg("Parseando datos...");
            int cantParms = new Integer(this.getIntProp("IndividuoParametros", 0));
            this.graphVarSelector.removeAll();
            if (cantParms != 1) {
                int i = 0;
                while (i < cantParms) {
                    this.graphVarSelector.addItem("f(" + (i + 1) + ")");
                    ++i;
                }
                this.graphVarSelector.select(0);
                this.graphVarSelector.setEnabled(true);
                this.graphVarSelector.setVisible(true);
                this.setGraphVarSelector();
                this.refreshLayout();
            } else {
                this.graphVarSelector.addItem("x");
                this.graphVarSelector.select(0);
                this.graphVarSelector.setEnabled(false);
                this.graphVarSelector.setVisible(true);
                this.refreshLayout();
            }
            FitnessScaler fitnessScaler = null;
            IIndividuo[] parmIndividuo = new IIndividuo[cantParms];
            ICruzamiento[] parmCruzamiento = new ICruzamiento[cantParms];
            IMutacion[] parmMutacion = new IMutacion[cantParms];
            String tipoSeleccion = this.getStringProp("Seleccion", 0);
            if (tipoSeleccion.equalsIgnoreCase("Ruleta")) {
                seleccion = new SeleccionRuleta();
            } else if (tipoSeleccion.equalsIgnoreCase("Estocastico Univ")) {
                seleccion = new SeleccionEstocasticaUniversal();
            } else if (tipoSeleccion.equalsIgnoreCase("TorneoQK")) {
                seleccion = new SeleccionTorneoQK(this.getIntProp("SeleccionParmQ", 0), this.getIntProp("SeleccionParmK", 0));
            } else if (tipoSeleccion.equalsIgnoreCase("Elitista+Ruleta")) {
                seleccion = new SeleccionElitista(new SeleccionRuleta());
            } else if (tipoSeleccion.equalsIgnoreCase("Elitista+TorneoQK")) {
                seleccion = new SeleccionElitista(new SeleccionTorneoQK(this.getIntProp("SeleccionParmQ", 0), this.getIntProp("SeleccionParmK", 0)));
            } else if (tipoSeleccion.equalsIgnoreCase("Elitista+Estocas")) {
                seleccion = new SeleccionElitista(new SeleccionEstocasticaUniversal());
            } else {
                throw new IllegalArgumentException("El operador de seleccion es invalido");
            }
            String tipoFitnessScaler = this.getStringProp("FitnessScaler", 0);
            if (tipoFitnessScaler.equalsIgnoreCase("ScalerAxB")) {
                fitnessScaler = new FitnessScalerAxB(new FitnessScalerSink(), this.getDoubleProp("FitnessScalerParmA", 0), this.getDoubleProp("FitnessScalerParmB", 0));
            } else if (tipoFitnessScaler.equalsIgnoreCase("Inversa")) {
                fitnessScaler = new FitnessScalerInversa(new FitnessScalerSink());
            } else if (tipoFitnessScaler.equalsIgnoreCase("Positivo")) {
                fitnessScaler = new FitnessScalerPositive(new FitnessScalerSink());
            } else if (tipoFitnessScaler.equalsIgnoreCase("Especiacion")) {
                fitnessScaler = new FitnessScalerEspeciacion(new FitnessScalerSink(), this.getIntProp("FitnessScalerParmSigma", 0));
                if (Integer.parseInt(this.props.getProperty(this.funcName, "IndividuoParametros", "1")) != 1) {
                    throw new MotorException("El scaler de especiacion solo funciona con funciones de 1 sola variable");
                }
            } else if (tipoFitnessScaler.equalsIgnoreCase("Positivo+AxB")) {
                fitnessScaler = new FitnessScalerPositive(new FitnessScalerAxB(new FitnessScalerSink(), this.getDoubleProp("FitnessScalerParmA", 0), this.getDoubleProp("FitnessScalerParmB", 0)));
            } else if (tipoFitnessScaler.equalsIgnoreCase("Positivo+Inversa")) {
                fitnessScaler = new FitnessScalerPositive(new FitnessScalerInversa(new FitnessScalerSink()));
            } else if (tipoFitnessScaler.equalsIgnoreCase("Inversa+Positivo")) {
                fitnessScaler = new FitnessScalerInversa(new FitnessScalerPositive(new FitnessScalerSink()));
            }
            int i = 0;
            while (i < cantParms) {
                int curParm = i + 1;
                parmIndividuo[i] = new FuncionExpresion(this.getStringProp("Funcion", 0), this.getDoubleProp("RangoIzq", curParm), this.getDoubleProp("RangoDer", curParm), this.getIntProp("RangoBits", curParm), cantParms == 1 ? "x" : "f(" + curParm + ")");
                String tipoCruzamiento = this.getStringProp("Cruzamiento", curParm);
                if (tipoCruzamiento.equalsIgnoreCase("SPX")) {
                    parmCruzamiento[i] = new CruzamientoSPX();
                } else if (tipoCruzamiento.equalsIgnoreCase("MPX")) {
                    parmCruzamiento[i] = new CruzamientoMPX(this.getIntProp("CruzamientoParmCrossPoints", curParm));
                } else {
                    throw new IllegalArgumentException("El operador de cruzamiento para la variable " + curParm + " es invalido");
                }
                String tipoMutacion = this.getStringProp("Mutacion", curParm);
                if (tipoMutacion.equalsIgnoreCase("BitFlip")) {
                    parmMutacion[i] = new MutacionBitFlip();
                } else if (tipoMutacion.equalsIgnoreCase("HillClimber")) {
                    parmMutacion[i] = new MutacionHillClimber(this.getIntProp("MutacionParmHillClimberN", curParm));
                } else {
                    throw new IllegalArgumentException("El operador de mutacion para la variable " + curParm + " es invalido");
                }
                ++i;
            }
            if (cantParms == 1) {
                individuo = parmIndividuo[0];
                cruzamiento = parmCruzamiento[0];
                mutacion = parmMutacion[0];
            } else {
                individuo = new IndividuoMultipleFuncionExpresion(this.getStringProp("Funcion", 0), parmIndividuo);
                OperadorMultiple operadorMultiple = new OperadorMultiple(parmCruzamiento, parmMutacion);
                cruzamiento = operadorMultiple;
                mutacion = operadorMultiple;
            }
            String tipoGeneracion = this.getStringProp("Generacion", 0);
            if (tipoGeneracion.equalsIgnoreCase("Simple")) {
                generacion = new GeneracionSimple(individuo, this.getIntProp("PoblacionInicial", 0), this.getDoubleProp("ProbabilidadCruzamiento", 0), this.getDoubleProp("ProbabilidadMutacion", 0));
            } else if (tipoGeneracion.equalsIgnoreCase("DeJong")) {
                generacion = new GeneracionSimpleDeJong(individuo, this.getIntProp("PoblacionInicial", 0), this.getDoubleProp("ProbabilidadCruzamiento", 0), this.getDoubleProp("ProbabilidadMutacion", 0));
            } else {
                throw new IllegalArgumentException("La tipo de Generacion seleccionado es invalido");
            }
            this.motor = new MotorAG(generacion, seleccion, cruzamiento, mutacion);
            this.motor.setFitnessScaler(fitnessScaler);
            this.graph.initialize(this.motor);
            this.running = true;
            this.setEditable(false);
            return true;
        }
        catch (Throwable e) {
            this.showMsg("No se pudo incializar el motor: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public void componentHidden(ComponentEvent evt) {
    }

    public void componentShown(ComponentEvent evt) {
    }

    public void componentMoved(ComponentEvent evt) {
    }

    public void componentResized(ComponentEvent evt) {
        int rows = super.getSize().height / 45;
        this.textAreaAyuda.setRows(rows < 5 ? 5 : rows);
        this.doLayout();
        this.panel1.doLayout();
        this.panelButtons.doLayout();
        this.refreshLayout();
    }

    class MotorRunnerThread
    extends Thread {
        public final int NONE = 0;
        public final int ITERAR = 1;
        public final int ITERARN = 2;
        public final int PASO = 3;
        private int whatToDo = 0;
        private int NVeces = 50;

        public MotorRunnerThread() {
            super("MotorRunnerThread");
            super.setDaemon(true);
            super.start();
        }

        public synchronized void iterar() {
            this.whatToDo = 1;
            this.notifyAll();
        }

        public synchronized void iterarN(int NVeces) {
            this.NVeces = NVeces;
            this.whatToDo = 2;
            this.notifyAll();
        }

        public synchronized void paso() {
            this.whatToDo = 3;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    MotorRunnerThread motorRunnerThread = this;
                    synchronized (motorRunnerThread) {
                        this.wait();
                    }
                    switch (this.whatToDo) {
                        case 1: {
                            FunctionSolverAppletAWT.this.motor.iterar();
                            break;
                        }
                        case 2: {
                            FunctionSolverAppletAWT.this.motor.iterar(this.NVeces);
                            break;
                        }
                        case 3: {
                            FunctionSolverAppletAWT.this.motor.iterarOnce();
                        }
                    }
                    this.whatToDo = 0;
                    continue;
                }
                catch (Throwable e) {
                    if (!(e instanceof ThreadDeath) && !(e instanceof InterruptedException)) {
                        e.printStackTrace();
                        FunctionSolverAppletAWT.this.showMsg(e.getMessage());
                        continue;
                    }
                    switch (this.whatToDo) {
                        case 1: {
                            FunctionSolverAppletAWT.this.showMsg("Se ha interrumpido la operacion de correr");
                            break;
                        }
                        case 2: {
                            FunctionSolverAppletAWT.this.showMsg("Se ha interrumpido la operacion de iterar " + this.NVeces + " veces");
                            break;
                        }
                        case 3: {
                            FunctionSolverAppletAWT.this.showMsg("Se ha interrumpido la operacion de iterar un paso");
                        }
                    }
                    continue;
                }
                break;
            }
        }
    }
}

