/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.ag;

import com.brownsoft.ag.IGeneracion;
import com.brownsoft.ag.IIndividuo;
import com.brownsoft.ag.MotorAG;
import com.brownsoft.ag.MotorException;
import java.util.Vector;

public class GeneracionSimple
implements IGeneracion {
    protected int pobSize;
    protected IIndividuo individuo;
    protected MotorAG motor;
    protected double pCross;
    protected double pMutacion;

    public GeneracionSimple(IIndividuo individuo, int pobSize, double pCross, double pMutacion) throws MotorException {
        this.individuo = individuo;
        this.pobSize = pobSize;
        this.pCross = pCross;
        this.pMutacion = pMutacion;
        if (pobSize < 1) {
            throw new MotorException("La poblacion debe ser mayor a 0");
        }
        if (pCross > 1.0 || pCross < 0.0) {
            throw new MotorException("pCross debe tener valores entre 0 y 1");
        }
        if (pMutacion > 1.0 || pMutacion < 0.0) {
            throw new MotorException("pMutacion debe tener valores entre 0 y 1");
        }
    }

    public void inicializar(MotorAG motor) {
        this.motor = motor;
    }

    public Vector getPoblacionInicial() {
        Vector<IIndividuo> poblacion = new Vector<IIndividuo>();
        int i = 0;
        while (i < this.pobSize) {
            IIndividuo newIndividual = this.individuo.getCopy();
            newIndividual.setRandom();
            poblacion.addElement(newIndividual);
            ++i;
        }
        return poblacion;
    }

    public int getMatingSize() {
        return this.pobSize;
    }

    public boolean getFinalizarIteracion() {
        return this.motor.getTotIteraciones() >= 10;
    }

    public double getpCross() {
        return this.pCross;
    }

    public double getpMutacion() {
        return this.pMutacion;
    }

    public void inicioIteracion() {
    }

    public void finIteracion() {
    }

    public void finAlgoritmo() {
    }
}

