/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.ag;

import com.brownsoft.ag.GeneracionSimple;
import com.brownsoft.ag.IIndividuo;
import com.brownsoft.ag.MotorException;

public class GeneracionSimpleDeJong
extends GeneracionSimple {
    protected double escala;
    protected int T;
    protected double onLinePerformance = -1.7976931348623157E308;
    protected double offLinePerformance = -1.7976931348623157E308;
    protected double bestFitnessSoFar = -1.7976931348623157E308;
    protected double lastOffLinePerformance = -1.7976931348623157E308;
    protected double lastOnLinePerformance = -1.7976931348623157E308;
    double diff = 0.0;

    public GeneracionSimpleDeJong(IIndividuo individuo, int pobSize, double pCross, double pMutacion) throws MotorException {
        this(individuo, pobSize, pCross, pMutacion, 1.0E8);
    }

    public GeneracionSimpleDeJong(IIndividuo individuo, int pobSize, double pCross, double pMutacion, double escala) throws MotorException {
        super(individuo, pobSize, pCross, pMutacion);
        this.escala = escala;
    }

    public void finIteracion() {
        this.lastOnLinePerformance = this.onLinePerformance;
        ++this.T;
        IIndividuo bestIndividuo = this.motor.getBestIndividuo();
        double currFitness = this.motor.getFitness(bestIndividuo);
        this.bestFitnessSoFar = currFitness > this.bestFitnessSoFar ? currFitness : this.bestFitnessSoFar;
        this.onLinePerformance = (this.onLinePerformance * (double)(this.T - 1) + currFitness) / (double)this.T;
        this.offLinePerformance = (this.offLinePerformance * (double)(this.T - 1) + this.bestFitnessSoFar) / (double)this.T;
    }

    public double getOnLinePerformance() {
        return this.onLinePerformance;
    }

    public double getOffLinePerformance() {
        return this.offLinePerformance;
    }

    public boolean getFinalizarIteracion() {
        if (this.T < 10) {
            return false;
        }
        return this.onLinePerformance - this.lastOnLinePerformance < this.escala;
    }
}

