/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.ag;

import com.brownsoft.ag.ICruzamiento;
import com.brownsoft.ag.IGeneracion;
import com.brownsoft.ag.IIndividuo;
import com.brownsoft.ag.IMotorListener;
import com.brownsoft.ag.IMutacion;
import com.brownsoft.ag.ISeleccion;
import com.brownsoft.ag.MotorException;
import com.brownsoft.ag.PRNG;
import com.brownsoft.ag.fitnessScaler.FitnessScaler;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MotorAG {
    private Hashtable fitnessMapping = new Hashtable();
    private Vector poblacion = new Vector();
    private int totIteraciones;
    private IGeneracion generacion;
    private ISeleccion seleccion;
    private ICruzamiento cruzamiento;
    private IMutacion mutacion;
    private IMotorListener[] listeners = new IMotorListener[0];
    private FitnessScaler fitnessScaler = null;

    public MotorAG(IGeneracion generacion, ISeleccion seleccion, ICruzamiento cruzamiento, IMutacion mutacion) {
        this.generacion = generacion;
        this.seleccion = seleccion;
        this.cruzamiento = cruzamiento;
        this.mutacion = mutacion;
        this.addListener(generacion);
        this.addListener(seleccion);
        this.addListener(cruzamiento);
        this.addListener(mutacion);
        generacion.inicializar(this);
        seleccion.inicializar(this);
        cruzamiento.inicializar(this);
        mutacion.inicializar(this, generacion.getpMutacion());
        this.totIteraciones = 0;
        this.poblacion = generacion.getPoblacionInicial();
    }

    public boolean iterarOnce() throws MotorException {
        this.fireInicioIteracion();
        ++this.totIteraciones;
        int poolSize = 0;
        int matingSize = this.generacion.getMatingSize();
        while (poolSize < matingSize) {
            IIndividuo[] seleccionados = this.seleccion.seleccionar();
            if (this.generacion.getpCross() >= PRNG.nextProbability()) {
                seleccionados = this.cruzamiento.cruzar(seleccionados);
            }
            poolSize += seleccionados.length;
            int k = 0;
            while (k < seleccionados.length) {
                seleccionados[k] = this.mutacion.mutar(seleccionados[k]);
                ++k;
            }
            this.seleccion.ponerEnPoolIntermedio(seleccionados);
        }
        this.poblacion = this.seleccion.generarNuevaPoblacion();
        this.fireFinIteracion();
        if (this.generacion.getFinalizarIteracion()) {
            this.fireFinAlgoritmo();
            return true;
        }
        return false;
    }

    public void iterar(int cantIteraciones) throws MotorException {
        int i = 0;
        while (i < cantIteraciones) {
            this.iterarOnce();
            ++i;
        }
    }

    public void iterar() throws MotorException {
        while (!this.generacion.getFinalizarIteracion()) {
            this.iterarOnce();
        }
    }

    public int getTotIteraciones() {
        return this.totIteraciones;
    }

    public Vector getPoblacion() {
        return this.poblacion;
    }

    public Hashtable getFitnessMapping() {
        return this.fitnessMapping;
    }

    public double getNonScaledFitness(IIndividuo individuo) {
        Double fitness = (Double)this.fitnessMapping.get(individuo);
        if (fitness == null) {
            fitness = new Double(individuo.getFitness());
            this.fitnessMapping.put(individuo.getCopy(), fitness);
        }
        return fitness;
    }

    public double getFitness(IIndividuo individuo) {
        if (this.fitnessScaler == null) {
            return this.getNonScaledFitness(individuo);
        }
        return this.fitnessScaler.getScaledFitness(individuo);
    }

    public void setFitnessScaler(FitnessScaler fitnessScaler) {
        this.fitnessScaler = fitnessScaler;
        if (fitnessScaler != null) {
            fitnessScaler.initScaler(this);
        }
    }

    public void clearFitnesses() {
        this.fitnessMapping.clear();
    }

    public IIndividuo getBestIndividuo() {
        IIndividuo best = null;
        double bestFitness = -1.7976931348623157E308;
        Enumeration enumeration = this.poblacion.elements();
        while (enumeration.hasMoreElements()) {
            IIndividuo individuo = (IIndividuo)enumeration.nextElement();
            double fitness = this.getFitness(individuo);
            if (!(fitness > bestFitness)) continue;
            best = individuo;
            bestFitness = fitness;
        }
        if (best == null) {
            return null;
        }
        return best.getCopy();
    }

    public void addListener(IMotorListener listener) {
        IMotorListener[] newListeners = new IMotorListener[this.listeners.length + 1];
        System.arraycopy(this.listeners, 0, newListeners, 0, this.listeners.length);
        newListeners[this.listeners.length] = listener;
        this.listeners = newListeners;
    }

    public void removeListener(IMotorListener listener) {
        int i = 0;
        while (i < this.listeners.length) {
            if (this.listeners[i] == listener) {
                IMotorListener[] newListeners = new IMotorListener[this.listeners.length - 1];
                System.arraycopy(this.listeners, 0, newListeners, 0, i);
                System.arraycopy(this.listeners, i + 1, newListeners, i, this.listeners.length - i - 1);
                return;
            }
            ++i;
        }
    }

    protected void fireInicioIteracion() {
        if (this.fitnessScaler != null) {
            this.fitnessScaler.fireInicioIteracion();
        }
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].inicioIteracion();
            ++i;
        }
    }

    protected void fireFinIteracion() {
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].finIteracion();
            ++i;
        }
    }

    protected void fireFinAlgoritmo() {
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].finAlgoritmo();
            ++i;
        }
    }

    public IGeneracion getGeneracion() {
        return this.generacion;
    }

    public ISeleccion getOperadorSeleccion() {
        return this.seleccion;
    }

    public ICruzamiento getOperadorCruzamiento() {
        return this.cruzamiento;
    }

    public IMutacion getOperadorMutacion() {
        return this.mutacion;
    }
}

