/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.ag.fitnessScaler;

import com.brownsoft.ag.IFitnessScaler;
import com.brownsoft.ag.IIndividuo;
import com.brownsoft.ag.fitnessScaler.FitnessScaler;
import java.util.Enumeration;

public class FitnessScalerPositive
extends FitnessScaler {
    private double cantToSum = 0.0;
    private boolean calculandoCantToSum = false;

    public FitnessScalerPositive(IFitnessScaler parent) {
        super(parent);
    }

    protected double scaleFitness(double fitness) {
        if (this.calculandoCantToSum) {
            return fitness;
        }
        if (fitness + this.cantToSum < 0.0) {
            return 0.0;
        }
        return fitness + this.cantToSum;
    }

    public void inicioIteracion() {
        this.calculandoCantToSum = true;
        double currentMinFitness = Double.MAX_VALUE;
        Enumeration enumeration = super.getMotor().getPoblacion().elements();
        while (enumeration.hasMoreElements()) {
            double currentFitness = super.getScaledFitness((IIndividuo)enumeration.nextElement());
            if (!(currentFitness < currentMinFitness)) continue;
            currentMinFitness = currentFitness;
        }
        this.cantToSum = currentMinFitness < 0.0 ? -currentMinFitness : 0.0;
        this.calculandoCantToSum = false;
    }
}

