/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.ag.individuo;

import com.brownsoft.ag.IIndividuo;
import com.brownsoft.ag.MotorError;
import com.brownsoft.ag.individuo.FuncionPuntoFijo;
import com.brownsoft.ag.individuo.IndividuoMultiple;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class EvaluaExpresion {
    String expresion;
    protected boolean isSimple;
    protected IIndividuo contained;

    protected EvaluaExpresion(String expresion) throws IllegalArgumentException {
        this.expresion = expresion;
        if (!this.matchParentesis(expresion)) {
            throw new IllegalArgumentException("La expresion '" + expresion + "' no tiene los par\u00e9ntesis balanceados");
        }
    }

    public double getFitness(IIndividuo individuo) {
        try {
            this.contained = individuo;
            this.isSimple = individuo instanceof FuncionPuntoFijo;
            return this.eval(this.expresion);
        }
        catch (Exception e) {
            throw new MotorError("No se pudo evaluar la expresion '" + this.expresion + "': " + e.getMessage(), e);
        }
    }

    public double eval(String expr) {
        StringTokenizer tokenizer = new StringTokenizer(expr, "+-/*", true);
        return this.evaluate(tokenizer);
    }

    private double evaluate(StringTokenizer tokenizer) {
        double retVal = this.eval(tokenizer);
        double termino = 0.0;
        while (tokenizer.hasMoreTokens()) {
            char operador = tokenizer.nextToken().charAt(0);
            switch (operador) {
                case '+': {
                    termino = this.evaluate(tokenizer);
                    retVal += termino;
                    break;
                }
                case '-': {
                    termino = this.evaluate(tokenizer);
                    retVal -= termino;
                    break;
                }
                case '*': {
                    termino = this.eval(tokenizer);
                    retVal *= termino;
                    break;
                }
                case '/': {
                    termino = this.eval(tokenizer);
                    retVal /= termino;
                }
            }
        }
        return retVal;
    }

    private double eval(StringTokenizer tokenizer) {
        String token = this.getNextToken(tokenizer);
        if (token.equalsIgnoreCase("-")) {
            return -this.eval(tokenizer);
        }
        if (token.equalsIgnoreCase("+")) {
            return this.eval(tokenizer);
        }
        if (token.startsWith("(")) {
            return this.eval(token.substring(1, token.length() - 1));
        }
        if (Character.isDigit(token.charAt(0)) || token.charAt(0) == '.') {
            return new Double(token);
        }
        if (token.equalsIgnoreCase("PI")) {
            return Math.PI;
        }
        if (token.equalsIgnoreCase("x")) {
            if (this.isSimple) {
                return ((FuncionPuntoFijo)this.contained).value();
            }
            throw new IllegalArgumentException("'x' solo puede ser usado en expresiones con individuos simples (1 sola variable)");
        }
        if (token.startsWith("f(")) {
            if (!this.isSimple) {
                int idx = new Integer(token.substring(2, token.length() - 1)) - 1;
                try {
                    return ((FuncionPuntoFijo)((IndividuoMultiple)this.contained).getParameter(idx)).value();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new IllegalArgumentException("Indice erroneo en llamada a '" + token + "'. Rango: 1..." + ((IndividuoMultiple)this.contained).parametros.length);
                }
            }
            throw new IllegalArgumentException(token + " solo puede ser usado en expresiones con individuos complejos (mas de 1 variable)");
        }
        String funcName = token.substring(0, token.indexOf(40));
        return this.evalFuncCall(funcName, token.substring(funcName.length() + 1, token.length() - 1));
    }

    private double evalFuncCall(String funcName, String expr) {
        String sarg2;
        String sarg1;
        if (funcName.equalsIgnoreCase("rnd")) {
            return Math.random();
        }
        if (funcName.equalsIgnoreCase("abs")) {
            return Math.abs(this.eval(expr));
        }
        if (funcName.equalsIgnoreCase("int")) {
            return (long)this.eval(expr);
        }
        if (funcName.equalsIgnoreCase("frac")) {
            double value = this.eval(expr);
            return value - (double)((long)value);
        }
        if (funcName.equalsIgnoreCase("sin")) {
            return Math.sin(this.eval(expr));
        }
        if (funcName.equalsIgnoreCase("asin")) {
            return Math.asin(this.eval(expr));
        }
        if (funcName.equalsIgnoreCase("cos")) {
            return Math.cos(this.eval(expr));
        }
        if (funcName.equalsIgnoreCase("acos")) {
            return Math.acos(this.eval(expr));
        }
        if (funcName.equalsIgnoreCase("tan")) {
            return Math.tan(this.eval(expr));
        }
        if (funcName.equalsIgnoreCase("atan")) {
            return Math.atan(this.eval(expr));
        }
        if (funcName.equalsIgnoreCase("floor")) {
            return Math.floor(this.eval(expr));
        }
        if (funcName.equalsIgnoreCase("round")) {
            return Math.round(this.eval(expr));
        }
        if (funcName.equalsIgnoreCase("ln") || funcName.equalsIgnoreCase("log")) {
            double val = this.eval(expr);
            if (val <= 0.0) {
                throw new IllegalArgumentException("Argumento invalido (" + val + ") en llamada a log(" + expr + ")");
            }
            return Math.log(val);
        }
        if (funcName.equalsIgnoreCase("exp")) {
            return Math.exp(this.eval(expr));
        }
        if (funcName.equalsIgnoreCase("sqrt")) {
            return Math.sqrt(this.eval(expr));
        }
        StringTokenizer paramTokenizer = new StringTokenizer(expr, ",", false);
        try {
            sarg1 = this.getNextToken(paramTokenizer);
            sarg2 = this.getNextToken(paramTokenizer);
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("No se puede procesar la funcion de 2 argumentos '" + funcName + "' en la expresion '" + expr + "'");
        }
        double arg1 = this.eval(sarg1);
        double arg2 = this.eval(sarg2);
        if (funcName.equalsIgnoreCase("pow")) {
            return Math.pow(arg1, arg2);
        }
        if (funcName.equalsIgnoreCase("max")) {
            return Math.max(arg1, arg2);
        }
        if (funcName.equalsIgnoreCase("min")) {
            return Math.min(arg1, arg2);
        }
        throw new IllegalArgumentException("No se puede parsear la funcion '" + funcName + "' en la expresion" + this.expresion);
    }

    private String getNextToken(StringTokenizer tokenizer) {
        String token = "";
        while (!this.matchParentesis(token = token + tokenizer.nextToken())) {
        }
        return token.trim();
    }

    private boolean matchParentesis(String token) {
        int cantLeft = 0;
        int cantRight = 0;
        int i = 0;
        while (i < token.length()) {
            char c = token.charAt(i);
            if (c == '(') {
                ++cantLeft;
            }
            if (c == ')') {
                ++cantRight;
            }
            ++i;
        }
        return cantLeft == cantRight;
    }

    public String toString() {
        return this.contained.toString();
    }
}

