/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.ag.seleccion;

import com.brownsoft.ag.IIndividuo;
import com.brownsoft.ag.ISeleccion;
import com.brownsoft.ag.MotorAG;
import com.brownsoft.ag.MotorException;
import java.util.Vector;

public class SeleccionNSelecciones
implements ISeleccion {
    protected ISeleccion seleccion;
    protected int N;

    public SeleccionNSelecciones(ISeleccion seleccion, int N) throws MotorException {
        if (N < 1) {
            throw new MotorException("La cantidad de veces a ejecutar la seleccion por iteracion debe ser mayor que 0 (N=" + N + ")");
        }
        this.seleccion = seleccion;
        this.N = N;
    }

    public void inicializar(MotorAG motor) {
        this.seleccion.inicializar(motor);
    }

    public void inicioIteracion() {
        this.seleccion.inicioIteracion();
    }

    public void finIteracion() {
        this.seleccion.finIteracion();
    }

    public void finAlgoritmo() {
        this.seleccion.finAlgoritmo();
    }

    public IIndividuo[] seleccionar() {
        IIndividuo[] seleccionados = new IIndividuo[]{};
        int i = 0;
        while (i < this.N) {
            IIndividuo[] seleccionadosIteracion = this.seleccion.seleccionar();
            IIndividuo[] temp = new IIndividuo[seleccionados.length + seleccionadosIteracion.length];
            System.arraycopy(seleccionados, 0, temp, 0, seleccionados.length);
            System.arraycopy(seleccionadosIteracion, 0, temp, seleccionados.length, seleccionadosIteracion.length);
            seleccionados = temp;
            ++i;
        }
        return seleccionados;
    }

    public void ponerEnPoolIntermedio(IIndividuo[] individuos) {
        this.seleccion.ponerEnPoolIntermedio(individuos);
    }

    public Vector generarNuevaPoblacion() {
        return this.seleccion.generarNuevaPoblacion();
    }
}

