/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.ag.seleccion;

import com.brownsoft.ag.IIndividuo;
import com.brownsoft.ag.ISeleccion;
import com.brownsoft.ag.MotorAG;
import com.brownsoft.ag.MotorException;
import com.brownsoft.ag.PRNG;
import java.util.Vector;

public class SeleccionTorneoQK
implements ISeleccion {
    private MotorAG motor;
    private Vector poblacionIteracion;
    private Vector poolIntermedio;
    private int Q;
    private int K;

    public SeleccionTorneoQK(int Q, int K) throws MotorException {
        if (Q > K) {
            throw new MotorException("El argumento Q no puede ser mayor que K en la Seleccion por Torneo Q-K (Q=" + Q + ",K=" + K + ")");
        }
        if (Q < 1 || K < 1) {
            throw new MotorException("Los argumentos Q y K deben ser igual o mayores que 1 (Q=" + Q + ",K=" + K + ")");
        }
        this.Q = Q;
        this.K = K;
    }

    public void inicializar(MotorAG motor) {
        this.motor = motor;
        this.poolIntermedio = new Vector();
    }

    public void inicioIteracion() {
        this.poolIntermedio.removeAllElements();
    }

    public IIndividuo[] seleccionar() {
        IIndividuo[] torneo = new IIndividuo[this.K];
        IIndividuo[] seleccionados = new IIndividuo[this.Q];
        Vector poblacion = this.motor.getPoblacion();
        int popSize = poblacion.size();
        int i = 0;
        while (i < this.K) {
            torneo[i] = (IIndividuo)poblacion.elementAt(PRNG.nextInt(popSize));
            ++i;
        }
        int i2 = 0;
        while (i2 < this.Q) {
            int j = this.K - 1;
            while (j > i2) {
                if (this.motor.getFitness(torneo[j - 1]) < this.motor.getFitness(torneo[j])) {
                    IIndividuo temp = torneo[j];
                    torneo[j] = torneo[j - 1];
                    torneo[j - 1] = temp;
                }
                --j;
            }
            seleccionados[i2] = torneo[i2];
            ++i2;
        }
        return seleccionados;
    }

    public void ponerEnPoolIntermedio(IIndividuo[] individuos) {
        int i = 0;
        while (i < individuos.length) {
            this.poolIntermedio.addElement(individuos[i]);
            ++i;
        }
    }

    public Vector generarNuevaPoblacion() {
        return (Vector)this.poolIntermedio.clone();
    }

    public void finIteracion() {
    }

    public void finAlgoritmo() {
    }
}

