/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.gui;

import com.brownsoft.ag.GeneracionSimpleDeJong;
import com.brownsoft.ag.IIndividuo;
import com.brownsoft.ag.IMotorListener;
import com.brownsoft.ag.MotorAG;
import com.brownsoft.ag.individuo.IFuncion;
import com.brownsoft.ag.individuo.IndividuoMultipleFuncionExpresion;
import com.brownsoft.gui.IMsgSink;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;

public class Graph
extends Component
implements ComponentListener,
IMotorListener,
MouseListener,
MouseMotionListener {
    private int screenWidth;
    private int screenHeight;
    private IMsgSink statusBar;
    private MotorAG motor;
    private Point mouseLocation = new Point(0, 0);
    private boolean running = false;
    IIndividuo bestIndividual = null;
    private boolean isDeJong = false;
    static Font bigFont = new Font("Dialog", 1, 14);
    static Font smallFont = new Font("Dialog", 0, 12);
    private boolean fixAxis = false;
    private static int checkSize = 12;
    private static Color checkColor = Color.red.darker();
    static double pixelWidth = 1.0;
    static double pixelHeight = 1.0;
    double rangeIzq;
    double rangeDer;
    double rangeTop;
    double rangeBottom;
    Vector currIndividuals = new Vector();
    int curVarIndependiente = 0;
    Point draggingInit = new Point(0, 0);
    Point draggingEnd = new Point(0, 0);
    boolean dragging = false;
    boolean isZoomIn = false;

    public Graph(IMsgSink statusBar) {
        this.statusBar = statusBar;
        super.addComponentListener(this);
        super.addMouseListener(this);
        super.addMouseMotionListener(this);
    }

    public void initialize(MotorAG motor) {
        this.motor = motor;
        this.running = true;
        motor.addListener(this);
        this.isDeJong = motor.getGeneracion() instanceof GeneracionSimpleDeJong;
    }

    public void showMsg(String msg) {
        this.statusBar.showMsg(msg);
    }

    public int getWidth() {
        return this.getSize().width;
    }

    public int getHeight() {
        return this.getSize().height;
    }

    public void paint(Graphics g) {
        if (this.motor == null) {
            g.setColor(Color.green);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            return;
        }
        if (!this.running) {
            g.setColor(Color.yellow);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            g.setColor(Color.lightGray);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.dragging) {
            g.setColor(Color.cyan);
            g.fillRect(Math.min(this.draggingInit.x, this.draggingEnd.x), Math.min(this.draggingInit.y, this.draggingEnd.y), Math.abs(this.draggingEnd.x - this.draggingInit.x), Math.abs(this.draggingEnd.y - this.draggingInit.y));
        }
        g.setFont(smallFont);
        g.setColor(Color.red);
        if (this.bestIndividual != null) {
            g.drawString("Mejor individuo: " + this.bestIndividual.toString() + " [" + this.motor.getNonScaledFitness(this.bestIndividual) + "]", 0, 12);
            g.drawString("Iteracion N\u00ba:    " + this.motor.getTotIteraciones(), 0, 24);
        }
        if (this.isDeJong) {
            g.drawString("Perf. Off Line:  " + ((GeneracionSimpleDeJong)this.motor.getGeneracion()).getOffLinePerformance(), 0, 36);
            g.drawString("Perf. On Line :  " + ((GeneracionSimpleDeJong)this.motor.getGeneracion()).getOnLinePerformance(), 0, 48);
        }
        double width = this.getWidth() - 50;
        double height = this.getHeight() - 50;
        double pixelSizeX = width / (this.rangeDer - this.rangeIzq);
        double pixelSizeY = height / (this.rangeTop - this.rangeBottom);
        g.setColor(Color.gray);
        g.setFont(bigFont);
        int lineVert = this.rangeIzq < 0.0 && this.rangeDer > 0.0 ? 0 : (int)(this.rangeDer + this.rangeIzq) / 2;
        g.drawLine((int)(((double)lineVert - this.rangeIzq) * pixelSizeX + 25.0), 0, (int)(((double)lineVert - this.rangeIzq) * pixelSizeX + 25.0), this.getHeight());
        g.drawString("" + lineVert, (int)(((double)lineVert - this.rangeIzq) * pixelSizeX + 30.0), (int)height + 25);
        if (this.rangeIzq == this.rangeDer) {
            g.drawString("Poblacion contenida en x = " + this.rangeIzq, 0, (int)(height / 2.0) - 40);
        }
        int lineHoriz = 0;
        lineHoriz = this.rangeBottom < 0.0 && this.rangeTop > 0.0 ? 0 : (int)(this.rangeTop + this.rangeBottom) / 2;
        if (this.rangeBottom == this.rangeTop) {
            g.drawString("Poblacion contenida en y = " + this.rangeTop, 0, (int)(height / 2.0) - 20);
        }
        g.drawLine(0, (int)((this.rangeBottom - (double)lineHoriz) * pixelSizeY + height + 25.0), this.getWidth(), (int)((this.rangeBottom - (double)lineHoriz) * pixelSizeY + height + 25.0));
        g.drawString("" + lineHoriz, 5, (int)((this.rangeBottom - (double)lineHoriz) * pixelSizeY + height + 20.0));
        g.setColor(Color.blue);
        Enumeration enumeration = this.currIndividuals.elements();
        while (enumeration.hasMoreElements()) {
            IIndividuo individuo = (IIndividuo)enumeration.nextElement();
            double x = this.getXValue(individuo);
            double y = this.motor.getNonScaledFitness(individuo);
            g.drawRect((int)((x - this.rangeIzq) * pixelSizeX + 25.0), (int)((this.rangeBottom - y) * pixelSizeY + height + 25.0), (int)pixelWidth, (int)pixelHeight);
        }
        this.paintFixAxis(g);
    }

    private void paintFixAxis(Graphics g) {
        int x = 0;
        int y = this.getHeight() - checkSize - 3;
        g.setColor(checkColor);
        g.drawRect(x, y, checkSize, checkSize);
        if (this.fixAxis) {
            g.drawLine(x, y, x + checkSize, y + checkSize);
            g.drawLine(x, y + checkSize, x + checkSize, y);
        }
        g.drawString("Fijar grilla", x + checkSize + 2, y + 11);
    }

    public void inicioIteracion() {
        if (!this.running) {
            return;
        }
        this.showMsg("Inicio iteracion...");
    }

    private double getXValue(IIndividuo individuo) {
        if (individuo instanceof IndividuoMultipleFuncionExpresion) {
            return ((IFuncion)((Object)((IndividuoMultipleFuncionExpresion)individuo).getParameter(this.curVarIndependiente))).value();
        }
        return ((IFuncion)((Object)individuo)).value();
    }

    public void setCurVarIndependiente(int curVarIndependiente) {
        if (curVarIndependiente < 0) {
            return;
        }
        if (this.curVarIndependiente != curVarIndependiente) {
            this.curVarIndependiente = curVarIndependiente;
            this.procesoIteracion();
        } else {
            this.curVarIndependiente = curVarIndependiente;
        }
        this.repaint();
    }

    public void finIteracion() {
        if (this.running) {
            this.procesoIteracion();
        }
    }

    public void procesoIteracion() {
        if (this.motor == null) {
            return;
        }
        this.bestIndividual = this.motor.getBestIndividuo();
        this.showMsg("Fin iteracion...");
        if (!this.fixAxis) {
            this.rangeTop = -1.7976931348623157E308;
            this.rangeDer = -1.7976931348623157E308;
            this.rangeBottom = Double.MAX_VALUE;
            this.rangeIzq = Double.MAX_VALUE;
        }
        this.currIndividuals.removeAllElements();
        Enumeration enumeration = this.motor.getPoblacion().elements();
        while (enumeration.hasMoreElements()) {
            IIndividuo individuo = (IIndividuo)enumeration.nextElement();
            if (!this.fixAxis) {
                double x = this.getXValue(individuo);
                double y = this.motor.getNonScaledFitness(individuo);
                if (x < this.rangeIzq) {
                    this.rangeIzq = x;
                }
                if (x > this.rangeDer) {
                    this.rangeDer = x;
                }
                if (y < this.rangeBottom) {
                    this.rangeBottom = y;
                }
                if (y > this.rangeTop) {
                    this.rangeTop = y;
                }
            }
            this.currIndividuals.addElement(individuo);
        }
        this.paint(super.getGraphics());
    }

    public void finAlgoritmo() {
        if (!this.running) {
            return;
        }
    }

    public void reset() {
        this.running = false;
        this.repaint();
    }

    protected void processDrag() {
        double[] b;
        double[] a = this.getPoint(this.draggingInit);
        this.rangeIzq = a[0] < (b = this.getPoint(this.draggingEnd))[0] ? a[0] : b[0];
        this.rangeDer = a[0] > b[0] ? a[0] : b[0];
        this.rangeBottom = a[1] < b[1] ? a[1] : b[1];
        this.rangeTop = a[1] > b[1] ? a[1] : b[1];
        this.repaint();
    }

    private double[] getPoint(Point scrPoint) {
        double width = this.getWidth() - 50;
        double height = this.getHeight() - 50;
        double posX = ((width - (double)scrPoint.x + 25.0) * this.rangeIzq + (double)(scrPoint.x - 25) * this.rangeDer) / width;
        double posY = ((height - (double)scrPoint.y + 25.0) * this.rangeTop + (double)(scrPoint.y - 25) * this.rangeBottom) / height;
        return new double[]{posX, posY};
    }

    private int calcDistance(Point a, Point b) {
        return (int)Math.sqrt(Math.pow(a.x - b.x, 2.0) + Math.pow(a.y - b.y, 2.0));
    }

    public void componentHidden(ComponentEvent evt) {
    }

    public void componentShown(ComponentEvent evt) {
    }

    public void componentMoved(ComponentEvent evt) {
    }

    public void componentResized(ComponentEvent evt) {
        this.screenWidth = super.getSize().width;
        this.screenHeight = super.getSize().height;
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        this.draggingInit = evt.getPoint();
        boolean bl = this.isZoomIn = (evt.getModifiers() & 0x10) != 0;
        if (!this.isZoomIn) {
            this.statusBar.showMsg("Aplicando Zoom Out");
            double zoomWidth = (this.rangeDer - this.rangeIzq) / 3.0;
            double zoomHeight = (this.rangeTop - this.rangeBottom) / 3.0;
            this.rangeIzq -= zoomWidth;
            this.rangeDer += zoomWidth;
            this.rangeTop += zoomHeight;
            this.rangeBottom -= zoomHeight;
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent evt) {
        if (this.dragging) {
            this.isZoomIn = false;
            this.dragging = false;
            this.processDrag();
        }
    }

    public void mouseClicked(MouseEvent evt) {
        if (evt.getX() <= checkSize && evt.getY() > this.getHeight() - 2 * checkSize) {
            this.fixAxis = !this.fixAxis;
            this.repaint();
            if (this.fixAxis) {
                this.showMsg("Se ha dejado la Grilla fija");
            } else {
                this.showMsg("Se ha dejado la Grilla m\u00f3vil");
            }
            return;
        }
        if ((evt.getModifiers() & 0x10) != 0) {
            pixelWidth %= 5.0;
            pixelWidth += 1.0;
            pixelHeight %= 5.0;
            pixelHeight += 1.0;
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent evt) {
        if (this.motor == null) {
            return;
        }
        this.mouseLocation = evt.getPoint();
        double width = this.getWidth() - 50;
        double height = this.getHeight() - 50;
        double posX = ((width - (double)this.mouseLocation.x + 25.0) * this.rangeIzq + (double)(this.mouseLocation.x - 25) * this.rangeDer) / width;
        double posY = ((height - (double)this.mouseLocation.y + 25.0) * this.rangeTop + (double)(this.mouseLocation.y - 25) * this.rangeBottom) / height;
        this.statusBar.showMsg("Mouse: " + posX + " , " + posY);
    }

    public void mouseDragged(MouseEvent evt) {
        if (!this.isZoomIn || this.calcDistance(evt.getPoint(), this.draggingInit) < 10) {
            return;
        }
        this.dragging = true;
        Point lastDraggingEnd = this.draggingEnd;
        this.draggingEnd = evt.getPoint();
        this.repaint(Math.min(Math.min(this.draggingInit.x, this.draggingEnd.x), lastDraggingEnd.x) - 5, Math.min(Math.min(this.draggingInit.y, this.draggingEnd.y), lastDraggingEnd.y) - 5, Math.max(Math.abs(this.draggingEnd.x - this.draggingInit.x), Math.abs(lastDraggingEnd.x - this.draggingInit.x)) + 10, Math.max(Math.abs(this.draggingEnd.y - this.draggingInit.y), Math.abs(lastDraggingEnd.y - this.draggingInit.y)) + 10);
        this.statusBar.showMsg("Aplicar Zoom In: (" + this.draggingInit.x + ", " + this.draggingInit.y + ") - (" + this.draggingEnd.x + ", " + this.draggingEnd.y + ")");
    }
}

