/*
 * Decompiled with CFR 0.152.
 */
package com.brownsoft.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ParseINI {
    private static final int MAX_LINE_LENGTH = 255;
    private static final byte SECTION_SEPARATOR_CHAR = 38;
    private static final String SECTION_SEPARATOR = "&";
    private static final String GENERAL = "&General&";
    private String entryName;
    private DataInputStream inputStream;
    private Hashtable sections = new Hashtable();
    private Hashtable sectionEntries;
    private Hashtable general;
    private Hashtable aliased = new Hashtable();
    private Hashtable alias = new Hashtable();
    private boolean need2Save = false;
    private boolean autoSave = true;
    private String filename = null;
    byte[] tempBytes = new byte[255];

    public ParseINI() {
        this.general = new Hashtable();
        this.filename = null;
    }

    public ParseINI(String filename) throws IOException {
        this.filename = new File(filename).getAbsolutePath();
        try {
            FileInputStream inputStream = new FileInputStream(filename);
            this.load(inputStream);
            inputStream.close();
        }
        catch (FileNotFoundException fnfe) {
            new FileWriter(filename).close();
            this.general = new Hashtable();
        }
    }

    public ParseINI(InputStream inputStream) throws IOException {
        this.load(inputStream);
    }

    public ParseINI(byte[] inBytes) throws IOException {
        this.load(new ByteArrayInputStream(inBytes));
    }

    public ParseINI(ZipFile zipFile, ZipEntry entry) throws IOException {
        if (entry == null) {
            return;
        }
        DataInputStream in = new DataInputStream(zipFile.getInputStream(entry));
        byte[] tempBytes = new byte[(int)entry.getSize()];
        in.readFully(tempBytes);
        this.load(new ByteArrayInputStream(tempBytes));
    }

    public boolean need2Save() {
        return this.need2Save;
    }

    public void finalize() {
        block2: {
            if (!this.autoSave || !this.need2Save) break block2;
            try {
                this.save();
            }
            catch (IOException e) {
                System.out.println("ParseINI (" + this.filename + "):" + e);
            }
        }
    }

    public Enumeration sectionElements() {
        return this.sections.elements();
    }

    public Enumeration sectionNames() {
        return this.sections.keys();
    }

    public Hashtable getSection(String section) {
        if (this.sections.containsKey(section)) {
            return (Hashtable)((Hashtable)this.sections.get(section)).clone();
        }
        return null;
    }

    public boolean sectionExists(String section) {
        return this.sections.containsKey(section);
    }

    public void removeSection(String section) {
        this.need2Save |= this.sections.remove(section) != null;
    }

    public void removeProperty(String section, String prop) {
        if (this.sections.containsKey(section)) {
            this.need2Save |= ((Hashtable)this.sections.get(section)).remove(prop) != null;
        }
    }

    public void removeGeneralProperty(String prop) {
        this.need2Save |= this.general.remove(prop) != null;
    }

    public String getGeneralProperty(String prop) {
        return this.getProperty(this.general, prop, null);
    }

    public String getGeneralProperty(String prop, String defecto) {
        return this.getProperty(this.general, prop, defecto);
    }

    public void setGeneralProperty(String prop, String value) {
        this.need2Save |= !value.equals(this.general.put(prop, value));
    }

    public boolean setupGeneralProperty(String prop, String value) {
        if (this.general.containsKey(prop)) {
            return false;
        }
        this.setGeneralProperty(prop, value);
        return true;
    }

    public void setProperty(String section, String prop, String value) {
        if (!this.sections.containsKey(section)) {
            this.sections.put(section, new Hashtable());
        }
        this.need2Save |= !value.equals(((Hashtable)this.sections.get(section)).put(prop, value));
    }

    public String getProperty(String section, String prop) {
        return this.getProperty((Hashtable)this.sections.get(section), prop, null);
    }

    public String getProperty(String section, String prop, String defecto) {
        return this.getProperty((Hashtable)this.sections.get(section), prop, defecto);
    }

    private String getProperty(Hashtable section, String prop, String defecto) {
        if (section != null && section.containsKey(prop)) {
            return (String)section.get(prop);
        }
        if (section != null && this.alias.containsKey(prop)) {
            return this.getProperty(section, (String)this.alias.get(prop), defecto);
        }
        return defecto;
    }

    public boolean addItemToProperty(String section, String prop, String item, String separator) {
        Vector tempVector = ParseINI.parseLine(this.getProperty(section, prop), separator);
        if (tempVector.contains(item)) {
            return false;
        }
        tempVector.addElement(item);
        String temp = "";
        Enumeration enumeration = tempVector.elements();
        while (enumeration.hasMoreElements()) {
            temp = temp + (String)enumeration.nextElement() + separator;
        }
        this.setProperty(section, prop, temp);
        return true;
    }

    public boolean addItemToGeneralProperty(String prop, String item, String separator) {
        Vector tempVector = ParseINI.parseLine(this.getGeneralProperty(prop), separator);
        if (tempVector.contains(item)) {
            return false;
        }
        tempVector.addElement(item);
        String temp = "";
        Enumeration enumeration = tempVector.elements();
        while (enumeration.hasMoreElements()) {
            temp = temp + (String)enumeration.nextElement() + separator;
        }
        this.setGeneralProperty(prop, temp);
        return true;
    }

    public boolean removeItemFromProperty(String section, String prop, String item, String separator) {
        Vector tempVector = ParseINI.parseLine(this.getProperty(section, prop), separator);
        if (!tempVector.contains(item)) {
            return false;
        }
        tempVector.removeElement(item);
        String temp = "";
        Enumeration enumeration = tempVector.elements();
        while (enumeration.hasMoreElements()) {
            temp = temp + (String)enumeration.nextElement() + separator;
        }
        if (temp.equals("")) {
            this.removeProperty(section, prop);
        } else {
            this.setProperty(section, prop, temp);
        }
        return true;
    }

    public boolean removeItemFromGeneralProperty(String prop, String item, String separator) {
        Vector tempVector = ParseINI.parseLine(this.getGeneralProperty(prop), separator);
        if (!tempVector.contains(item)) {
            return false;
        }
        tempVector.removeElement(item);
        String temp = "";
        Enumeration enumeration = tempVector.elements();
        while (enumeration.hasMoreElements()) {
            temp = temp + (String)enumeration.nextElement() + separator;
        }
        if (temp.equals("")) {
            this.removeGeneralProperty(prop);
        } else {
            this.setGeneralProperty(prop, temp);
        }
        return true;
    }

    public boolean setAlias(String alias, String original) {
        if (!this.sections.containsKey(original)) {
            return false;
        }
        this.aliased.put(original, alias);
        this.alias.put(alias, original);
        return true;
    }

    public boolean renameSection(String nuevo, String original) {
        if (!this.sections.containsKey(original) || this.sections.containsKey(nuevo)) {
            return false;
        }
        if (!original.equals(nuevo)) {
            this.sections.put(nuevo, (Hashtable)this.sections.get(original));
            this.sections.remove(original);
            this.need2Save = true;
        }
        return true;
    }

    public boolean isAliased(String original) {
        return this.aliased.containsKey(original);
    }

    public String getAlias(String original) {
        if (this.isAliased(original)) {
            return (String)this.aliased.get(original);
        }
        return original;
    }

    public void load(InputStream iStream) throws IOException {
        this.inputStream = new DataInputStream(iStream);
        this.sectionEntries = new Hashtable();
        this.sections.put(GENERAL, this.sectionEntries);
        try {
            while ((this.entryName = this.readEntryName()) != null) {
                this.sectionEntries.put(this.entryName, this.readEntry());
            }
        }
        catch (EOFException e) {
            // empty catch block
        }
        this.general = (Hashtable)this.sections.get(GENERAL);
        this.sections.remove(GENERAL);
    }

    public void save() throws IOException {
        if (this.need2Save && this.filename != null) {
            this.save(new FileOutputStream(this.filename));
        }
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public boolean serializeSection(String section, OutputStream out, boolean sendGeneral) throws IOException {
        if (!this.sections.containsKey(section)) {
            return false;
        }
        ObjectOutputStream serialOut = new ObjectOutputStream(out);
        serialOut.writeObject(section);
        out.flush();
        serialOut.writeObject(this.sections.get(section));
        out.flush();
        serialOut.writeObject(new Boolean(sendGeneral));
        out.flush();
        if (sendGeneral) {
            serialOut.writeObject(this.general);
        }
        out.flush();
        return true;
    }

    public String unserializeSection(InputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream serialIn = new ObjectInputStream(in);
        String section = (String)serialIn.readObject();
        Hashtable loadedSection = (Hashtable)serialIn.readObject();
        if (!this.sections.containsKey(section) || !((Hashtable)this.sections.get(section)).equals(loadedSection)) {
            this.sections.put(section, loadedSection);
            this.need2Save = true;
        }
        if (((Boolean)serialIn.readObject()).booleanValue()) {
            this.general = (Hashtable)serialIn.readObject();
        }
        return section;
    }

    public void save(OutputStream oStream) throws IOException {
        int it;
        String value;
        String prop;
        Enumeration props;
        DataOutputStream outputStream = new DataOutputStream(oStream);
        if (this.general != null) {
            props = this.general.keys();
            while (props.hasMoreElements()) {
                prop = (String)props.nextElement();
                value = this.getGeneralProperty(prop);
                if (value.equals("")) continue;
                it = value.length() + prop.length() + 4 > 255 ? 255 - prop.length() - 4 : value.length();
                outputStream.writeBytes(prop + "= " + value.substring(0, it) + "\r\n");
                while (value.length() - it > 251) {
                    outputStream.writeBytes(" " + value.substring(it, it + 255) + "\r\n");
                    it += 255;
                }
                if (it >= value.length()) continue;
                outputStream.writeBytes(" " + value.substring(it) + "\r\n");
            }
        }
        Enumeration secs = this.sectionNames();
        while (secs.hasMoreElements()) {
            String section = (String)secs.nextElement();
            outputStream.writeBytes("\r\n[" + section + "]\r\n");
            props = ((Hashtable)this.sections.get(section)).keys();
            while (props.hasMoreElements()) {
                prop = (String)props.nextElement();
                value = this.getProperty(section, prop);
                if (value.equals("")) continue;
                it = value.length() + prop.length() + 4 > 255 ? 255 - prop.length() - 4 : value.length();
                outputStream.writeBytes(prop + "= " + value.substring(0, it) + "\r\n");
                while (value.length() - it > 251) {
                    outputStream.writeBytes(" " + value.substring(it, it + 255) + "\r\n");
                    it += 255;
                }
                if (it >= value.length()) continue;
                outputStream.writeBytes(" " + value.substring(it) + "\r\n");
            }
        }
        outputStream.close();
        this.need2Save = false;
    }

    private String readEntryName() throws IOException {
        int offset = 0;
        block6: while (true) {
            byte car = this.inputStream.readByte();
            switch ((char)car) {
                case '%': 
                case '*': {
                    do {
                        if ((car = this.inputStream.readByte()) == 10) continue block6;
                    } while (car != 13);
                    break;
                }
                case ' ': {
                    if (this.entryName == null) {
                        throw new IOException("Invalid entry");
                    }
                    this.sectionEntries.put(this.entryName, (String)this.sectionEntries.get(this.entryName) + this.readEntry());
                    return this.readEntryName();
                }
                case '[': {
                    this.sectionEntries = new Hashtable();
                    String sectionName = this.readEntry();
                    sectionName = sectionName.substring(0, sectionName.length() - 1);
                    this.sections.put(sectionName, this.sectionEntries);
                    this.entryName = null;
                    return this.readEntryName();
                }
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    this.tempBytes[offset++] = car;
                    while ((car = this.inputStream.readByte()) != 58 && car != 61) {
                        this.tempBytes[offset++] = car;
                    }
                    if (offset == 4 && this.tempBytes[0] == 78 && this.tempBytes[1] == 97 && this.tempBytes[2] == 109 && this.tempBytes[3] == 101) {
                        this.sectionEntries = new Hashtable();
                        String section = this.readEntry();
                        if (section.startsWith("./")) {
                            section = section.substring(2);
                        }
                        this.sections.put(section, this.sectionEntries);
                        this.entryName = null;
                        return this.readEntryName();
                    }
                    return new String(this.tempBytes, 0, offset);
                }
            }
        }
    }

    private String readEntry() throws IOException {
        byte car;
        byte[] b = new byte[255];
        int offset = 0;
        while (Character.isWhitespace((char)(car = this.inputStream.readByte()))) {
        }
        b[offset++] = car;
        try {
            while ((car = this.inputStream.readByte()) != 0 && car != 10 && car != 13) {
                b[offset++] = car;
            }
        }
        catch (EOFException e) {
            // empty catch block
        }
        return new String(b, 0, offset);
    }

    public static String removeExtraSpaces(String line) {
        if (line == null) {
            return null;
        }
        int lineLength = line.length();
        char[] b = new char[lineLength];
        if (lineLength == 0) {
            return line;
        }
        int index = 0;
        while (index < lineLength) {
            if (line.charAt(index) != ' ') break;
            ++index;
        }
        int offset = 0;
        while (index < lineLength - 1) {
            if (line.charAt(index) != ' ' || line.charAt(index + 1) != ' ') {
                b[offset++] = line.charAt(index);
            }
            ++index;
        }
        b[offset++] = line.charAt(index);
        return new String(b, 0, offset);
    }

    public static Vector parseLine(String line, String separator) {
        int indexComillas;
        Vector<String> partes = new Vector<String>();
        int index = 0;
        int offset = 0;
        boolean startingComillas = true;
        if (line == null) {
            return partes;
        }
        if (!line.endsWith(separator)) {
            line = line + separator;
        }
        if ((indexComillas = line.indexOf(34)) == -1) {
            indexComillas = Integer.MAX_VALUE;
        }
        while ((index = line.indexOf(separator, startingComillas ? offset : indexComillas)) != -1) {
            if (index > indexComillas) {
                indexComillas = line.indexOf(34, index);
                if (indexComillas == -1) {
                    indexComillas = Integer.MAX_VALUE;
                }
                if (startingComillas) {
                    startingComillas = false;
                    ++offset;
                    if (indexComillas != Integer.MAX_VALUE) continue;
                    break;
                }
                startingComillas = true;
                --index;
            }
            partes.addElement(line.substring(offset, index));
            offset = index;
            while (line.startsWith(separator, ++offset) && offset < line.length()) {
            }
        }
        if (!startingComillas) {
            partes.addElement(line.substring(line.length() - separator.length()));
        }
        return partes;
    }
}

