package com.brownsoft.ag;

/**
 * Esta interfaz debe ser implementada por las clases que deseen crear nuevos
 * tipos de genotipo aparte de los implementados por esta biblioteca
 * @author Gustavo Brown
 * @version 1.0
 */
public interface IIndividuo extends Cloneable
{
   /** Crea una copia con el mismo material gentico que este individuo
    * @return Nuevo individuo
    */
   public IIndividuo getCopy();

   /** Setea el material gentico de este individuo al azar
    */
   public void setRandom();

   /** Obtiene el material genetico de este individuo
    * @return Object con el material gentico del individuo
    */
   public Object getValue();

   /** Setea el material gentico de este individuo
    * @param value Object con el material gentico de este individuo
    */
   public void setValue(Object value);

   /** Obtiene el fitness de este individuo
    */
   public double getFitness();

   /** Obtiene el fenotipo de este individuo
    */
   public Object getFenotipo();

   /** Setea los padres de este individuo
    * @param parents padres de este individuo
    */
   public void setParents(IIndividuo[] parents);

   /** Obtiene los padres de este individuo
    * @return padres de este individuo
    */
   public IIndividuo[] getParents();
}
