package com.brownsoft.ag;

/** Esta interfaz debe ser implementada por las clases que quieran recibir eventos
 * del Motor (inicioIteracion, finIteracion y finAlgoritmo)
 * Para registrar un listener se debe llamar al metodo motor.addListener(IMotorListener)
 * @see MotorAG.addListener
 * @author Gustavo Brown
 * @version 1.0
 */
public interface IMotorListener
{
   /** Avisa que se inicia una nueva iteracin
    */
   public void inicioIteracion();

   /** Avisa que finalizo la iteracin
    */
   public void finIteracion();

   /** Avisa que finaliz la ejecucin del algoritmo
    */
   public void finAlgoritmo();
}
