package com.brownsoft.ag;

import java.util.Random;

/**
 * Esta clase provee servicios para acceder a nmeros pseudoaleatrios (booleanos,
 * enteros, floats, valores de 0 a 1, etc)
 * @author Gustavo Brown
 * @version 1.0
 */
public class PRNG
{
   private static Random PRNG = new Random();

   /** Setea el PRNG
    */
   public static void setPRNG(Random randomNumberGenerator)
   {
      PRNG = randomNumberGenerator;
   }

   public static int nextInt()
   {
      return Math.abs(PRNG.nextInt());
   }

   public static int nextInt(int maxValue)
   {
      return Math.abs(PRNG.nextInt()) % maxValue;
   }

   public static long nextLong()
   {
      return Math.abs(PRNG.nextLong());
   }

   public static long nextLong(long maxValue)
   {
      return Math.abs(PRNG.nextLong()) % maxValue;
   }

   public static boolean nextBoolean()
   {
      return (PRNG.nextInt() % 1) == 0;
   }

   public static double nextProbability()
   {
      double temp = Math.abs(PRNG.nextDouble());
      return temp - Math.floor(temp);
   }
}
