package com.brownsoft.ag.individuo;

import com.brownsoft.ag.IIndividuo;

/** Esta clase implementa un individuo del tipo funcion de punto fijo
 * de una sola variable que evalua una funncion pasada en el constructor.
 * @author Gustavo Brown
 * @version 1.0
 */
public class FuncionExpresion extends FuncionPuntoFijo
{
   private boolean isPartOfComplexIndividual = false; // Indica si se es parte de un individuo de varias variables
   private int parentIndex = -1;
   private IndividuoMultipleFuncionExpresion complexParent;
   private EvaluaExpresion eval;

   /** Constructor
    * @param from limite izquierdo del dominio de la funcion (inclusive)
    * @param to limite derecho del dominio de la funcion (inclusive)
    * @param bitWidth cantidad de bits en la representacion del individuo. Los
    * distintos puntos del espacio de bsqueda estan igualmente distanciados
    * @note: Este constructor considera x como el nombre de la variable
    */
   public FuncionExpresion(String expresion, double from, double to, int bitWidth)
   {
      this(expresion, from, to, bitWidth, "x");
   }

   /** Constructor
    * @param from limite izquierdo del dominio de la funcion (inclusive)
    * @param to limite derecho del dominio de la funcion (inclusive)
    * @param bitWidth cantidad de bits en la representacion del individuo. Los
    * distintos puntos del espacio de bsqueda estan igualmente distanciados
    * @param varName nombre de la variable de la funcin
    */
   public FuncionExpresion(String expresion, double from, double to, int bitWidth, String varName)
   {
      super(from, to, bitWidth, varName);
      eval = new EvaluaExpresion(expresion);
   }

   /** Evalua y retorna el fitness de este individuo
    * @return  retorna el fitness de este individuo
    */
   public double getFitness()
   {
      if (isPartOfComplexIndividual)
      { // Si esta es una de las variables de un individuo de varias variables
         return complexParent.getFitness();
      }
      else
      { // Si se trata de un individuo de 1 sola variable
         return eval.getFitness(this);
      }
   }

   /** Obtiene el evaluador de la expresion de este individuo
    * @return EvaluaExpresion evaluador de la expresion de este individuo
    */
   public EvaluaExpresion getEvaluator()
   {
      return eval;
   }

   /** Indica que este individuo es una de las variables de una funcion de varias variables
    *  Esta funcion es llamada por el constructor de IndividuoMultipleFuncionExpresion para cada una de
    *  las variables que componen a la funcion compleja
    *  @param complexParent el IndividuoMultipleFuncionExpresion del cual es parte este individuo
    */
   protected void setIsPartOfComplexIndividual(int parentIndex, IndividuoMultipleFuncionExpresion complexParent)
   {
      isPartOfComplexIndividual = true;
      this.complexParent = complexParent;
      this.parentIndex = parentIndex;
   }

   /** Crea una copia con el mismo material gentico que este individuo
    * @return Nuevo individuo
    */
   public IIndividuo getCopy()
   {
      FuncionExpresion individuo = (FuncionExpresion)super.getCopy();
      if (isPartOfComplexIndividual)
      { // Si es parte de un ComplexIndividual, tenemos que recrear al parent
         individuo.complexParent = complexParent.doClone();
         individuo.complexParent.setParameter(parentIndex, individuo);
      }
      return individuo;
   }

}
