package com.brownsoft.ag;

/**
 * Esta es la interfaz que deben implementar las clases que quieran ser utilizadas
 * como operador de mutacin
 * @author Gustavo Brown
 * @version 1.0
 */
public interface IMutacion extends IMotorListener
{
   /** Inicializa el operador de mutacion
    * @param motor MotorAG asociado
    * @param pMutacion probabilidad de mutacion
    */
   public void inicializar(MotorAG motor, double pMutacion);

   /** Muta un individuo
    * @param individuo a mutar
    */
   public IIndividuo mutar(IIndividuo individuo) throws InvalidMutationException;
}
