package com.brownsoft.ag;

import java.io.*;

/** Clase base de las excepciones del Motor
 * @author Gustavo Brown
 * @version 1.0
 */
public class MotorException extends Exception
{
   private Exception containedException;

   /** Excepcion simple, contiene el mensaje de error
    */
   public MotorException(String msg)
   {
      this(msg, null);
   }

   /** Excepcion contenida: contiene la excepcin real que ocurri
    */
   public MotorException(String msg, Exception containedException)
   {
      super(msg);
      this.containedException = containedException;
   }

   public Exception getContainedException()
   {
      return containedException;
   }

   public void printStackTrace()
   {
      super.printStackTrace();

      if (containedException != null)
      {
         System.err.println("ContainedException: ");
         containedException.printStackTrace();
      }
   }

   public void printStackTrace(PrintWriter writer)
   {
      super.printStackTrace(writer);
      if (containedException != null)
      {
         System.err.println("ContainedException: ");
         containedException.printStackTrace(writer);
      }
   }

   public void printStackTrace(PrintStream stream)
   {
      super.printStackTrace(stream);
      if (containedException != null)
      {
         System.err.println("ContainedException: ");
         containedException.printStackTrace(stream);
      }
   }
}
