package com.brownsoft.ag.fitnessScaler;

import com.brownsoft.ag.*;

/** Este scaler realiza la operacion A * x + B donde x es el fitness actual a escalar
 *  Los parametros A y B se indican al momento de instanciacion
 * @author Gustavo Brown
 * @version 1.0
 */

public class FitnessScalerAxB extends FitnessScaler
{
   private double A;
   private double B;

   /** Constructor
    *  @param parent El parent de este fitness scaler (o FitnessScalerSink)
    *  @param A el parametro A. La funcion a realizar sera A * x + B
    *  @param B el parametro B. La funcion a realizar sera A * x + B
    */
   public FitnessScalerAxB(IFitnessScaler parent, double A, double B)
   {
      super(parent);
      this.A = A;
      this.B = B;
   }

   /** Este metodo debe ser definido por las subclases de FitnessScaler
    *  @return fitness escalado A * x + B, donde x es el fitness actual en la cadena
    */
   protected double scaleFitness(double fitness)
   {
      return fitness * A + B;
   }

}