package com.brownsoft.ag.mutacion;

import com.brownsoft.ag.*;
import com.brownsoft.ag.individuo.*;

/**
 * Implementacion simple del operador de mutacin
 * Va recorriendo el material genetico del individuo (que tiene que ser de tipo
 * bitstream) y para cada bit, tira un numero numero entre 0 y 1 al azar y si
 * pMut es mayor entonces aplica un bit-flip a dicho bit
 * @author Gustavo Brown
 * @version 1.0
 */
public class MutacionBitFlip implements IMutacion
{
   private double pMutacion;
   private MotorAG motor;

   /** Inicializa el operador de mutacion
    * @param motor MotorAG asociado
    * @param pMutacion probabilidad de mutacion
    */
   public void inicializar(MotorAG motor, double pMutacion)
   {
      this.motor = motor;
      this.pMutacion = pMutacion;
   }

   /** Muta un individuo
    * @param individuo a mutar
    */
   public IIndividuo mutar(IIndividuo individuo) throws InvalidMutationException
   {
      if (individuo instanceof IndividuoBitStreamSimple)
      {
         long chromosoma = ( (Long) individuo.getValue()).longValue();
         int bitWidth = ( (IndividuoBitStreamSimple) individuo).getBitWidth();

         long bitValue = 1;
         for (int i = 0; i < bitWidth; i++)
         {
            if (PRNG.nextProbability() < pMutacion)
            {
               chromosoma ^= bitValue;
            }
            bitValue <<= 1;
         }
         individuo.setValue(new Long(chromosoma));
         return individuo;
      }
      throw new InvalidMutationException("El Individuo no es del tipo IndividuoBitStream [tipo=" + individuo.getClass() + "]");
   }

   /** Indica que se inica la iteracion
    */
   public void inicioIteracion()
   {
      ;
   }

   /** Indica que se finaliza la iteracion
    */
   public void finIteracion()
   {
      ;
   }

   /** Avisa que finaliz la ejecucin del algoritmo
    */
   public void finAlgoritmo()
   {
      ;
   }
}
