package com.brownsoft.ag.mutacion;

import com.brownsoft.ag.*;
import com.brownsoft.ag.individuo.*;

/** Aplico un algoritmo de random-hill-climbing a un individuo
 * Es decir, voy eligiendo bits al azar y les hago un flip y veo si
 * el fitness que obtengo es mayor, en cuyo caso me voy quedando con el
 * nuevo genotipo. Hago esto hasta N veces
 * @author Gustavo Brown
 * @version 1.0
 */
public class MutacionHillClimber implements IMutacion
{
   private double pMutacion;
   private MotorAG motor;
   protected int N;

   /** Constructor
    * @param N cantidad de veces que se realizan bit-flips
    */
   public MutacionHillClimber(int N) throws InvalidMutationException
   {
      if (N < 0)
      {
         throw new InvalidMutationException("El operador MutacionHillClimber debe recibir un cantidad no negativa de iteraciones por mutacin (N=" + N + ")");
      }
      this.N = N;
   }

   /** Inicializa el operador de mutacion
    * @param motor MotorAG asociado
    * @param pMutacion probabilidad de mutacion
    */
   public void inicializar(MotorAG motor, double pMutacion)
   {
      this.motor = motor;
      this.pMutacion = pMutacion;
   }

   /** Muta un individuo
    * @param individuo a mutar
    */
   public IIndividuo mutar(IIndividuo individuo) throws InvalidMutationException
   {
      // Tiro un nmero al azar y veo si debo mutar a este individuo
      if (pMutacion < PRNG.nextProbability())
      {
         return individuo;
      }

      // Ok, si debo mutar chequeo que el individuo sea compatible
      if (individuo instanceof IndividuoBitStreamSimple)
      {
         long currentChromosoma = ( (Long) individuo.getValue()).longValue();
         double currentFitness = motor.getFitness(individuo);
         int bitWidth = ( (IndividuoBitStreamSimple) individuo).getBitWidth();
         IIndividuo newIndividuo = individuo.getCopy();
         for (int i = 0; i < N; i++)
         {
            long newChromosoma = currentChromosoma ^ ( (long) 1 << PRNG.nextInt(bitWidth));
            newIndividuo.setValue(new Long(newChromosoma));
            double newFitness = motor.getFitness(newIndividuo);
            if (newFitness > currentFitness)
            {
               currentFitness = newFitness;
               currentChromosoma = newChromosoma;
            }
         }
         newIndividuo.setValue(new Long(currentChromosoma));
         return newIndividuo;
      }
      throw new InvalidMutationException("El Individuo no es del tipo IndividuoBitStream [tipo=" + individuo.getClass() + "]");
   }

   /** Indica que se inica la iteracion
    */
   public void inicioIteracion()
   {
      ;
   }

   /** Indica que se finaliza la iteracion
    */
   public void finIteracion()
   {
      ;
   }

   /** Avisa que finaliz la ejecucin del algoritmo
    */
   public void finAlgoritmo()
   {
      ;
   }
}
