package com.brownsoft.ejemplos;

import com.brownsoft.ag.*;
import com.brownsoft.ag.individuo.*;
import com.brownsoft.ag.seleccion.*;
import com.brownsoft.ag.cruzamiento.*;
import com.brownsoft.ag.mutacion.*;
import java.util.*;

public class Test
{
   public static void main(String[] args)
   {
      try
      {
         System.err.println("Algoritmos Geneticos");
         IIndividuo individuo = new FuncionPuntoFijo( -9.5, 9.5, 30, "x")
         {
            public double getFitness()
            {
               return Math.pow(value(), 2);
            }
         };

         IIndividuo individuo2 = new FuncionPuntoFijo( -50.0001, 50.0001, 63, "y")
         {
            public double getFitness()
            {
               return Math.pow(value(), 2);
            }
         };

         IGeneracion generacion = new GeneracionSimpleDeJong(individuo, 50, .85, .05);
         ISeleccion seleccion = new SeleccionElitista(new SeleccionEstocasticaUniversal());
         ICruzamiento cruzamiento = new CruzamientoSPX();
         IMutacion mutacion = new MutacionBitFlip();
         IMutacion mutacion2 = new MutacionHillClimber(20);

         IIndividuo individuoMultiple = new IndividuoMultiple(new IIndividuo[]
             {individuo, individuo2})
         {
            /* Quiero maximizar la funcion x^2 + y^2 */
            public double getFitness()
            {
               return getParameter(0).getFitness() + getParameter(1).getFitness();
            }

            public Object getFenotipo()
            {
               return null;
            }
         };
         IGeneracion generacionMultiple = new GeneracionSimpleDeJong(individuoMultiple, 50, .8, .05);
         OperadorMultiple operadorMultiple = new OperadorMultiple(new ICruzamiento[]
             {cruzamiento, new CruzamientoMPX(2)}
             , new IMutacion[]
             {mutacion, mutacion2});
         MotorAG motor = new MotorAG(generacionMultiple, seleccion, operadorMultiple, operadorMultiple);

         Vector poblacion;

         poblacion = motor.getPoblacion();
         System.err.println("Poblacion inicial");
         for (Enumeration enum = poblacion.elements(); enum.hasMoreElements(); )
         {
            System.err.println("Individuo: " + enum.nextElement().toString());
         }

         motor.iterar();

         poblacion = motor.getPoblacion();
         System.err.println("\nPoblacion Final: iteracion " + motor.getTotIteraciones());
         System.err.println("BestIndividuo: " + motor.getBestIndividuo());
         for (Enumeration enum = poblacion.elements(); enum.hasMoreElements(); )
         {
            System.err.println("Individuo: " + enum.nextElement().toString());
         }

         motor.iterar(90);

         poblacion = motor.getPoblacion();
         System.err.println("\nPoblacion Final2: iteracion " + motor.getTotIteraciones());
         System.err.println("BestIndividuo: " + motor.getBestIndividuo());
         for (Enumeration enum = poblacion.elements(); enum.hasMoreElements(); )
         {
            System.err.println("Individuo: " + enum.nextElement().toString());
         }

      }
      catch (Throwable e)
      {
         e.printStackTrace();
      }
   }
}