package com.brownsoft.gui;

import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.io.*;
import java.util.Enumeration;
import java.util.Vector;
import com.brownsoft.util.*;
import com.brownsoft.ag.*;
import com.brownsoft.ag.individuo.*;
import com.brownsoft.ag.cruzamiento.*;
import com.brownsoft.ag.seleccion.*;
import com.brownsoft.ag.mutacion.*;
import com.brownsoft.ag.fitnessScaler.*;

/**
 * Title:        Motor AG
 * Description: Este es el applet de testeo de la biblioteca
 * Copyright:    Copyright (c) 2003
 * Company:
 * @author Gustavo Brown
 * @version 1.0
 */

public class FunctionSolverAppletAWT extends Applet implements IMsgSink, ComponentListener
{
   MotorRunnerThread motorRunnerThread = new MotorRunnerThread();
   MotorAG motor = null;
   int lastListParms = -1;
   int lastListArgs = -1;
   ParseINI props = new ParseINI();
   BorderLayout borderLayout1 = new BorderLayout();
   Label statusBar = new Label();
   Panel panel1 = new Panel();
   BorderLayout borderLayout2 = new BorderLayout();
//    ScrollPane scrollOpciones = new ScrollPane(ScrollPane.SCROLLBARS_NEVER);
   boolean isStandalone = false;
   ScrollPane scrollPanel = new ScrollPane();
   Panel panelOpciones = new Panel();
   BorderLayout borderLayout3 = new BorderLayout();
   Panel panelButtons = new Panel();
   Graph graph = new Graph(this);
   GridLayout gridLayout1 = new GridLayout();
   Button btnAyuda = new Button();
   Button btnPaso = new Button();
   Button btnReset = new Button();
   Button btnCorrer = new Button();
   List listFunciones = new List();
   TextArea textAreaAyuda;
   /**Get a parameter value*/
   public String getParameter(String key, String def)
   {
      return isStandalone ? System.getProperty(key, def) :
          (getParameter(key) != null ? getParameter(key) : def);
   }

   /**Construct the applet*/
   public FunctionSolverAppletAWT()
   {
   }

   /**Initialize the applet*/
   public void init()
   {
      try
      {
         jbInit();
         initialize();
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
   }

   /**Component initialization*/
   private void jbInit() throws Exception
   {
      statusBar.setFont(new java.awt.Font("Dialog", 1, 12));
      statusBar.setForeground(Color.blue);
      statusBar.setText("Resuelve Funciones");
      this.setLayout(borderLayout1);
      panel1.setLayout(borderLayout2);
      panelOpciones.setLayout(borderLayout3);
      panelButtons.setLayout(gridLayout1);
      gridLayout1.setRows(5);
      gridLayout1.setColumns(1);
      btnAyuda.setLabel("Ayuda");
      btnAyuda.setActionCommand("Ayuda");
      btnPaso.setLabel("Paso");
      textAreaAyuda = new TextArea("Ayuda NO disponible. Verifique la existencia del archivo ayuda.txt", 7, 60, TextArea.SCROLLBARS_VERTICAL_ONLY);
      textAreaAyuda.setFont(new Font("Monospaced", Font.PLAIN, 12));

      this.add(textAreaAyuda, BorderLayout.NORTH);
      textAreaAyuda.setEditable(false);
      textAreaAyuda.setVisible(false);

      btnPaso.addActionListener(new java.awt.event.ActionListener()
      {
         public void actionPerformed(ActionEvent e)
         {
            button_actionPerformed(e);
         }
      });
      btnReset.setActionCommand("Reset");
      btnReset.setLabel("Reset");
      btnReset.addActionListener(new java.awt.event.ActionListener()
      {
         public void actionPerformed(ActionEvent e)
         {
            button_actionPerformed(e);
         }
      });
      btnCorrer.setActionCommand("Correr");
      btnCorrer.setLabel("Correr");
      btnCorrer.addActionListener(new java.awt.event.ActionListener()
      {
         public void actionPerformed(ActionEvent e)
         {
            button_actionPerformed(e);
         }
      });
      btnAyuda.addActionListener(new java.awt.event.ActionListener()
      {
         public void actionPerformed(ActionEvent e)
         {
            btnAyuda_actionPerformed(e);
         }
      });
      listFunciones.addItemListener(new java.awt.event.ItemListener()
      {
         public void itemStateChanged(ItemEvent e)
         {
            listFunciones_itemStateChanged(e);
         }
      });
      lblProbMut.setText("Prob. Mut:");
      lblProbMut.setVisible(false);
      editArg3.setText("12");
      comboSel.addItemListener(new java.awt.event.ItemListener()
      {
         public void itemStateChanged(ItemEvent e)
         {
            comboSel_itemStateChanged(e);
         }
      });
      editArg2.setText("12");
      editProbMut.setText("0.05");
      editProbMut.setVisible(false);
      editArg1.setText("12");
      listParms.addItemListener(new java.awt.event.ItemListener()
      {
         public void itemStateChanged(ItemEvent e)
         {
            listParms_itemStateChanged(e);
         }
      });
      lblFuncion.setFont(new java.awt.Font("Dialog", 1, 12));
      lblFuncion.setForeground(Color.blue);
      lblFuncion.setText("Funcion:                      ");
      lblFuncion.setVisible(false);
      editFuncion.setBackground(Color.cyan);
      editFuncion.addActionListener(new ActionListener()
      {
         public void actionPerformed(ActionEvent evt)
         {
            setFuncion();
         }
      });
      editFuncion.setFont(new java.awt.Font("Monospaced", 1, 12));
      editFuncion.setForeground(Color.darkGray);
      editFuncion.setText("****Funcion****");
      editFuncion.setVisible(false);

      editPobInicial.setText("100");
      editPobInicial.setVisible(false);
      editProbCruz.setText("0.8");
      editProbCruz.setVisible(false);
      panelParams.setLayout(gridBagLayout);
      lblArg3.setText("**********");
      lblArg2.setText("**********");
      lblArg1.setText("**********");
      listArgs.addItemListener(new java.awt.event.ItemListener()
      {
         public void itemStateChanged(ItemEvent e)
         {
            listArgs_itemStateChanged(e);
         }
      });
      lblProbCruz.setText("Prob. Cruz:");
      lblProbCruz.setVisible(false);
      lblPobInicial.setText("Pob. Inicial:");
      lblPobInicial.setVisible(false);
      this.add(statusBar, BorderLayout.SOUTH);
      this.add(panel1, BorderLayout.CENTER);
//        panel1.add(scrollOpciones, BorderLayout.SOUTH);
//        scrollOpciones.add(panelOpciones, null);
      panel1.add(panelOpciones, BorderLayout.SOUTH);
      panelOpciones.add(panelButtons, BorderLayout.EAST);
      graphVarSelector.setVisible(false);
      graphVarSelector.addItemListener(new java.awt.event.ItemListener()
      {
         public void itemStateChanged(ItemEvent e)
         {
            setGraphVarSelector();
         }
      });

      panelButtons.add(graphVarSelector, null);
      panelButtons.add(btnAyuda, null);
      panelButtons.add(btnCorrer, null);
      panelButtons.add(btnPaso, null);
      panelButtons.add(btnReset, null);
      panelOpciones.add(listFunciones, BorderLayout.WEST);
      panelOpciones.add(panelParams, BorderLayout.CENTER);
      panelParams.add(listParms, getGridBagConstraints(0, 0, 2, 2, 0.0, 0.0
          , GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
      panelParams.add(comboSel, getGridBagConstraints(0, 2, 2, 1, 0.0, 0.0
          , GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
      panelParams.add(lblArg1, getGridBagConstraints(2, 2, 1, 1, 0.0, 0.0
          , GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
      panelParams.add(lblArg2, getGridBagConstraints(2, 3, 1, 1, 0.0, 0.0
          , GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
      panelParams.add(editArg1, getGridBagConstraints(3, 2, 1, 1, 0.0, 0.0
          , GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
      panelParams.add(editArg2, getGridBagConstraints(3, 3, 1, 1, 0.0, 0.0
          , GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
      panelParams.add(lblArg3, getGridBagConstraints(0, 3, 1, 1, 0.0, 0.0
          , GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
      panelParams.add(listArgs, getGridBagConstraints(2, 0, 2, 2, 0.0, 0.0
          , GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
      panelParams.add(editArg3, getGridBagConstraints(1, 3, 1, 1, 0.0, 0.0
          , GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));

      panelParams.add(lblFuncion, getGridBagConstraints(3, 0, 2, 1, 0.0, 0.0
          , GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
      panelParams.add(editFuncion, getGridBagConstraints(3, 1, 2, 1, 0.0, 0.0
          , GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
      panelParams.add(lblPobInicial, getGridBagConstraints(3, 2, 1, 1, 0.0, 0.0
          , GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
      panelParams.add(editPobInicial, getGridBagConstraints(4, 2, 1, 1, 0.0, 0.0
          , GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
      panelParams.add(lblProbCruz, getGridBagConstraints(3, 4, 1, 1, 0.0, 0.0
          , GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
      panelParams.add(editProbCruz, getGridBagConstraints(4, 4, 1, 1, 0.0, 0.0
          , GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
      panelParams.add(lblProbMut, getGridBagConstraints(0, 4, 1, 1, 0.0, 0.0
          , GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
      panelParams.add(editProbMut, getGridBagConstraints(1, 4, 1, 1, 0.0, 0.0
          , GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
//        panel1.add(scrollPanel, BorderLayout.CENTER);
//        scrollPanel.add(graph, null);
      panel1.add(graph, BorderLayout.CENTER);
   }

   /** Ahora pongo algunos metodos para hacer compatible con JDK 1.1
    */

   private GridBagConstraints getGridBagConstraints(int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, Insets insets,
       int ipadx, int ipady)
   {
      GridBagConstraints constraints = new GridBagConstraints();
      constraints.gridx = gridx;
      constraints.gridy = gridy;
      constraints.gridwidth = gridwidth;
      constraints.gridheight = gridheight;
      constraints.weightx = weightx;
      constraints.weighty = weighty;
      constraints.anchor = anchor;
      constraints.fill = fill;
      constraints.insets = insets;
      constraints.ipadx = ipadx;
      constraints.ipady = ipady;
      return constraints;
   }

   public int getWidth()
   {
      return getSize().width;
   }

   public int getHeight()
   {
      return getSize().height;
   }

   private void initialize()
   {
      // Primero inicializo algun aspecto grafico
//    scrollOpciones.setSize(getWidth(), 150);
      btnAyuda.setSize(btnAyuda.getSize().width, 10);
      graphVarSelector.setSize(25, 12);
      statusBar.addMouseListener(new MouseAdapter()
      {
         public void mouseClicked(MouseEvent evt)
         {
            if (evt.getClickCount() == 2)
            {
               statusBar.setText("Motor de Algoritmos Genticos - (u)2003, Gustavo Brown Rodriguez");
            }
            else if (evt.getClickCount() > 2)
            {
               statusBar.setText("Comments: alegus@adinet.com.uy");
            }
         }
      });

      // Ahora cargo el archivo de ayuda
      try
      {
         InputStream inputStream = this.getClass().getResourceAsStream("ayuda.txt");
         if (inputStream == null)
         {
            showMsg("No se puede cargar el archivo 'ayuda.txt'...");
            System.err.println("No se puede cargar el archivo 'ayuda.txt'...");
            textAreaAyuda.setText("No se pudo cargar el archivo 'ayuda.txt'");
         }
         else
         {
            BufferedInputStream is = new BufferedInputStream(inputStream);
            byte[] CHUNK = new byte[1024];
            byte[] ayuda = new byte[0];
            int bytes = -1;
            while ( (bytes = is.read(CHUNK)) != -1)
            {
               byte[] temp = new byte[ayuda.length + bytes];
               System.arraycopy(ayuda, 0, temp, 0, ayuda.length);
               System.arraycopy(CHUNK, 0, temp, ayuda.length, bytes);
               ayuda = temp;
            }

            textAreaAyuda.setText(new String(ayuda));
            inputStream.close();
         }
      }
      catch (Exception e)
      {
         e.printStackTrace();
         showMsg(e.toString());
      }

      // Ahora cargo las funciones
      try
      {
         InputStream inputStream = this.getClass().getResourceAsStream("funciones.ini");
         if (inputStream == null)
         {
            showMsg("No se puede cargar el archivo 'funciones.ini'...");
            System.err.println("No se puede cargar el archivo 'funciones.ini'...");
         }
         else
         {
            props.load(inputStream);
            inputStream.close();
         }
      }
      catch (Exception e)
      {
         e.printStackTrace();
         showMsg(e.toString());
      }
      for (Enumeration enum = props.sectionNames(); enum.hasMoreElements(); )
      {
         String funcName = (String) enum.nextElement();
         showMsg("Parseando funcion " + funcName);
         listFunciones.add(funcName);
      }
      addComponentListener(this);
   }

   /**Start the applet*/
   public void start()
   {
   }

   /**Stop the applet*/
   public void stop()
   {
   }

   /**Destroy the applet*/
   public void destroy()
   {
   }

   /**Get Applet information*/
   public String getAppletInfo()
   {
      return "Applet Information";
   }

   /**Get parameter info*/
   public String[][] getParameterInfo()
   {
      return null;
   }

   /**Main method*/
   public static void main(String[] args)
   {
      FunctionSolverAppletAWT applet = new FunctionSolverAppletAWT();
      applet.isStandalone = true;
      Frame frame;
      frame = new Frame()
      {
         protected void processWindowEvent(WindowEvent e)
         {
            super.processWindowEvent(e);
            if (e.getID() == WindowEvent.WINDOW_CLOSING)
            {
               System.exit(0);
            }
         }

         public synchronized void setTitle(String title)
         {
            super.setTitle(title);
            enableEvents(AWTEvent.WINDOW_EVENT_MASK);
         }
      };
      frame.setTitle("MotorAG");
      frame.setBackground(Color.lightGray);
      frame.add(applet, BorderLayout.CENTER);
      applet.init();
      applet.start();
      frame.setSize(480, 380);
      Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
      frame.setLocation( (d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
      frame.setVisible(true);
   }

   /** ShowMSg
    * @param msg Mensaje a desplegar en la statusBar
    */
   public void showMsg(String msg)
   {
      statusBar.setText(msg);
   }

   void btnAyuda_actionPerformed(ActionEvent e)
   {
      if (e.getActionCommand().equalsIgnoreCase("Ayuda"))
      {
         btnAyuda.setActionCommand("finAyuda");
         textAreaAyuda.setVisible(true);
         btnAyuda.setLabel("Ayuda-");
      }
      else
      {
         btnAyuda.setActionCommand("Ayuda");
         textAreaAyuda.setVisible(false);
         btnAyuda.setLabel("Ayuda");
      }
      doLayout();
      this.panel1.doLayout();
      this.panelButtons.doLayout();
      refreshLayout();
   }

   void listFunciones_itemStateChanged(ItemEvent e)
   {
      showMsg(listFunciones.getSelectedItem() + " seleccionado");
      procesoSeleccion();
   }

   void setGraphVarSelector()
   {
      showMsg(graphVarSelector.getSelectedItem() + " seleccionado");
      graph.setCurVarIndependiente(graphVarSelector.getSelectedIndex());
   }

   protected String funcName = "";

   private void procesoSeleccion()
   {
      saveParms();
      lastListParms = -1;
      funcName = listFunciones.getSelectedItem();

      listParms.removeAll();
      listParms.add("Generacion", 0);
      listParms.add("Seleccion", 1);
      listParms.add("FitnessScaler", 2);
      setCantParms();
      listParms.select(0);
      listParms_itemStateChanged(null);
   }

   void listParms_itemStateChanged(ItemEvent e)
   {
      // Primero impacto los cambios en la estructura del ParseINI
      saveParms();
      saveArgs();
      lastListParms = listParms.getSelectedIndex();
      loadParms();
      refreshLayout();
   }

   private void setCantParms()
   {
      while (listParms.getItemCount() > 3)
      {
         listParms.remove(3);
      }
      int cantParams = Integer.parseInt(props.getProperty(funcName, "IndividuoParametros", "1"));
      if (cantParams == 1)
      {
         listParms.add("Variable x", 3);
      }
      else
      {
         for (int i = 2; i <= cantParams + 1; i++)
         {
            listParms.add("Variable f(" + (i - 1) + ")", i + 2);
         }
      }
   }

   private void setFuncion()
   {
      if (!getParm("Funcion", "none").toLowerCase().trim().equalsIgnoreCase(editFuncion.getText().toLowerCase().trim()))
      { // Si la funcion cambi, calculo la cantidad de parametros
         // Lo primero que hago es ver si hay expresiones del tipo f(N) donde N es un nmero
         String expr = editFuncion.getText().trim();
         int cantVars = 0;
         if (expr.indexOf("f(") == -1)
         { // Si no se encuentra ninguna subexpresion del tipo f(N) entonces se trata de una funcion
            // de una sola variable
            cantVars = 1;
         }
         else
         { // busco el valor mayor de N para las subexpresiones f(N) en la expresion
            int index;
            while ( (index = expr.indexOf("f(")) != -1)
            {
               int index2 = expr.indexOf(")", index);
               if (index2 == -1)
               { // Si caigo aqui probablemente la expresion est mal formada
                  showMsg("Warning: expresin mal formada (parentesis no balanceados)");
                  cantVars = -1;
                  break;
               }
               try
               {
                  int varId = Integer.parseInt(expr.substring(index + 2, index2));
                  if (varId > cantVars)
                  {
                     cantVars = varId;
                  }
               }
               catch (NumberFormatException e)
               {
                  showMsg("Warning: expresion mal formada: " + expr.substring(index, index2 + 1));
                  cantVars = -1;
                  break;
               }
               expr = expr.substring(index2);
            }
         }
         if (cantVars != -1)
         {
            props.setProperty(funcName, "IndividuoParametros", "" + cantVars);
            showMsg("La funcion contiene " + cantVars + " variables");
            setCantParms();
            refreshLayout();
         }
      }
      setParm("Funcion", editFuncion.getText().trim());
   }

   private static final int PARM_NONE = -1;
   private static final int PARM_GENERACION = 0;
   private static final int PARM_SELECCION = 1;
   private static final int PARM_FITNESS_SCALER = 2;
   private static final int PARM_INDIVIDUO_ARGS = 3;
   private static final int PARM_CRUZAMIENTO = 0;
   private static final int PARM_MUTACION = 1;
   private static final int PARM_RANGO = 2;

   /** Guarda los parametros en el ParseINI
    **/
   protected void saveParms()
   {
      switch (lastListParms)
      {
         case PARM_NONE:
            break;
         case PARM_GENERACION:
            setParm("Generacion", comboSel.getSelectedItem());
            setFuncion();
            setParm("PoblacionInicial", editPobInicial.getText());
            setParm("ProbabilidadCruzamiento", editProbCruz.getText());
            setParm("ProbabilidadMutacion", editProbMut.getText());
            break;
         case PARM_SELECCION:
            setParm("Seleccion", comboSel.getItem(lastComboSel));
            switch (lastComboSel)
            {
               case 2:
                  setParm("SeleccionParmQ", editArg1.getText());
                  setParm("SeleccionParmK", editArg2.getText());
                  break;
               case 4:
                  setParm("SeleccionParmQ", editArg1.getText());
                  setParm("SeleccionParmK", editArg2.getText());
                  break;
            }
            break;
         case PARM_FITNESS_SCALER:
            setParm("FitnessScaler", comboSel.getItem(lastComboSel));
            switch (lastComboSel)
            {
               case 1:
               case 5:
                  setParm("FitnessScalerParmA", editArg1.getText());
                  setParm("FitnessScalerParmB", editArg2.getText());
                  break;
               case 4:
                  setParm("FitnessScalerParmSigma", editArg1.getText());
                  break;
            }
            break;
         case PARM_INDIVIDUO_ARGS:
            saveArgs();
         default: // Si se trata de los parametros del individuo
            break;
      }
   }

   /** Carga los parametros del ParseINI
    **/
   protected void loadParms()
   {
      listArgs.removeAll();
      comboSel.removeAll();
      lastComboSel = 0;
      switch (lastListParms)
      {
         case PARM_NONE:
            break;
         case PARM_GENERACION:
            comboSel.addItem("Simple");
            comboSel.addItem("DeJong");
            comboSel.select(getParm("Generacion", "DeJong"));
            editFuncion.setText(getParm("Funcion", "Introduzca la funcion"));
            editPobInicial.setText(getParm("PoblacionInicial", "100"));
            editProbCruz.setText(getParm("ProbabilidadCruzamiento", "0.85"));
            editProbMut.setText(getParm("ProbabilidadMutacion", "0.05"));

            lastComboSel = comboSel.getSelectedIndex();
            resetArgs();
            listArgs.setVisible(false);
            setGenParmsVisible(true, true);
            lastListArgs = -1;
            break;
         case PARM_SELECCION:
            listArgs.setVisible(false);
            setGenParmsVisible(false, true);
            lastListArgs = -1;
            resetArgs();
            comboSel.addItem("Ruleta");
            comboSel.addItem("Estocastico Univ");
            comboSel.addItem("TorneoQK");
            comboSel.addItem("Elitista+Ruleta");
            comboSel.addItem("Elitista+TorneoQK");
            comboSel.addItem("Elitista+Estocas");
            comboSel.select(getParm("Seleccion", "Ruleta"));
            lastComboSel = comboSel.getSelectedIndex();
            switch (comboSel.getSelectedIndex())
            {
               case 2:
                  setArgs1("Q", "SeleccionParmQ", "2");
                  setArgs2("K", "SeleccionParmK", "5");
                  break;
               case 4:
                  setArgs1("Q", "SeleccionParmQ", "2");
                  setArgs2("K", "SeleccionParmK", "3");
                  break;
               default:
                  break;
            }
            break;
         case PARM_FITNESS_SCALER:
            listArgs.setVisible(false);
            setGenParmsVisible(false, true);
            lastListArgs = -1;
            resetArgs();
            comboSel.addItem("Ninguno");
            comboSel.addItem("ScalerAxB");
            comboSel.addItem("Inversa");
            comboSel.addItem("Positivo");
            comboSel.addItem("Especiacion");
            comboSel.addItem("Positivo+AxB");
            comboSel.addItem("Positivo+Inversa");
            comboSel.addItem("Inversa+Positivo");
            comboSel.select(getParm("FitnessScaler", "Ninguno"));
            lastComboSel = comboSel.getSelectedIndex();
            switch (comboSel.getSelectedIndex())
            {
               case 1:
               case 5:
                  setArgs1("A", "FitnessScalerParmA", "-1");
                  setArgs2("B", "FitnessScalerParmB", "0");
                  break;
               case 4:
                  setArgs1("Sigma", "FitnessScalerParmSigma", "20");
                  if (Integer.parseInt(props.getProperty(funcName, "IndividuoParametros", "1")) != 1)
                  {
                     showMsg("Warning: el scaler de especiacion solo funciona con funciones de 1 sola variable");
                  }
                  break;
               default:
                  break;
            }
            break;
         case PARM_INDIVIDUO_ARGS:
         default: // Si se trata de los parametros del individuo
            lastListArgs = 0;
            listArgs.add("Cruzamiento", 1);
            listArgs.add("Mutacion", 2);
            listArgs.add("Rango", 3);
            listArgs.select(0);
            listArgs.setVisible(true);
            setGenParmsVisible(false, false);
            refreshLayout();
            loadArgs();
            break;
      }
      refreshLayout();
   }

   private void setGenParmsVisible(boolean visible, boolean funcVisible)
   {
      lblFuncion.setVisible(funcVisible);
      editFuncion.setVisible(funcVisible);
      lblPobInicial.setVisible(visible);
      editPobInicial.setVisible(visible);
      lblProbCruz.setVisible(visible);
      editProbCruz.setVisible(visible);
      lblProbMut.setVisible(visible);
      editProbMut.setVisible(visible);
   }

   protected void saveArgs()
   {
      if (lastListArgs == -1)
      {
         switch (lastListParms)
         {
            case PARM_SELECCION:
               setParm("Seleccion", comboSel.getItem(lastComboSel));
               switch (lastComboSel)
               {
                  case 2:
                     setParm("SeleccionParmQ", editArg1.getText());
                     setParm("SeleccionParmK", editArg2.getText());
                     break;
                  case 4:
                     setParm("SeleccionParmQ", editArg1.getText());
                     setParm("SeleccionParmK", editArg2.getText());
                     break;
               }
               break;
            case PARM_FITNESS_SCALER:
               setParm("FitnessScaler", comboSel.getItem(lastComboSel));
               switch (lastComboSel)
               {
                  case 1:
                  case 5:
                     setParm("FitnessScalerParmA", editArg1.getText());
                     setParm("FitnessScalerParmB", editArg2.getText());
                     break;
                  case 4:
                     setParm("FitnessScalerParmSigma", editArg1.getText());
                     break;
               }
               break;
         }
         return;
      }
      switch (lastListArgs)
      {
         case PARM_MUTACION:
            setParm("Mutacion", comboSel.getItem(lastComboSel));
            switch (lastComboSel)
            {
               case 1:
                  setParm("MutacionParmHillClimberN", editArg1.getText());
            }
            break;
         case PARM_CRUZAMIENTO:
            setParm("Cruzamiento", comboSel.getItem(lastComboSel));
            switch (lastComboSel)
            {
               case 1:
                  setParm("CruzamientoParmCrossPoints", editArg1.getText());
            }
            break;
         case PARM_RANGO:
            comboSel.setVisible(true);
            setParm("RangoIzq", editArg1.getText());
            setParm("RangoDer", editArg2.getText());
            setParm("RangoBits", editArg3.getText());
            break;
      }
   }

   protected void getArgs()
   {
      if (lastListArgs == -1)
      {
         switch (lastListParms)
         {
            case PARM_SELECCION:
               resetArgs();
               comboSel.select(lastComboSel);
               switch (comboSel.getSelectedIndex())
               {
                  default:
                  case 0:
                     break;
                  case 1:
                     break;
                  case 2:
                     setArgs1("Q", "SeleccionParmQ", "2");
                     setArgs2("K", "SeleccionParmK", "5");
                     break;
                  case 3:
                     break;
                  case 4:
                     setArgs1("Q", "SeleccionParmQ", "2");
                     setArgs2("K", "SeleccionParmK", "3");
                     break;
                  case 5:
                     break;
               }
               break;
            case PARM_FITNESS_SCALER:
               resetArgs();
               comboSel.select(lastComboSel);
               switch (comboSel.getSelectedIndex())
               {
                  case 1:
                  case 5:
                     setArgs1("A", "FitnessScalerParmA", "-1");
                     setArgs2("B", "FitnessScalerParmB", "0");
                     break;
                  case 4:
                     setArgs1("Sigma", "FitnessScalerParmSigma", "20");
                     if (Integer.parseInt(props.getProperty(funcName, "IndividuoParametros", "1")) != 1)
                     {
                        showMsg("Warning: el scaler de especiacion solo funciona con funciones de 1 sola variable");
                     }
                     break;
               }
               break;
         }
         return;
      }
      resetArgs();
      switch (lastListArgs)
      {
         case PARM_MUTACION:
            comboSel.select(lastComboSel);
            switch (comboSel.getSelectedIndex())
            {
               default:
               case 0:
                  break;
               case 1:
                  setArgs1("N", "MutacionParmHillClimberN", "3");
                  break;
            }
            break;
         case PARM_CRUZAMIENTO:
            comboSel.select(lastComboSel);
            switch (comboSel.getSelectedIndex())
            {
               case 1:
                  setArgs1("CrossPoints", "CruzamientoParmCrossPoints", "3");
            }
            break;
         case PARM_RANGO:
            setArgs1("Desde", "RangoIzq", "-15");
            setArgs2("Hasta", "RangoDer", "+15");
            setArgs3("Bits", "RangoBits", "30");
            break;
      }
      refreshLayout();
   }

   protected void loadArgs()
   {
      if (lastListArgs == -1)
      {
         return;
      }
      comboSel.removeAll();
      resetArgs();
      switch (lastListArgs)
      {
         case PARM_MUTACION:
            comboSel.add("BitFlip");
            comboSel.add("HillClimber");
            comboSel.select(getParm("Mutacion", "BitFlip"));
            switch (comboSel.getSelectedIndex())
            {
               default:
               case 0:
                  break;
               case 1:
                  setArgs1("N", "MutacionParmHillClimberN", "3");
                  break;
            }
            break;
         case PARM_CRUZAMIENTO:
            comboSel.add("SPX");
            comboSel.add("MPX");
            comboSel.select(getParm("Cruzamiento", "SPX"));
            switch (comboSel.getSelectedIndex())
            {
               case 1:
                  setArgs1("CrossPoints", "CruzamientoParmCrossPoints", "3");
            }
            break;
         case PARM_RANGO:
            comboSel.setVisible(false);
            setArgs1("Desde", "RangoIzq", "-15");
            setArgs2("Hasta", "RangoDer", "+15");
            setArgs3("Bits", "RangoBits", "30");
            break;
      }
      lastComboSel = comboSel.getSelectedIndex();
   }

   private void resetArgs()
   {
      lblArg1.setVisible(false);
      editArg1.setVisible(false);
      lblArg2.setVisible(false);
      editArg2.setVisible(false);
      lblArg3.setVisible(false);
      editArg3.setVisible(false);
   }

   private void setArgs1(String lbl, String prop, String def)
   {
      lblArg1.setText(lbl);
      editArg1.setText(getParm(prop, def));
      lblArg1.setVisible(true);
      editArg1.setVisible(true);
   }

   private void setArgs2(String lbl, String prop, String def)
   {
      lblArg2.setText(lbl);
      editArg2.setText(getParm(prop, def));
      lblArg2.setVisible(true);
      editArg2.setVisible(true);
   }

   private void setArgs3(String lbl, String prop, String def)
   {
      lblArg3.setText(lbl);
      editArg3.setText(getParm(prop, def));
      lblArg3.setVisible(true);
      editArg3.setVisible(true);
   }

   void listArgs_itemStateChanged(ItemEvent e)
   {
      showMsg(listArgs.getSelectedItem() + " seleccionado");
      // Primero guardo el estado anterior
      saveArgs();
      lastListArgs = listArgs.getSelectedIndex();
      lastComboSel = 0;
      // Y ahora coloco la nueva info
      loadArgs();
      refreshLayout();
   }

   private String getParm(String parm, String def)
   {
      if (lastListParms >= PARM_INDIVIDUO_ARGS)
      {
         return props.getProperty(funcName, parm + "_" + (lastListParms - PARM_INDIVIDUO_ARGS + 1), def);
      }
      else
      {
         return props.getProperty(funcName, parm, def);
      }
   }

   private void setParm(String parm, String value)
   {
      if (lastListParms >= PARM_INDIVIDUO_ARGS)
      {
         props.setProperty(funcName, parm + "_" + (lastListParms - PARM_INDIVIDUO_ARGS + 1), value);
      }
      else
      {
         props.setProperty(funcName, parm, value);
      }
   }

   protected int lastComboSel = 0;
   void comboSel_itemStateChanged(ItemEvent e)
   {
      saveArgs();
      lastComboSel = comboSel.getSelectedIndex();
      getArgs();
   }

   private boolean running = false;
   Label lblProbMut = new Label();
   TextField editArg3 = new TextField();
   Choice comboSel = new Choice();
   Choice graphVarSelector = new Choice();
   TextField editArg2 = new TextField();
   TextField editProbMut = new TextField();
   TextField editArg1 = new TextField();
   java.awt.List listParms = new java.awt.List();
   GridBagLayout gridBagLayout = new GridBagLayout();
   Label lblFuncion = new Label();
   TextField editFuncion = new TextField(15);
   TextField editPobInicial = new TextField();
   TextField editProbCruz = new TextField();
   Panel panelParams = new Panel();
   Label lblArg3 = new Label();
   Label lblArg2 = new Label();
   Label lblArg1 = new Label();
   java.awt.List listArgs = new java.awt.List();
   Label lblProbCruz = new Label();
   Label lblPobInicial = new Label();

   private void setEditable(boolean editable)
   {
      editArg1.setEnabled(editable);
      editArg2.setEnabled(editable);
      editArg3.setEnabled(editable);
      comboSel.setEnabled(editable);
      editFuncion.setEnabled(editable);
      editPobInicial.setEnabled(editable);
      editProbCruz.setEnabled(editable);
      editProbMut.setEnabled(editable);
   }

   private void refreshLayout()
   {
      panelOpciones.doLayout();
      panelParams.doLayout();
   }

   private static int IterarNVeces = 50;

   /** Este evento se ejecuta al presionar uno de los botones de accion (Correr/Paso/Reset)
    */
   void button_actionPerformed(ActionEvent e)
   {
      String command = e.getActionCommand();
      try
      {
         if (command.equalsIgnoreCase("Reset") && running)
         {
            running = false;
            refreshLayout();
            motorRunnerThread.stop(); // Interrumpimos la operacion que se este desarrollando en el motor
            setEditable(true);
            graph.reset();
            motorRunnerThread = new MotorRunnerThread();
            return;
         }

         if (command.equalsIgnoreCase("Correr"))
         {
            if (!running)
            {
               if (initMotor())
               {
                  motorRunnerThread.iterar();
               }
               return;
            }
            if (running)
            {
               motorRunnerThread.iterarN(IterarNVeces);
               return;
            }
         }

         if (command.equalsIgnoreCase("Paso"))
         {
            if (!running)
            {
               if (initMotor())
               {
                  motorRunnerThread.paso();
               }
               return;
            }
            if (running)
            {
               motorRunnerThread.paso();
               return;
            }
         }
      }
      catch (Throwable ex)
      {
         showMsg("Error en Motor: " + ex.toString());
         ex.printStackTrace();
      }
   }

   private double getDoubleProp(String prop, int parmNum) throws Exception
   {
      try
      {
         return new Double(props.getProperty(funcName, prop + (parmNum > 0 ? "_" + parmNum : ""), "No definido")).doubleValue();
      }
      catch (Exception e)
      {
         throw new MotorException("Error parseando property: " + prop + " -> " + e.toString());
      }
   }

   private int getIntProp(String prop, int parmNum) throws Exception
   {
      try
      {
         return new Integer(props.getProperty(funcName, prop + (parmNum > 0 ? "_" + parmNum : ""), "No definido")).intValue();
      }
      catch (Exception e)
      {
         throw new MotorException("Error parseando property: " + prop + " -> " + e.toString());
      }
   }

   private String getStringProp(String prop, int parmNum)
   {
      return props.getProperty(funcName, prop + (parmNum > 0 ? "_" + parmNum : ""), "No definido");
   }

   /** Inicializa el MotorAG
    *  @return booleano indicando si se pudo inicializar el motor
    **/
   public boolean initMotor()
   {
      saveParms();
      saveArgs();
      try
      {
         showMsg("Parseando datos...");
         int cantParms = new Integer(getIntProp("IndividuoParametros", 0)).intValue();
         graphVarSelector.removeAll();
         if (cantParms != 1)
         {
            for (int i = 0; i < cantParms; i++)
            {
               graphVarSelector.addItem("f(" + (i + 1) + ")");
            }
            graphVarSelector.select(0);
            graphVarSelector.setEnabled(true);
            graphVarSelector.setVisible(true);
            setGraphVarSelector();
            refreshLayout();
         }
         else
         {
            graphVarSelector.addItem("x");
            graphVarSelector.select(0);
            graphVarSelector.setEnabled(false);
            graphVarSelector.setVisible(true);
            refreshLayout();
         }

         IGeneracion generacion;
         IIndividuo individuo;
         ISeleccion seleccion;
         ICruzamiento cruzamiento;
         IMutacion mutacion;
         FitnessScaler fitnessScaler = null;
         IIndividuo[] parmIndividuo = new IIndividuo[cantParms];
         ICruzamiento[] parmCruzamiento = new ICruzamiento[cantParms];
         IMutacion[] parmMutacion = new IMutacion[cantParms];

         // Primero instancio todos los operadores que se van a utilizar

         String tipoSeleccion = getStringProp("Seleccion", 0);
         if (tipoSeleccion.equalsIgnoreCase("Ruleta"))
         {
            seleccion = new SeleccionRuleta();
         }
         else if (tipoSeleccion.equalsIgnoreCase("Estocastico Univ"))
         {
            seleccion = new SeleccionEstocasticaUniversal();
         }
         else if (tipoSeleccion.equalsIgnoreCase("TorneoQK"))
         {
            seleccion = new SeleccionTorneoQK(getIntProp("SeleccionParmQ", 0), getIntProp("SeleccionParmK", 0));
         }
         else if (tipoSeleccion.equalsIgnoreCase("Elitista+Ruleta"))
         {
            seleccion = new SeleccionElitista(new SeleccionRuleta());
         }
         else if (tipoSeleccion.equalsIgnoreCase("Elitista+TorneoQK"))
         {
            seleccion = new SeleccionElitista(new SeleccionTorneoQK(getIntProp("SeleccionParmQ", 0), getIntProp("SeleccionParmK", 0)));
         }
         else if (tipoSeleccion.equalsIgnoreCase("Elitista+Estocas"))
         {
            seleccion = new SeleccionElitista(new SeleccionEstocasticaUniversal());
         }
         else
         {
            throw new IllegalArgumentException("El operador de seleccion es invalido");
         }

         String tipoFitnessScaler = getStringProp("FitnessScaler", 0);
         if (tipoFitnessScaler.equalsIgnoreCase("ScalerAxB"))
         {
            fitnessScaler = new FitnessScalerAxB(new FitnessScalerSink(), getDoubleProp("FitnessScalerParmA", 0), getDoubleProp("FitnessScalerParmB", 0));
         }
         else if (tipoFitnessScaler.equalsIgnoreCase("Inversa"))
         {
            fitnessScaler = new FitnessScalerInversa(new FitnessScalerSink());
         }
         else if (tipoFitnessScaler.equalsIgnoreCase("Positivo"))
         {
            fitnessScaler = new FitnessScalerPositive(new FitnessScalerSink());
         }
         else if (tipoFitnessScaler.equalsIgnoreCase("Especiacion"))
         {
            fitnessScaler = new FitnessScalerEspeciacion(new FitnessScalerSink(), getIntProp("FitnessScalerParmSigma", 0));
            if (Integer.parseInt(props.getProperty(funcName, "IndividuoParametros", "1")) != 1)
            {
               throw new MotorException("El scaler de especiacion solo funciona con funciones de 1 sola variable");
            }
         }
         else if (tipoFitnessScaler.equalsIgnoreCase("Positivo+AxB"))
         {
            fitnessScaler = new FitnessScalerPositive(new FitnessScalerAxB(new FitnessScalerSink(), getDoubleProp("FitnessScalerParmA", 0), getDoubleProp("FitnessScalerParmB", 0)));
         }
         else if (tipoFitnessScaler.equalsIgnoreCase("Positivo+Inversa"))
         {
            fitnessScaler = new FitnessScalerPositive(new FitnessScalerInversa(new FitnessScalerSink()));
         }
         else if (tipoFitnessScaler.equalsIgnoreCase("Inversa+Positivo"))
         {
            fitnessScaler = new FitnessScalerInversa(new FitnessScalerPositive(new FitnessScalerSink()));
         }

         for (int i = 0; i < cantParms; i++)
         {
            int curParm = i + 1;
            // Si la funcion toma valores enteros, se debe especificar rangoBits == 0
            parmIndividuo[i] = new FuncionExpresion(getStringProp("Funcion", 0), getDoubleProp("RangoIzq", curParm), getDoubleProp("RangoDer", curParm),
                getIntProp("RangoBits", curParm), (cantParms == 1 ? "x" : "f(" + curParm + ")"));
            String tipoCruzamiento = getStringProp("Cruzamiento", curParm);
            if (tipoCruzamiento.equalsIgnoreCase("SPX"))
            {
               parmCruzamiento[i] = new CruzamientoSPX();
            }
            else if (tipoCruzamiento.equalsIgnoreCase("MPX"))
            {
               parmCruzamiento[i] = new CruzamientoMPX(getIntProp("CruzamientoParmCrossPoints", curParm));
            }
            else
            {
               throw new IllegalArgumentException("El operador de cruzamiento para la variable " + curParm + " es invalido");
            }

            String tipoMutacion = getStringProp("Mutacion", curParm);
            if (tipoMutacion.equalsIgnoreCase("BitFlip"))
            {
               parmMutacion[i] = new MutacionBitFlip();
            }
            else if (tipoMutacion.equalsIgnoreCase("HillClimber"))
            {
               parmMutacion[i] = new MutacionHillClimber(getIntProp("MutacionParmHillClimberN", curParm));
            }
            else
            {
               throw new IllegalArgumentException("El operador de mutacion para la variable " + curParm + " es invalido");
            }
         }

         if (cantParms == 1)
         { // Si se trata de una funcion de una sola variable
            individuo = parmIndividuo[0];
            cruzamiento = parmCruzamiento[0];
            mutacion = parmMutacion[0];
         }
         else
         { // Si se trata de funciones de varias variables
            individuo = new IndividuoMultipleFuncionExpresion(getStringProp("Funcion", 0), parmIndividuo);
            OperadorMultiple operadorMultiple = new OperadorMultiple(parmCruzamiento, parmMutacion);
            cruzamiento = operadorMultiple;
            mutacion = operadorMultiple;
         }

         // Ahora creo una instancia de Generacion
         String tipoGeneracion = getStringProp("Generacion", 0);
         if (tipoGeneracion.equalsIgnoreCase("Simple"))
         {
            generacion = new GeneracionSimple(individuo, getIntProp("PoblacionInicial", 0),
                                              getDoubleProp("ProbabilidadCruzamiento", 0), getDoubleProp("ProbabilidadMutacion", 0));
         }
         else if (tipoGeneracion.equalsIgnoreCase("DeJong"))
         {
            generacion = new GeneracionSimpleDeJong(individuo, getIntProp("PoblacionInicial", 0),
                getDoubleProp("ProbabilidadCruzamiento", 0), getDoubleProp("ProbabilidadMutacion", 0));
         }
         else
         {
            throw new IllegalArgumentException("La tipo de Generacion seleccionado es invalido");
         }

         motor = new MotorAG(generacion, seleccion, cruzamiento, mutacion);
         motor.setFitnessScaler(fitnessScaler);

         graph.initialize(motor);
         running = true;
         setEditable(false);
         return true;
      }
      catch (Throwable e)
      {
         showMsg("No se pudo incializar el motor: " + e.getMessage());
         e.printStackTrace();
         return false;
      }
   }

   /******************************
    * Interfaz ComponentListener *
    ******************************/
   public void componentHidden(ComponentEvent evt)
   {
      ;
   }

   public void componentShown(ComponentEvent evt)
   {
      ;
   }

   public void componentMoved(ComponentEvent evt)
   {
      ;
   }

   public void componentResized(ComponentEvent evt)
   {
      int rows = super.getSize().height / 45;
      textAreaAyuda.setRows(rows < 5 ? 5 : rows);
      doLayout();
      this.panel1.doLayout();
      this.panelButtons.doLayout();
      refreshLayout();
   }

   /** Este worker thread es el encargado de ejecutar el algoritmo
    *  Lo hacemos en un thread aparte porque sino bloqueamos el GUI
    */
   class MotorRunnerThread extends Thread
   {
      public MotorRunnerThread()
      {
         super("MotorRunnerThread");
         super.setDaemon(true);
         super.start();
      }

      public final int NONE = 0;
      public final int ITERAR = 1;
      public final int ITERARN = 2;
      public final int PASO = 3;

      private int whatToDo = NONE;
      private int NVeces = 50;

      public synchronized void iterar()
      {
         whatToDo = ITERAR;
         notifyAll();
      }

      public synchronized void iterarN(int NVeces)
      {
         this.NVeces = NVeces;
         whatToDo = ITERARN;
         notifyAll();
      }

      public synchronized void paso()
      {
         whatToDo = PASO;
         notifyAll();
      }

      public void run()
      {
         while (true)
         {
            try
            {
               synchronized (this)
               {
                  wait();
               }
               switch (whatToDo)
               {
                  case ITERAR:
                     motor.iterar();
                     break;
                  case ITERARN:
                     motor.iterar(NVeces);
                     break;
                  case PASO:
                     motor.iterarOnce();
                     break;
               }
               whatToDo = NONE;
            }
            catch (Throwable e)
            {
               if (! (e instanceof ThreadDeath) &&
                   ! (e instanceof InterruptedException))
               {
                  e.printStackTrace();
                  showMsg(e.getMessage());

               }
               else
               {
                  switch (whatToDo)
                  {
                     case ITERAR:
                        showMsg("Se ha interrumpido la operacion de correr");
                        break;
                     case ITERARN:
                        showMsg("Se ha interrumpido la operacion de iterar " + NVeces + " veces");
                        break;
                     case PASO:
                        showMsg("Se ha interrumpido la operacion de iterar un paso");
                        break;
                  }
               }
            }
         }
      }
   }
}