package com.brownsoft.ag;

import java.util.*;

/**
 * Esta clase implementa una Generacion simple donde la condicion de parada es que
 * se cumplan 10 iteraciones
 * @author Gustavo Brown
 * @version 1.0
 */
public class GeneracionSimple implements IGeneracion
{
   protected int pobSize;
   protected IIndividuo individuo;
   protected MotorAG motor;
   protected double pCross;
   protected double pMutacion;

   /** Constructor
    * @param individuo Instancia de un individuo
    * @param pobSize tamao de la poblacin
    * @param pCross probabilidad de cruzamiento
    * @param pMutacion probabilidad de mutacin
    */
   public GeneracionSimple(IIndividuo individuo, int pobSize, double pCross, double pMutacion) throws MotorException
   {
      this.individuo = individuo;
      this.pobSize = pobSize;
      this.pCross = pCross;
      this.pMutacion = pMutacion;

      if (pobSize < 1)
      {
         throw new MotorException("La poblacion debe ser mayor a 0");
      }

      if (pCross > 1 || pCross < 0)
      {
         throw new MotorException("pCross debe tener valores entre 0 y 1");
      }

      if (pMutacion > 1 || pMutacion < 0)
      {
         throw new MotorException("pMutacion debe tener valores entre 0 y 1");
      }
   }

   /** Inicializa la generacion
    * @param motor motor asociado a esta instancia
    */
   public void inicializar(MotorAG motor)
   {
      this.motor = motor;
   }

   /** Obtiene la poblacin inicial
    * @return la poblacin
    */
   public Vector getPoblacionInicial()
   {
      Vector poblacion = new Vector();
      for (int i = 0; i < pobSize; i++)
      {
         IIndividuo newIndividual = individuo.getCopy();
         newIndividual.setRandom();
         poblacion.addElement(newIndividual);
      }
      return poblacion;
   }

   /** Obtiene el tamao del mating pool
    */
   public int getMatingSize()
   {
      return pobSize;
   }

   /** Indica cuando debo finalizar las iteraciones
    * @return booleano indicando si debo terminar las iteraciones
    */
   public boolean getFinalizarIteracion()
   {
      return motor.getTotIteraciones() >= 10;
   }

   /** Obtiene la probabilidad de cruzamiento
    * @return double con la probabilidad de cruzamiento
    */
   public double getpCross()
   {
      return pCross;
   }

   /** Obtiene la probabilidad de mutacion
    * @return double con la probabilidad de mutacion
    */
   public double getpMutacion()
   {
      return pMutacion;
   }

   /** Indica que se inica la iteracion
    */
   public void inicioIteracion()
   {
      ;
   }

   /** Indica que se finaliza la iteracion
    */
   public void finIteracion()
   {
      ;
   }

   /** Avisa que finaliz la ejecucin del algoritmo
    */
   public void finAlgoritmo()
   {
      ;
   }
}
