package com.brownsoft.ag;

/**
 * Esta es la interfaz que deben implementar las clases que quieran ser utilizadas
 * como operador de cruzamiento
 * @author Gustavo Brown
 * @version 1.0
 */
public interface ICruzamiento extends IMotorListener
{
   /** Inicializa el operador de cruzamiento
    * @param motor MotorAG asociado
    */
   public void inicializar(MotorAG motor);

   /** Cruza un grupo de individuos
    * @param seleccioandos grupo de individuos a cruzar
    * @return grupo de individuos cruzados
    * @exception InvalidCrossException en caso de que ocurra algun error
    */
   public IIndividuo[] cruzar(IIndividuo[] seleccionados) throws InvalidCrossException;
}
