package com.brownsoft.ag;

import com.brownsoft.ag.*;

/** Esta interfaz debe ser implementada por las clases que deseen manejar
 * el escalado del fitness
 * @see MotorAG.setFitnessScaler
 * @see FitnessScaler -> Clase base a derivar
 * @see FitnessScalerSink -> Ultima clase en el eslabon de la cadena de FitnessScalers
 * @author Gustavo Brown
 * @version 1.0
 */
public interface IFitnessScaler
{
   /** Inicializa el scaler
    *  Este metodo es llamado desde el MotorAG
    *  @param motor el MotorAG asociado a este Scaler
    */
   public void initScaler(MotorAG motor);

   /** Escala un fitness
    *  @param individuo individuo a obtener su fitness
    *  @return fitness escalado
    */
   public double getScaledFitness(IIndividuo individuo);

   /** Escala un fitness
    *  @param fitness Fitness a escalar
    *  @return fitness escalado
    */
   public double getScaledFitness(double fitness);

   /** Obtiene el IIndividuo que esta siendo escalado en este momento
    **/
   public IIndividuo getProcessingIndividual();

   /** Le avisa al Scaler y a su parent que se inicia la iteracion
    *  es decir, debe llamara parent.fireInicioIteracion() y luego a inicioIteracion
    */
   public void fireInicioIteracion();

   /** Avisa que se inicia una nueva iteracin
    */
   public void inicioIteracion();
}